charisma.smartui.IssuesSupport = function () {
  this.changeListeners = new Webr.util.Set();
  charisma.smartui.IssuesSupport.superclass.constructor.call(this);
    

  commonController = this;
    

  var it = this;
  var d = $(document);
  d.keydown(function (e) {
    if (Webr.component.panel.Dialog.isModalVisible() || charisma.smartui.ViewImageAttachment.isVisible()) {
      return true;
    }

    if (!e.targetIsInput() && Webr.util.Key.isApplicable(e, SmartUIShortCuts["ToggleSearchField"]) && (!it.issuesList || !it.issuesList.focused)) {
      //close image attachment by pressing ESC thrown error in IE
      $(it.searchField).focus();
      return false;
    }

    //This hot keys works only on keyDown, workaround for strange behaviour in FF
    if (Webr.util.Key.isApplicable(e, SmartUIShortCuts["IncreaseIssueVisibility"])) {
      it.changeDetailLevel(true);
      return false;
    }

    if (Webr.util.Key.isApplicable(e, SmartUIShortCuts["DecreaseIssueVisibility"])) {
      it.changeDetailLevel(false);
      return false;
    }

    if (Webr.util.Key.isApplicable(e, SmartUIShortCuts["CollapseExpandSidebar"])) {
      it.sidebarToggler.click();
      analytics.trackEvent("sideBar", "keyboardToggle");
      return false;
    }

  });
  trace("App created");
};
{
  var F = new Function();
  F.prototype = charisma.smartui.CommonController.prototype;
  charisma.smartui.IssuesSupport.prototype = new F();
  charisma.smartui.IssuesSupport.prototype.constructor = charisma.smartui.IssuesSupport;
  charisma.smartui.IssuesSupport.superclass = charisma.smartui.CommonController.prototype;
}

charisma.smartui.IssuesSupport.prototype.togglerExceptionsView = function () {
  var issueDescription;
    

  if (this.issuesList) {
    var focusedIssue = this.issuesList.getFocusedIssue();
    if (this.issuesList.isIssueExpanded(focusedIssue)) {
      issueDescription = focusedIssue.find("pre." + "wiki-exception-title").prev();
    }

    if (issueDescription) {
      if (issueDescription.get(0) && issueDescription.click()) {
        this.exceptionStateToggler();
      }

    }

  }

};
charisma.smartui.IssuesSupport.prototype.changeDetailLevel = function (increase) {
  var step = 10;
  var active = $(".view_active");
  var detailLevelLinks = $(".view");
  var ords = [];
  detailLevelLinks.add(active).map(function () {
    ords.push(parseInt($(this).data('view-ord')));
  });
  ords.sort(function (a, b) {
    return a - b;
  });
  var newOrd = parseInt(active.data('view-ord')) + (increase ?step :-step);
  if (newOrd < Math.min.apply(Math, ords)) {
    newOrd = ords[ords.length - 1];
  } else if (newOrd > Math.max.apply(Math, ords)) {
    newOrd = ords[0];
  }

  detailLevelLinks.each(function () {
    if ($(this).attr('data-view-ord') == newOrd) {
      $(this).click();
      return ;
    }

  });
};
charisma.smartui.IssuesSupport.prototype.addChangeListener = function (listener) {
  this.changeListeners.add(listener);
  if (this.issuesList) {
    this.issuesList.addListListener(listener);
  }

};
charisma.smartui.IssuesSupport.prototype.removeChangeListener = function (listener) {
  this.changeListeners.remove(listener);
  if (this.issuesList) {
    this.issuesList.removeListListener(listener);
  }

};
charisma.smartui.IssuesSupport.prototype.updateIssueList = function (config) {
  var list = this.issuesList;
  if (!list) {
    trace("Create new issue list");
    list = new charisma.smartui.IssueList(config);
    this.setComponent("issuesList", list);
    if (!list.hasFocusedIssue()) {
      list.select();
    }

  } else {
    trace("Update issue list");
    list.init(config);
  }

  //create sorting widget
  this.sortController = new charisma.smartui.SortController(config);
};
charisma.smartui.IssuesSupport.prototype.createSidebarToggler = function (toggler, content, sidebar) {
  this.sidebarToggler = new charisma.smartui.SidebarToggler(toggler, content, sidebar);
};
charisma.smartui.IssuesSupport.prototype.toggleSidebar = function (visible) {
  if (this.sidebarToggler) {
    this.sidebarToggler.setVisible(visible);
    this.updateToolBarDimentionsAndFocus();
  }

};
charisma.smartui.IssuesSupport.prototype.updateSidebarTogglerPositionAndHeight = function () {
  if (this.sidebarToggler) {
    this.sidebarToggler.updatePositionAndHeight(this.issuesList.content);
  }

};
charisma.smartui.IssuesSupport.prototype.updateToolBarDimentionsAndFocus = function () {
  this.getToolbar().updateWidth();
  if (this.issuesList.focused) {
    this.issuesList.focus();
  } else {
    this.searchField.focus();
  }

};
charisma.smartui.IssuesSupport.prototype.keyPressed = function (source, e) {
  switch (source) {
  case this.searchSuggest:
    return this.searchSuggestKeyEvent(e);
  case this.issuesList:
    return this.issueListKeyPressed(e);
  }

  return true;
};
charisma.smartui.IssuesSupport.prototype.commandsHide = function (source) {
  if (this.issuesList) {
    this.issuesList.focus();
  }

};
charisma.smartui.IssuesSupport.prototype.searchSuggestKeyEvent = function (e) {
  var res = charisma.smartui.IssuesSupport.superclass.searchSuggestKeyEvent.call(this, e);
  if (res) {
    if (Webr.util.Key.isApplicable(e, SmartUIShortCuts["ToggleSearchField"]) && this.issuesList) {
      this.issuesList.focus();
      return false;
    }

    if (Webr.util.Key.isApplicable(e, SmartUIShortCuts["MoveToIssueListFromSearchField"]) && this.issuesList) {
      this.issuesList.blur();
      this.issuesList.focus();
      return false;
    }

  }

    

  return res;
};
charisma.smartui.IssuesSupport.prototype.issueListKeyPressed = function (e) {
  if (Webr.util.Key.isApplicable(e, SmartUIShortCuts["ToggleSearchField"]) || Webr.util.Key.isApplicable(e, SmartUIShortCuts["MoveToSearchFieldFromIssueList"])) {
    this.issuesList.blur();
    this.searchField.focus();
    return false;
  }

  return true;
};
charisma.smartui.IssuesSupport.prototype.getSelectedIssuesIds = function () {
  trace("getSelectedIssuesIds");
    

  var issueIds = [];
  if (this.newIssueId) {
    issueIds.push(this.newIssueId);
  } else {
    if (this.issuesList) {
      issueIds = this.issuesList.getSelectedIssuesIds();
    }

  }

    

  return issueIds;
};
charisma.smartui.IssuesSupport.prototype.getSelectedIssuesCount = function () {
  if (this.newIssueId) {
    return 1;
  } else {
    if (this.issuesList) {
      return this.issuesList.getCheckedCount();
    }

  }

  return 0;
};
charisma.smartui.IssuesSupport.prototype.initLastCommentPopup = function (popup) {
  this.lastCommentPopup = popup;
  this.lastCommentPopup.checkIfTheSameAnchor = false;
};
charisma.smartui.IssuesSupport.prototype.getFocusedIssueId = function () {
  if (this.newIssueId) {
    return this.newIssueId;
  }

  if (this.issuesList && this.issuesList.hasFocusedIssue()) {
    return this.issuesList.getIssueId(this.issuesList.getFocusedIssue());
  }

  return null;
};
charisma.smartui.IssuesSupport.prototype.getFocusedPresentationIssueId = function () {
  if (this.newIssueId) {
    return '${l10n("CommonController.draft")}';
  }

  if (this.issuesList && this.issuesList.hasFocusedIssue()) {
    return this.issuesList.getVisibleIssueId(this.issuesList.getFocusedIssue());
  }

  return null;
};
charisma.smartui.IssuesSupport.prototype.focusIssue = function () {
  if (this.issuesList) {
    this.issuesList.focus();
  } else {
    this.searchField.focus();
  }

  return true;
};
charisma.smartui.IssuesSupport.prototype.selectIssue = function (issueId) {
  issues.issuesList.unselectIssue(issues.issuesList.getFocusedIssue());
  issues.issuesList.selectIssue(issues.issuesList.getIssueById(issueId));
};
charisma.smartui.IssuesSupport.prototype.commentsLoaded = function (commentsList) {
  var it = this;
  window.setTimeout(function () {
    it.issuesList.setComments(it.issuesList.getFocusedIssue(), commentsList);
    it.issuesList.blur();
    commentsList && commentsList.focus();
  }, 10);
};
charisma.smartui.IssuesSupport.prototype.commentsRefreshed = function (edit) {
  window.setTimeout(function () {
    var selectedComment = this.issuesList.getComments(this.issuesList.getFocusedIssue()).getSelected();
    selectedComment.refresh(edit);
  }.bind(this), 150);
};
charisma.smartui.IssuesSupport.prototype.issueRedrawn = function (issueId, focus) {
  this.issuesList.issueRedrawn(issueId, focus);
};
charisma.smartui.IssuesSupport.prototype.setSearchField = function (searchField, forceComplete) {
  charisma.smartui.IssuesSupport.superclass.setSearchField.call(this, searchField, forceComplete);
  this.focusSearchField();
};
charisma.smartui.IssuesSupport.prototype.getToolbar = function () {
  if (this.issuesList) {
    return this.issuesList.toolbar;
  }

};
charisma.smartui.IssuesSupport.prototype.toggleEditMode = function (edit) {
  this.editMode = edit;
  var fn = edit ?"hide" :"show";
  //issues
  var focusedIssue = this.issuesList.getFocusedIssue();
  var otherIssues = this.issuesList.getIssues().not(".popupComponent").not(focusedIssue);
  //sidebar
  var sidebar = $(".issues-sidebar");
  var toolbarRightButtons = $(".issues-toolbar_r").find(".ring-btn").not(".edit-issue-btn");
  toolbarRightButtons.attr('disabled', edit);
  var others = $(".selectAll, .jt-player, .search-south, .reset-order");
  others[fn]();
  charisma.smartui.IssuesSupport.superclass.toggleEditMode.call(this, edit);
  sidebar.next().toggleClass("issues-center_edit");
  if (edit) {
    $("body").addClass("issue-inline-edit-mode");
    otherIssues.hide();
    $(".sidebar-toggler").hide();
    if ($(".noSidebar").length === 0) {
      sidebar.hide();
    }

    $(".default-layout").toggleClass("edit-mode");
    $(".editMode").show();
    focusedIssue.show();
  } else {
    $("body").removeClass("issue-inline-edit-mode");
    $(".editMode").hide();
    $(".default-layout").toggleClass("edit-mode");
    if ($(".noSidebar").length === 0) {
      sidebar.show();
    }

    $(".sidebar-toggler").show();
    otherIssues.show();
    $(this.issuesList.getFocusedIssue().scrollTo());
  }

  var toolbar = this.getToolbar();
  if (edit) {
    toolbar.container.data('originalDimensions', toolbar.originalDimensions[0]);
    toolbar.originalDimensions[0] = $(".editMode .center").outerWidth();
  } else {
    toolbar.originalDimensions[0] = toolbar.container.data('originalDimensions');
  }

  toolbar.container.css("width", toolbar.originalDimensions[0]);
};
charisma.smartui.IssuesSupport.prototype.finishIssueEdit = function () {
  if (this.editMode) {
    this.issuesList.edit();
  }

};
charisma.smartui.IssuesSupport.prototype.allFoundIssuesAreSelected = function () {
  return this.issuesList && this.issuesList.allFoundIssuesAreSelected;
};
charisma.smartui.IssuesSupport.prototype.getCommentList = function () {
  return this.issuesList.getFocusedIssue().data('commentList');
};
charisma.smartui.IssuesSupport.prototype.initDragUpload = function (handler, windowId) {
  charisma.smartui.IssuesSupport.superclass.initDragUpload.call(this, handler, windowId, ".issueContainer:visible, .newIssueContainer .issueContainer__fsi:visible,  .edit-content__block:visible, .listEditIssue .issueContainer__fsi");
};


var issues;
