charisma.RestMethods = function (wfId, textField) {
  this.wfId = wfId;
  this.textField = textField;
};
charisma.RestMethods.prototype.suggest = function (caret) {
  if ($(this.textField).is(":visible")) {
    charisma.RestMethods.showSearchSuggest(this.textField, this.wfId, this.textField.value, caret ?caret :this.textField.getCaretPosition());
  }

};
charisma.RestMethods.prototype.underline = function (optionalLeftOffset) {
  if ($(this.textField).is(":visible")) {
    charisma.RestMethods.showSearchUnderline(this.textField, this.wfId, this.textField.value, optionalLeftOffset);
  }

};
charisma.RestMethods.prototype.underlineAndSuggest = function (caret, optionalLeftOffset) {
  if ($(this.textField).is(":visible")) {
    charisma.RestMethods.showSearchUnderlineAndSuggest(this.textField, this.wfId, this.textField.value, caret ?caret :this.textField.getCaretPosition(), optionalLeftOffset);
  }

};
charisma.RestMethods.bind = function (textField, rest) {
  textField["_rest"] = rest;
  rest.textField = textField;
  return rest;
};
charisma.RestMethods.$ = function (textField) {
  return textField["_rest"];
};
charisma.RestMethods.id = function (textField) {
  var t = $(textField);
  return t.attr("id") + "-" + t.attr("name");
};
charisma.RestMethods.showSearchSuggest = function (textField, wfId, query, caret) {
  if ($(textField).is(":visible")) {
    charisma.Rest.get("search/suggest", {wfId: wfId, query: query, caret: caret}, function (data) {
      if ($(textField).is(":visible")) {
        data.items = data.items || [];
        textField.suggest(data);
      }

    }, charisma.RestMethods.id(textField));
  }

};
charisma.RestMethods.showSearchUnderline = function (textField, wfId, query, optionalLeftOffset) {
  if ($(textField).is(":visible")) {
    charisma.Rest.get("search/underline", {wfId: wfId, query: query}, function (data) {
      if ($(textField).is(":visible")) {
        textField.underline(data.query, data.ranges, optionalLeftOffset);
      }

    }, charisma.RestMethods.id(textField));
  }

};
charisma.RestMethods.showSearchUnderlineAndSuggest = function (textField, wfId, query, caret, optionalLeftOffset) {
  if ($(textField).is(":visible")) {
    charisma.Rest.get("search/underlineAndSuggest", {wfId: wfId, query: query, caret: caret}, function (data) {
      if ($(textField).is(":visible")) {
        var underline = data.underline;
        var suggest = data.suggest;
        suggest.items = suggest.items || [];
        textField.suggest(suggest);
        textField.underline(underline.query, underline.ranges, optionalLeftOffset);
      }

    }, charisma.RestMethods.id(textField));
  }

};
charisma.RestMethods.showCommandSuggest = function (textField, folderId, command, caret, issueIds, query, noIssuesContext) {
  if ($(textField).is(":visible")) {
    charisma.Rest.get("command/suggest", {folder: folderId, issueIds: issueIds, query: query, noIssuesContext: noIssuesContext, command: command, caret: caret}, function (data) {
      if ($(textField).is(":visible")) {
        data.items = data.items || [];
        textField.suggest(data);
      }

    }, charisma.RestMethods.id(textField));
  }

};
charisma.RestMethods.showCommandUnderline = function (textField, folderId, command, issueIds, query, noIssuesContext) {
  if ($(textField).is(":visible")) {
    charisma.Rest.get("command/underline", {folder: folderId, issueIds: issueIds, query: query, noIssuesContext: noIssuesContext, command: command}, function (data) {
      if ($(textField).is(":visible")) {
        textField.underline(data.query, data.ranges, 5);
      }

    }, charisma.RestMethods.id(textField));
  }

};
charisma.RestMethods.showCommandUnderlineAndSuggest = function (textField, folderId, command, caret, issueIds, query, noIssuesContext) {
  if ($(textField).is(":visible")) {
    charisma.Rest.get("command/underlineAndSuggest", {folder: folderId, issueIds: issueIds, query: query, noIssuesContext: noIssuesContext, command: command, caret: caret}, function (data) {
      if ($(textField).is(":visible")) {
        var underline = data.underline;
        var suggest = data.suggest;
        suggest.items = suggest.items || [];
        textField.suggest(suggest);
        textField.underline(underline.query, underline.ranges, 5);
      }

    }, charisma.RestMethods.id(textField));
  }

};
charisma.RestMethods.showCommandUnderlineAndSuggestAndCommands = function (textField, folderId, command, caret, issueIds, query, commandsOl, noIssuesContext) {
  if ($(textField).is(":visible")) {
    charisma.Rest.get("command/underlineAndSuggestAndCommands", {folder: folderId, issueIds: issueIds, query: query, noIssuesContext: noIssuesContext, command: command, caret: caret}, function (data) {
      if ($(textField).is(":visible")) {
        var underline = data.underline;
        var suggest = data.suggest;
        var commandsDescr = data.commands ?data.commands.command :[];
                

        suggest.items = suggest.items || [];
        textField.suggest(suggest);
        textField.underline(underline.query, underline.ranges, 5);
                

        commandsOl.children().remove();
        var showQuickFixes = commandsOl.data("show_quick_fixes");
        for (var i = 0; i < commandsDescr.length; i += 1) {
          var commandDescr = commandsDescr[i];
          commandsOl.append("<li class=\"" + (commandDescr.error ?"error" :"normal" + " " + "lightText") + "\"><span>" + commandDescr.desc + "</span></li>");
          if (commandDescr.error && commandDescr.quickFixes && showQuickFixes) {
            for ( var index in commandDescr.quickFixes) {
              var quickFix = commandDescr.quickFixes[index];
              var message = quickFix.message;
              var messageHtml;
              if (quickFix.params.valueToAdd) {
                var replacement = "<span class=\"valueToAdd\"></span>";
                message = message.replace("{{valueToAdd}}", replacement);
                message = "<span>" + message + "</span>";
                messageHtml = $("<span>" + message + "</span>");
                messageHtml.find(".valueToAdd").text(quickFix.params.valueToAdd);
              } else {
                messageHtml = $("<span>" + message + "</span>");
              }

                            

              var listElementWithMessage = $("<li class=\"" + "quickFix" + "\"></li>");
              listElementWithMessage.append(messageHtml);
              commandsOl.append(listElementWithMessage);
              commandsOl.append("<li class=\"" + "quickFix" + "\">" + "<button class=\"" + "ring-btn" + "\">" + quickFix.buttonMessage + "</button>" + "</li>");
              var button = commandsOl.find("button").last();
              button.data("quick_fix_id", quickFix.id);
            }

          }

        }

      }

    }, charisma.RestMethods.id(textField));
  }

};
charisma.RestMethods.moveIssue = function (folderId, moved, leading, query, orderExpected, onSuccess) {
  charisma.RestMethods.post("folder/" + folderId + "/moveIssue", {moved: moved, leading: leading, query: query, orderExpected: orderExpected}, function (data) {
    onSuccess(data);
  });
};
charisma.RestMethods.resetIssuePosition = function (folderId, issue, onSuccess) {
  charisma.RestMethods.post("folder/" + folderId + "/resetIssuePosition", {issue: issue}, function (data) {
    onSuccess(data);
  });
};
charisma.RestMethods.get = function (restMethod, params, onSuccess) {
  charisma.RestMethods.request("GET", restMethod, params, onSuccess);
};
charisma.RestMethods.post = function (restMethod, params, onSuccess) {
  charisma.RestMethods.request("POST", restMethod, params, onSuccess);
};
charisma.RestMethods.request = function (httpMethod, restMethod, params, onSuccess) {
  var url = charisma.Rest.url(restMethod);
  if (params) {
    var paramsStr;
    var first = true;
        

    for ( var name in params) {
      var value = params[name];
      if (value != undefined && value != null && !(typeof value == "string" && value == "") && !(typeof value == "boolean" && value == false)) {
        if (first) {
          paramsStr = "?";
          first = false;
        } else {
          paramsStr += "&";
        }

        paramsStr += encodeURIComponent(name) + "=" + encodeURIComponent(value);
      }

            

    }

    if (paramsStr != undefined) {
      url += paramsStr;
    }

  }

  var config = {headers: {Accept: "application/json"}, handlerUrl: url, hideLoadingPopup: true, collectFileElements: false, collectFormElements: false, pollInterval: 10, processRecentOnly: true, listeners: [new charisma.RestRequestListener(onSuccess)], method: httpMethod};
  if (httpMethod == "POST") {
    config.headers = config.headers || {};
    //default content type
    config.headers["Content-Type"] = config.headers["Content-Type"] || "application/x-www-form-urlencoded";
  }

  Webr.Event.send(config);
};
charisma.CommandRest = function (wfId, issueIds, query, description, noIssuesContext) {
  charisma.CommandRest.superclass.constructor.call(this, wfId);
  this.issueIds = issueIds;
  this.query = query;
  this.description = description ?$(description) :null;
  this.noIssuesContext = (noIssuesContext == true) ?true :false;
};
{
  var F = new Function();
  F.prototype = charisma.RestMethods.prototype;
  charisma.CommandRest.prototype = new F();
  charisma.CommandRest.prototype.constructor = charisma.CommandRest;
  charisma.CommandRest.superclass = charisma.RestMethods.prototype;
}

charisma.CommandRest.prototype.suggest = function (caret) {
  charisma.RestMethods.showCommandSuggest(this.textField, this.wfId, this.textField.value, caret ?caret :this.textField.getCaretPosition(), this.issueIds, this.query, this.noIssuesContext);
};
charisma.CommandRest.prototype.underline = function () {
  charisma.RestMethods.showCommandUnderline(this.textField, this.wfId, this.textField.value, this.issueIds, this.query, this.noIssuesContext);
};
charisma.CommandRest.prototype.underlineAndSuggest = function (caret) {
  if (this.description != null) {
    charisma.RestMethods.showCommandUnderlineAndSuggestAndCommands(this.textField, this.wfId, this.textField.value, caret ?caret :this.textField.getCaretPosition(), this.issueIds, this.query, this.description, this.noIssuesContext);
  } else {
    charisma.RestMethods.showCommandUnderlineAndSuggest(this.textField, this.wfId, this.textField.value, caret ?caret :this.textField.getCaretPosition(), this.issueIds, this.query, this.noIssuesContext);
  }

};
