charisma.smartui.RingController = function (config) {
  charisma.smartui.RingController.superclass.constructor.call(this, config, this.callback);
  ringController = this;
  charisma.smartui.RingController.superclass.setPart.call(this, "issues");
};
{
  var F = new Function();
  F.prototype = charisma.RingCommonController.prototype;
  charisma.smartui.RingController.prototype = new F();
  charisma.smartui.RingController.prototype.constructor = charisma.smartui.RingController;
  charisma.smartui.RingController.superclass = charisma.RingCommonController.prototype;
}

charisma.smartui.RingController.prototype.callback = function () {
  this.initIssuesToggle();
  this.initWhatsNewToggle();
  charisma.smartui.RingController.superclass.initNewUiButton.call(this);
};
charisma.smartui.RingController.prototype.initIssuesToggle = function () {
  var self = this;
  var bindTo = $(".yt-header__issues-toggler");
  $(document).one(charisma.RingCommonController.CLICK_RING, ".yt-header__issues-toggler", function () {
    new Webr.component.ComboBoxComponentBind($(".yt-header__issues-combo").get(0), this).toggle();
  });
  bindTo.on(charisma.RingCommonController.CLICK_RING, function () {
    self.hideDropdown();
  });
};
charisma.smartui.RingController.prototype.initWhatsNewToggle = function () {
  var cfg = this.config;
  $(document).on(charisma.RingCommonController.CLICK_RING, ".yt-header__whats-new", function (e) {
    e.preventDefault();
    if (cfg.methods.showNewFeatures) {
      cfg.methods.showNewFeatures(!$(this).hasClass("yt-header__whats-new_nav"));
    }

  });
};
charisma.smartui.RingController.prototype.removeWhatsNewToggle = function () {
  $(".yt-header__whats-new").remove();
};
charisma.smartui.RingController.prototype.hideDropdown = function () {
  ring('dropdown', 'hide')();
};
charisma.smartui.RingController.prototype.setCreateButtonVisible = function (visible) {
  if (visible) {
    if (commonController && commonController.editMode) {
      commonController.toggleEditMode(false);
    }

    $(".yt-new-issue-button, .yt-header__create-btn").hide();
  } else {
    $(".yt-new-issue-button, .yt-header__create-btn").show();
  }

};
charisma.smartui.RingController.prototype.login = function () {
  charisma.smartui.RingController.superclass.login.call(this);
  this.config.methods.goToLoginScreen();
};


