charisma.smartui.TextCopier = function (swfUri, fsiMode, allowRegularUiUpdate) {
  this.isDescription = false;
  this.messageType = -1;
  this.current_state = null;
  this.allowRegularUiUpdate = allowRegularUiUpdate;
  this.swfUri = swfUri + "?v5";
  this.correctTop = fsiMode ?3 :0;
  this.createCopier();
  this.current_state = charisma.smartui.TextCopier.state_HIDDEN;
};
charisma.smartui.TextCopier.prototype.createDomElement = function (type, id) {
  var el = $(document.createElement(type));
  if (id) {
    el.attr("id", id);
  }

  return el;
};
charisma.smartui.TextCopier.prototype.createCopier = function () {
  var body = $(document.body);
  this.textContainer = this.createDomElement("span").addClass("clipboard-text");
  body.append(this.textContainer);
  var ieSupport = charisma.smartui.TextCopier.ieNativeSupport();
  if (ieSupport) {
    this.copier = this.createDomElement("div").addClass("text-copier").addClass("copierIe").addClass("hidden");
    this.registerIeEvents();
    body.append(this.copier);
  } else {
    body.append(this.createFlash());
  }

  this.tooltip = new charisma.smartui.CopierTooltip(this.copier, this.createDomElement("div").get(0), {followCursor: false, showOnTop: true});
  this.tooltip.container.addClass("toolbar-tootip");
};
charisma.smartui.TextCopier.prototype.registerIeEvents = function () {
  var it = this;
  this.copier.click(function () {
    charisma.smartui.TextCopier.instance.updateTooltip((charisma.smartui.TextCopier.instance.isDescription ?0 :1), true);
    it.doIeCopy();
  });
  this.copier.mouseenter(function () {
    charisma.smartui.TextCopier.instance.updateTooltip((charisma.smartui.TextCopier.instance.isDescription ?0 :1), true);
    charisma.smartui.TextCopier.copiedCallback(true);
  });
  this.copier.mouseleave(function () {
    charisma.smartui.TextCopier.copiedCallback(-1);
    it.mouseleave();
  });
};
charisma.smartui.TextCopier.prototype.doIeCopy = function () {
  window.clipboardData.clearData();
  window.clipboardData.setData("Text", this.getText());
  charisma.smartui.TextCopier.copiedCallback(false);
};
charisma.smartui.TextCopier.prototype.getText = function () {
  var txt;
  var it = this;
  if (this.isDescription) {
    var url = charisma.Rest.url("issue/" + this.issueId + "/descriptionWithRemovedMarkup");
        

    jQuery.ajax({url: url, dataType: "text", type: "GET", async: false, cache: false, success: function (data, textStatus, jqXHR) {
      txt = jqXHR.responseText;
    }, error: function (data, textStatus, errorThrown) {
      trace("rest request thrown error: " + errorThrown);
      txt = it.getParsedText(false);
    }});
  } else {
    txt = it.getParsedText(true);
  }

  return txt;
};
charisma.smartui.TextCopier.prototype.getParsedText = function (both) {
  var text = jQuery.trim(this.target.text());
  if (both) {
    return text + " " + jQuery.trim(this.target2.text());
  }

  return text;
};
charisma.smartui.TextCopier.prototype.setPosition = function () {
  this.isDescription = this.target.hasClass("description");
  var pos = this.target.offset();
  var left = pos.left;
  var top = pos.top + this.correctTop;
  if (this.isDescription) {
    var wikiWrapper = this.target.children();
    if (wikiWrapper.get(0).firstChild.nodeType !== 3) {
      var toggler = wikiWrapper.find(".wiki-plus");
      if (toggler.length > 0) {
        left = left - charisma.smartui.TextCopier.COPIER_WIDTH;
      }

    }

  } else {
    left += this.target.outerWidth();
  }

  this.copier.css({left: left, top: top});
};
charisma.smartui.TextCopier.prototype.startTimer = function (timer, delay) {
  if (!timer) {
    this.stopTimer(timer);
    var self = this;
    timer = window.setTimeout(function () {
      self.tick();
    }, delay);
  }

};
charisma.smartui.TextCopier.prototype.stopTimer = function (timer) {
  if (timer) {
    window.clearInterval(timer);
    timer = null;
  }

};
charisma.smartui.TextCopier.prototype.saveTargets = function (target, target2) {
  this.target = target;
  this.target2 = target2;
};
charisma.smartui.TextCopier.prototype.show = function (target, target2) {
  Webr.stateMachine.stateMachineRuntime.handleEvent(this, "show", arguments);
};
charisma.smartui.TextCopier.prototype.tick = function () {
  Webr.stateMachine.stateMachineRuntime.handleEvent(this, "tick", arguments);
};
charisma.smartui.TextCopier.prototype.hideshowflash = function () {
  Webr.stateMachine.stateMachineRuntime.handleEvent(this, "hideshowflash", arguments);
};
charisma.smartui.TextCopier.prototype.mouseleave = function (hideNow) {
  Webr.stateMachine.stateMachineRuntime.handleEvent(this, "mouseleave", arguments);
};
charisma.smartui.TextCopier.prototype._hide = function () {
  this.copier.addClass("hidden");
};
charisma.smartui.TextCopier.prototype._show = function () {
  this.focusedElement = document.activeElement;
  this.setPosition();
  this.copier.removeClass("hidden");
};
charisma.smartui.TextCopier.prototype.createFlash = function () {
  this.copier = this.createDomElement("object").addClass("text-copier").addClass("hidden");
  this.copier.attr("classid", "clsid:d27cdb6e-ae6d-11cf-96b8-444553540000");
  this.copier.attr("codebase", "http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=9,0,0,0");
  this.copier.attr("heigth", "16");
  this.copier.attr("width", charisma.smartui.TextCopier.SWF_WIDTH);
  var a = [];
  a.push("<param name = \"movie\" value=\"");
  a.push(this.swfUri);
  a.push("\"/><param name = \"bgcolor\" value = \"#ffffff\"/><param name = \"quality\" value = \"high\"/><param name = \"scale\" value = \"noscale\"/>");
  a.push("<param name = \"wmode\" value = \"transparent\"/>");
  a.push("<embed name = \"");
  a.push(charisma.smartui.TextCopier.SWF_OBJECT_ID);
  a.push("\" src = \"");
  a.push(this.swfUri);
  a.push("\" width = \"");
  a.push(charisma.smartui.TextCopier.SWF_WIDTH);
  a.push("\" height = \"16\" bgcolor = \"#ffffff\" wmode = \"transparent\" quality = \"high\" allowScriptAccess = \"always\" pluginspage = \"http://www.macromedia.com/go/getflashplayer\" menu = \"false\" type = \"application/x-shockwave-flash\">");
  a.push("</object>");
  return this.copier.append(a.join(""));
};
charisma.smartui.TextCopier.prototype.setTooltipText = function (type) {
  if (this.messageType != type) {
    this.tooltip.changetext(charisma.smartui.TextCopier.MSG[type]);
    this.messageType = type;
  }

};
charisma.smartui.TextCopier.prototype.updateTooltip = function (msgType, show) {
  this.tooltip.move();
  this.setTooltipText(msgType);
  this.tooltip.mmove(0, 0);
  if (show) {
    this.tooltip.timeOut();
  }

};
charisma.smartui.TextCopier.CONTAINER_ID = "_copier_";
charisma.smartui.TextCopier.SWF_OBJECT_ID = "_copier-obj-id_";
charisma.smartui.TextCopier.TEXT_CONTAINER_ID = "_copier-txt_";
charisma.smartui.TextCopier.SWF_WIDTH = 17;
charisma.smartui.TextCopier.MSG = [l10n('${l10n("TextCopier.js.Copy_description_to_clipboard")}'), l10n('${l10n("TextCopier.js.Copy_id_and_summary_to_clipboard")}'), l10n('${l10n("TextCopier.js.Copied")}')];
charisma.smartui.TextCopier.COPIER_WIDTH = 22;
charisma.smartui.TextCopier.state_HIDDEN = {name: "HIDDEN", show: function (target, target2) {
  if (true) {
    this.saveTargets(target, target2);
        {
      Webr.stateMachine.stateMachineRuntime.handleOnEnter(this, charisma.smartui.TextCopier.state_PAUSE_BEFORE_SHOW);
    }

    return charisma.smartui.TextCopier.state_PAUSE_BEFORE_SHOW;
  }

  return false;
}};
charisma.smartui.TextCopier.state_PAUSE_BEFORE_SHOW = {name: "PAUSE_BEFORE_SHOW", onenter: function () {
  this.startTimer(this.showTimer, 500);
}, onexit: function () {
  this.stopTimer(this.showTimer);
}, tick: function () {
  if (true) {
    this._show();
        {
      Webr.stateMachine.stateMachineRuntime.handleOnExit(this, charisma.smartui.TextCopier.state_PAUSE_BEFORE_SHOW);
    }

    return charisma.smartui.TextCopier.state_SHOWN;
  }

  return false;
}, mouseleave: function (hideNow) {
  if (true) {
        {
      Webr.stateMachine.stateMachineRuntime.handleOnExit(this, charisma.smartui.TextCopier.state_PAUSE_BEFORE_SHOW);
    }

    return charisma.smartui.TextCopier.state_HIDDEN;
  }

  return false;
}};
charisma.smartui.TextCopier.state_SHOWN = {name: "SHOWN", mouseleave: function (hideNow) {
  if (hideNow == true) {
    this._hide();
    return charisma.smartui.TextCopier.state_HIDDEN;
  }

  if (hideNow == false) {
        {
      Webr.stateMachine.stateMachineRuntime.handleOnEnter(this, charisma.smartui.TextCopier.state_PAUSE_BEFORE_HIDE);
    }

    return charisma.smartui.TextCopier.state_PAUSE_BEFORE_HIDE;
  }

  return false;
}, hideshowflash: function () {
  if (true) {
        {
      Webr.stateMachine.stateMachineRuntime.handleOnEnter(this, charisma.smartui.TextCopier.state_PAUSE_BEFORE_HIDE);
    }

    return charisma.smartui.TextCopier.state_PAUSE_BEFORE_HIDE;
  }

  return false;
}};
charisma.smartui.TextCopier.state_PAUSE_BEFORE_HIDE = {name: "PAUSE_BEFORE_HIDE", onenter: function () {
  this.startTimer(this.hideTimer, 2000);
}, onexit: function () {
  this.stopTimer(this.hideTimer);
}, hideshowflash: function () {
  if (true) {
        {
      Webr.stateMachine.stateMachineRuntime.handleOnExit(this, charisma.smartui.TextCopier.state_PAUSE_BEFORE_HIDE);
    }

    return charisma.smartui.TextCopier.state_SHOWN;
  }

  return false;
}, show: function (target, target2) {
  if (this.target == target) {
        {
      Webr.stateMachine.stateMachineRuntime.handleOnExit(this, charisma.smartui.TextCopier.state_PAUSE_BEFORE_HIDE);
    }

    return charisma.smartui.TextCopier.state_SHOWN;
  }

  if (this.target != target) {
    this.saveTargets(target, target2);
    this.setPosition();
        {
      Webr.stateMachine.stateMachineRuntime.handleOnExit(this, charisma.smartui.TextCopier.state_PAUSE_BEFORE_HIDE);
    }

    return charisma.smartui.TextCopier.state_SHOWN;
  }

  return false;
}, mouseleave: function (hideNow) {
  if (hideNow == true) {
    this._hide();
        {
      Webr.stateMachine.stateMachineRuntime.handleOnExit(this, charisma.smartui.TextCopier.state_PAUSE_BEFORE_HIDE);
    }

    return charisma.smartui.TextCopier.state_HIDDEN;
  }

  return false;
}, tick: function () {
  if (true) {
    this._hide();
        {
      Webr.stateMachine.stateMachineRuntime.handleOnExit(this, charisma.smartui.TextCopier.state_PAUSE_BEFORE_HIDE);
    }

    return charisma.smartui.TextCopier.state_HIDDEN;
  }

  return false;
}};
charisma.smartui.TextCopier.copiedCallback = function (param) {
  if (param == -1) {
    //mousout
    charisma.smartui.TextCopier.instance.tooltip.mout();
    charisma.smartui.TextCopier.instance.hideshowflash();
  } else {
    if (param == true) {
      //mouseover
      charisma.smartui.TextCopier.instance.updateTooltip((charisma.smartui.TextCopier.instance.isDescription ?0 :1), true);
      charisma.smartui.TextCopier.instance.hideshowflash();
    } else if (param == false) {
      //mouseup
      charisma.smartui.TextCopier.instance.updateTooltip(2);
      commonController.focusIssue();
    }

  }

};
charisma.smartui.TextCopier.ieNativeSupport = function () {
  return Webr.util.Util.isIE && window.clipboardData;
};
charisma.smartui.TextCopier.isAvailable = function () {
  if (charisma.smartui.TextCopier.ieNativeSupport()) {
    return true;
  }

  //check flash availability
  var flashObj = false;
  if (navigator.plugins && navigator.plugins.length > 0) {
    var type = "application/x-shockwave-flash";
    var mimeTypes = navigator.mimeTypes;
    return (mimeTypes[type] && mimeTypes[type].enabledPlugin) ?true :false;
  }

  return flashObj;
};
charisma.smartui.TextCopier.doCopyText = function () {
  if (charisma.smartui.TextCopier.instance) {
    return charisma.smartui.TextCopier.instance.getText();
  }

  return null;
};
charisma.smartui.TextCopier.hideCopier = function (hideNow) {
  if (charisma.smartui.TextCopier.instance) {
    charisma.smartui.TextCopier.instance.mouseleave(hideNow ?hideNow :false);
  }

};
charisma.smartui.TextCopier.showCopier = function (el1, el2, issueId) {
  if (charisma.smartui.TextCopier.instance) {
    charisma.smartui.TextCopier.instance.issueId = issueId;
    charisma.smartui.TextCopier.instance.show(el1, el2);
  }

};
charisma.smartui.TextCopier.init = function (swfURL, fsiMode, allowRegularUiUpdate) {
  if (charisma.smartui.TextCopier.isAvailable()) {
    if (charisma.smartui.TextCopier.instance) {
      return charisma.smartui.TextCopier.instance;
    } else {
      return charisma.smartui.TextCopier.instance = new charisma.smartui.TextCopier(swfURL, fsiMode, allowRegularUiUpdate);
    }

  }

};
charisma.smartui.CopierTooltip = function (watchElement, elementToolTip, config) {
  charisma.smartui.CopierTooltip.superclass.constructor.call(this, watchElement, elementToolTip, config);
};
{
  var F = new Function();
  F.prototype = Webr.component.ToolTip.prototype;
  charisma.smartui.CopierTooltip.prototype = new F();
  charisma.smartui.CopierTooltip.prototype.constructor = charisma.smartui.CopierTooltip;
  charisma.smartui.CopierTooltip.superclass = Webr.component.ToolTip.prototype;
}

charisma.smartui.CopierTooltip.prototype.init = function () {
  var css = "tooltip";
  if (this.config.showOnTop) {
    this.delta = 0;
    css = "tooltip" + " " + "tooltip-inline";
  }

  this.container.addClass(css);
};
charisma.smartui.CopierTooltip.prototype.setTopPosition = function () {
  if (this.config.showOnTop) {
    var pos = this.watchElement.offset();
    if (this.watchElementPos == undefined || Webr.component.ToolTip.posistonNotEqual(this.watchElementPos, pos)) {
      this.watchElementPos = pos;
      var tooltipHeight = this.container.outerHeight();
      var tooltipWidth = this.container.outerWidth();
      var targetWidth = this.watchElement.outerWidth();
      this.y = pos.top - tooltipHeight - 5;
      this.x = Math.max(0, pos.left - (tooltipWidth - targetWidth) / 2);
    }

  }

};
