cr.setTemplateBind("SearchBar", function (path) {
  cr.ach(path, "searchSubmit", "click", function (event, data) {
    commonController.doSearchRequest();
  });
  cr.ach(path, "filterFolder", "change", function (event, data) {
    //TODO: remove then WD-1669 will be fixed
    if (cr.findInHandler(event, "" + "." + "filterFolder", []).mainElement.get(0) == event.target) {
      analytics.trackEvent("issueList", "contextSelector");
      cr.serverMethodCallInHandler(event, "" + "." + "methodCall_changeContext", {__param__folder: cr.findInHandler(event, "" + "." + "filterFolder", []).getCurentOption().id});
    }

  });
  cr.ach(path, "searchField", "valuechange", function (event, data) {
    var value = data.value;
    if (value != null && value.length > 0) {
      $(cr.findInHandler(event, "" + "." + "saveQueryBtn", [])).attr("title", l10n('${l10n("SearchBar.Save_this_search_2")}'));
      $(cr.findInHandler(event, "" + "." + "clearSearchLink", [])).show();
    } else {
      $(cr.findInHandler(event, "" + "." + "clearSearchLink", [])).hide();
      $(cr.findInHandler(event, "" + "." + "saveQueryBtn", [])).attr("title", "");
    }

    charisma.RestMethods.$(cr.findInHandler(event, "" + "." + "searchField", [])).underlineAndSuggest(data.caretPos, 3);
  });
  cr.ach(path, "searchField", "caretmove", function (event, data) {
    charisma.RestMethods.$(cr.findInHandler(event, "" + "." + "searchField", [])).suggest(data.caretPos);
  });
  cr.ach(path, "clearSearchLink", "click", function (event, data) {
    cr.findInHandler(event, "" + "." + "searchField", []).focus();
    cr.findInHandler(event, "" + "." + "searchField", []).value = "";
    $(cr.findInHandler(event, "" + "." + "saveQueryBtn", [])).attr("title", "");
    if (Webr.util.Util.isIE) {
      charisma.RestMethods.$(cr.findInHandler(event, "" + "." + "searchField", [])).underlineAndSuggest(3);
    }

  });
  cr.ash(path, "putQuery", "click", null);
  cr.ash(path, "editSearchLink", "click", null);
  cr.ash(path, "filterFolder", "Load", {collectFormElements: false, hideLoadingPopup: true, processRecentOnly: true, preventDoubleSubmit: false});
  cr.forEach(path, "searchField", function () {
    this.attachWatcher(false);
  });
  cr.forEach(path, "searchField", function () {
    this.attachWatcher(false);
  });
  regCC(path, "filterFolder");
});
