package jetbrains.charisma.wiki;

/*Generated by MPS */

import jetbrains.mps.webr.wiki.processor.runtime.BaseProcessor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import jetbrains.mps.webr.wiki.processor.runtime.WikiUtil;
import jetbrains.mps.webr.wiki.processor.runtime.utils.AttributeManufacture;
import jetbrains.mps.webr.wiki.processor.runtime.LinkAppender;
import java.util.regex.Pattern;
import java.util.List;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import java.util.ArrayList;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.webr.wiki.processor.runtime.IWikiProcessor;
import jetbrains.mps.webr.wiki.processor.runtime.utils.CommonWikiUtils;
import jetbrains.mps.gtext.runtime.TBaseBuilderContext;
import webr.framework.function.HtmlStringUtil;
import jetbrains.mps.internationalization.runtime.Localizer;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import java.util.Arrays;
import jetbrains.mps.webr.wiki.processor.runtime.TextColorerProcessorMarkup;
import jetbrains.mps.webr.wiki.processor.runtime.TextColorerProcessor;
import jetbrains.mps.webr.javascript.runtime.jsDependencies.JsDependencyManager;
import webr.framework.textBuilder.TBuilderContext;
import jetbrains.mps.webr.runtime.templateComponent.LinkUtil;
import jetbrains.mps.webr.runtime.util.ContentBuilder;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.webr.wiki.processor.runtime.StackProcessorUniversal;
import jetbrains.mps.webr.wiki.processor.runtime.MarkupClass;
import java.io.IOException;
import jetbrains.mps.webr.wiki.processor.runtime.RichTextWikiProcessor;
import org.apache.commons.lang.StringEscapeUtils;
import jetbrains.mps.gtext.runtime.BaseHtmlStringUtil;
import jetbrains.charisma.persistent.ApplicationMetaDataImpl;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.charisma.persistent.IssueImpl;
import jetbrains.charisma.persistence.user.CurrentUserProvider;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import jetbrains.youtrack.core.security.Operation;
import jetbrains.mps.webr.runtime.builderContext.BuilderThreadContext;
import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import jetbrains.charisma.persistent.IssueAttachmentImpl;
import jetbrains.charisma.service.UserFilterService;
import jetbrains.charisma.service.UserProfileService;
import webr.framework.url.UrlUtil;
import jetbrains.mps.webr.runtime.uri.QueryParameter;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import jetbrains.exodus.query.PropertyEqual;
import jetbrains.exodus.query.LinkEqual;
import jetbrains.mps.internal.collections.runtime.IWhereFilter;
import jetbrains.mps.baseLanguage.closures.runtime.Wrappers;
import jetbrains.mps.webr.runtime.converter.TypeConvertManager;
import java.io.Reader;
import jetbrains.mps.webr.wiki.processor.runtime.TrailingCharStringReader;
import jetbrains.mps.webr.wiki.processor.runtime.utils.HtmlProcessorWrapper;
import jetbrains.mps.webr.wiki.processor.runtime.Table;

%%

%class CharismaWikiProcessorRemoveMarkup
%extends BaseProcessor

%public 
%buffer 128
%final
%unicode

%{

  private Log log = LogFactory.getLog(CharismaWikiProcessorRemoveMarkup.class);
  private Log QuotingLog = LogFactory.getLog(WikiUtil.class);
  private boolean QuotingnoJs = false;
  private int QuotingmonospaceKeyLength = "{monospace}".length();
  private int QuotingnoformatKeyLength = "{noformat}".length();
  private int QuotingmonospaceBracketLength = "{{".length();
  private AttributeManufacture HtmlTextCallerattributeManufacture = new AttributeManufacture();
  private boolean HtmlTextCallernoJs = false;
  private int HtmlTextCallertagLength = "{html}".length();
  private boolean WikiLinkmobile = false;
  private String WikiLinkbaseUrl = "";
  private boolean WikiLinknoJs = false;
  private LinkAppender WikiLinklinkAppender = new LinkAppender();
  private int HighlightCallercodeSize = 0;
  private int HighlightCallermaxCodeSize = 100 * 1024;
  private boolean HighlightCallernoJs;
  private boolean HighlightCallerlivePreviewMode;
  private String HighlightCallerbaseUrl = "";
  private int TextColorercolorSuffixKeyLength = "{color}".length();
  private int TextColorercolorPrefixKeyLength = "{color:".length();
  private Log UniversalStacktraceCallerCustomlog = LogFactory.getLog(WikiUtil.class);
  private boolean UniversalStacktraceCallerCustomnoJS;
  private boolean UniversalStacktraceCallerCustomexceptionsExpanded;
  private Pattern UniversalStacktraceCallerCustompattern = Pattern.compile("[^\n]*\n?");
  private List<Character> ListslistPrefix = ListSequence.fromList(new ArrayList<Character>());
  private List<Integer> Listsnumeration = ListSequence.fromList(new ArrayList<Integer>());
  private List<Character> Listsresult = ListSequence.fromList(new ArrayList<Character>());
  private int ListsnewLineCount;
  private boolean ListsjabberMode = false;
  private String ListsrememberFirstPrefix;
  private boolean Linksmobile = false;
  private boolean LinksnoJs = false;
  private String LinksbaseUrl = "";
  private LinkAppender LinkslinkAppender = new LinkAppender();
  private boolean IssueLinkuseGlobalLinks;
  private Entity IssueLinkissue;
  private boolean IssueLinkmobile = false;
  private boolean IssueLinkfromWorkflow = false;
  private List<Entity> IssueLinkmentionedUsers = ListSequence.fromList(new ArrayList<Entity>());
  private boolean QueryLinkuseGlobalLinks;
  private boolean QueryLinkmobile = false;
  private boolean liveModePreview = false;

  public IWikiProcessor clone(String input) {
    CharismaWikiProcessorRemoveMarkup cloned = create(input);
    cloned.QuotingnoJs = this.QuotingnoJs;
    cloned.HtmlTextCallerattributeManufacture = this.HtmlTextCallerattributeManufacture;
    cloned.HtmlTextCallernoJs = this.HtmlTextCallernoJs;
    cloned.WikiLinkmobile = this.WikiLinkmobile;
    cloned.WikiLinkbaseUrl = this.WikiLinkbaseUrl;
    cloned.WikiLinknoJs = this.WikiLinknoJs;
    cloned.HighlightCallermaxCodeSize = this.HighlightCallermaxCodeSize;
    cloned.HighlightCallernoJs = this.HighlightCallernoJs;
    cloned.HighlightCallerlivePreviewMode = this.HighlightCallerlivePreviewMode;
    cloned.HighlightCallerbaseUrl = this.HighlightCallerbaseUrl;
    cloned.UniversalStacktraceCallerCustomnoJS = this.UniversalStacktraceCallerCustomnoJS;
    cloned.UniversalStacktraceCallerCustomexceptionsExpanded = this.UniversalStacktraceCallerCustomexceptionsExpanded;
    cloned.ListsjabberMode = this.ListsjabberMode;
    cloned.Linksmobile = this.Linksmobile;
    cloned.LinksnoJs = this.LinksnoJs;
    cloned.LinksbaseUrl = this.LinksbaseUrl;
    cloned.IssueLinkuseGlobalLinks = this.IssueLinkuseGlobalLinks;
    cloned.IssueLinkissue = this.IssueLinkissue;
    cloned.IssueLinkmobile = this.IssueLinkmobile;
    cloned.IssueLinkfromWorkflow = this.IssueLinkfromWorkflow;
    cloned.IssueLinkmentionedUsers = this.IssueLinkmentionedUsers;
    cloned.QueryLinkuseGlobalLinks = this.QueryLinkuseGlobalLinks;
    cloned.QueryLinkmobile = this.QueryLinkmobile;
    return cloned;
  }

  protected boolean readerNotExists() {
    return this.zzReader == null;
  }

  private String yytext(int prefixLength, int suffixLength) {
    //  zzBuffer, zzStartRead and zzMarkedPos are generated by jFlex, we don't declare them
    return new String(this.zzBuffer, this.zzStartRead + prefixLength, this.zzMarkedPos - this.zzStartRead - suffixLength - prefixLength);
  }

  public CharismaWikiProcessorRemoveMarkup setHtmlTextCallernoJs(boolean value) {
    this.HtmlTextCallernoJs = value;
    return this;
  }

  public CharismaWikiProcessorRemoveMarkup setHighlightCallermaxCodeSize(int value) {
    this.HighlightCallermaxCodeSize = value;
    return this;
  }

  public CharismaWikiProcessorRemoveMarkup setListsjabberMode(boolean value) {
    this.ListsjabberMode = value;
    return this;
  }

  public CharismaWikiProcessorRemoveMarkup setIssueLinkuseGlobalLinks(boolean value) {
    this.IssueLinkuseGlobalLinks = value;
    return this;
  }

  public CharismaWikiProcessorRemoveMarkup setIssueLinkissue(Entity value) {
    this.IssueLinkissue = value;
    return this;
  }

  public CharismaWikiProcessorRemoveMarkup setIssueLinkmentionedUsers(List<Entity> value) {
    this.IssueLinkmentionedUsers = value;
    return this;
  }

  public CharismaWikiProcessorRemoveMarkup setQueryLinkuseGlobalLinks(boolean value) {
    this.QueryLinkuseGlobalLinks = value;
    return this;
  }

  public CharismaWikiProcessorRemoveMarkup setCharismaWikiProcessor_noJS(boolean value) {
    this.UniversalStacktraceCallerCustomnoJS = value;
    this.QuotingnoJs = value;
    this.HighlightCallernoJs = value;
    this.LinksnoJs = value;
    this.WikiLinknoJs = value;
    return this;
  }

  public CharismaWikiProcessorRemoveMarkup setCharismaWikiProcessor_mobile(boolean value) {
    this.IssueLinkmobile = value;
    this.QueryLinkmobile = value;
    this.WikiLinkmobile = value;
    this.Linksmobile = value;
    return this;
  }

  public CharismaWikiProcessorRemoveMarkup setCharismaWikiProcessor_exceptionsExpanded(boolean value) {
    this.UniversalStacktraceCallerCustomexceptionsExpanded = value;
    return this;
  }

  public CharismaWikiProcessorRemoveMarkup setCharismaWikiProcessor_attrFilter(AttributeManufacture value) {
    this.HtmlTextCallerattributeManufacture = value;
    return this;
  }

  public CharismaWikiProcessorRemoveMarkup setCharismaWikiProcessor_fromWorkflow(boolean value) {
    this.IssueLinkfromWorkflow = value;
    return this;
  }

  public CharismaWikiProcessorRemoveMarkup setCharismaWikiProcessor_baseUrl(String value) {
    this.WikiLinkbaseUrl = value;
    this.LinksbaseUrl = value;
    this.HighlightCallerbaseUrl = value;
    return this;
  }

  public CharismaWikiProcessorRemoveMarkup setLivePreviewMode(boolean value) {
    this.HighlightCallerlivePreviewMode = value;
    return this;
  }

  private boolean isNewline(char a) {
    return a == '\n' || a == '\r';
  }

  public void appendNoformat(boolean noMarkup) {
    String result = CommonWikiUtils.valuableSubstring(this.getText(), this.QuotingnoformatKeyLength, this.getText().length() - this.QuotingnoformatKeyLength);
    int last = -1;
    for (int pos = 0; pos < result.length(); pos++) {
      if (this.isNewline(result.charAt(pos))) {
        if (!(noMarkup)) {
          {
            TBaseBuilderContext builderContext = this.builderContext;
            builderContext.append(HtmlStringUtil.html(result.substring(last + 1, pos)));
          }
        } else {
          {
            TBaseBuilderContext builderContext = this.builderContext;
            builderContext.append(result.substring(last + 1, pos));
          }
        }
        {
          TBaseBuilderContext builderContext = this.builderContext;
          if (!(noMarkup)) {
            builderContext.append("<br/>");
          }
        }
        {
          TBaseBuilderContext builderContext = this.builderContext;
          if (noMarkup) {
            builderContext.append("\n");
          }
        }
        last = pos;
      }
    }
    if (!(noMarkup)) {
      TBaseBuilderContext builderContext = this.builderContext;
      builderContext.append(HtmlStringUtil.html(result.substring(last + 1)));
    }
    {
      TBaseBuilderContext builderContext = this.builderContext;
      if (noMarkup) {
        builderContext.append(result.substring(last + 1));
      }
    }
  }

  public void transformQuote(int from, int to, boolean noMarkup) {
    if (!(noMarkup)) {
      String t = CommonWikiUtils.valuableSubstring(this.getText(), from, this.getText().length() - to);
      if ((t == null || t.length() == 0)) {
        return;
      }
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append("<div class=\"wiki quote\">");
      }
      try {
        {
          TBaseBuilderContext builderContext = this.builderContext;
          this.clone(t).processSafe(builderContext);
        }
      } catch (Exception e) {
        if (this.QuotingLog.isErrorEnabled()) {
          this.QuotingLog.error("Exception while processing recursive content [" + t + "]", e);
        }

        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append(HtmlStringUtil.html(this.getErrorMessage(e, t)));
        }
      }
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append("</div>");
      }
    } else {
      String t = this.yytext(from, to);
      try {
        {
          TBaseBuilderContext builderContext = this.builderContext;
          this.clone(t).processSafe(builderContext);
        }
      } catch (Exception e) {
        if (this.QuotingLog.isErrorEnabled()) {
          this.QuotingLog.error("Exception while processing recursive content [" + t + "]", e);
        }
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append(this.getErrorMessage(e, t));
        }
      }
    }
  }

  private String getErrorMessage(Exception e, String text) {
    return ((Localizer) ServiceLocator.getBean("localizer")).localizedMsg("Quoting.Can_t_apply_wiki_recursive_markup", e.getMessage(), text);
  }

  /*package*/ void appendLink(String link, String displayedText) {
    if (!(this.WikiLinklinkAppender.isInitialized())) {
      this.WikiLinklinkAppender.init(this.builderContext, this.WikiLinkmobile, this.WikiLinkbaseUrl);
    }
    this.WikiLinklinkAppender.appendLink(link, displayedText, this.WikiLinknoJs);
  }

  public void appendTitle(String title) {
    if (title != null) {
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append("<div class=\"java code title\">");
      }
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append(HtmlStringUtil.html(title));
      }
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append("</div>");
      }
    }
  }

  private String getTitleCodeLimitExeededMessage() {
    return ((Localizer) ServiceLocator.getBean("localizer")).localizedMsg("HighlightCaller.The_code-tagged_content_in_this_issue_is_too_large_Code_highlighting_has_been_switched_off");
  }

  public void appendBackGap() {
    int len = 0;
    for (int i = this.getText().length() - 1; i >= 0 && this.getText().charAt(i) == ' '; --i) {
      ++len;
    }
    char[] a = new char[len];
    Arrays.fill(a, ' ');
    {
      TBaseBuilderContext builderContext = this.builderContext;
      builderContext.append(new String(a));
    }
  }

  public void appendInlineCode(String code) {
    if ((code != null && code.length() > 0)) {
      code = ((TextColorerProcessorMarkup) TextColorerProcessor.getInstance().createProcessor(code)).setTextColorerProcessor_baseUrl(this.HighlightCallerbaseUrl).processSafe();
      this.HighlightCallercodeSize += code.length();
      this.appendHighlight(WikiUtil.PLAIN_TEXT, code, "code", "inline-code");
    } else {
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append(HtmlStringUtil.html(this.getText()));
      }
    }
  }

  public void appendHighlightPre(String langName, String code) {
    this.appendHighlight(langName, code, "pre", "wikicode");
  }

  public void appendHighlightCode(String code) {
    this.appendHighlight(null, code, "code", "inline-code");
  }

  public void appendHighlight(String langName, String code, String tag, String styleClass) {
    if (isEmpty_wuech9_a0a0cb(((code == null ?
      null :
      code.trim()
    )))) {
      return;
    }
    if (this.HighlightCallercodeSize > this.HighlightCallermaxCodeSize) {
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append("<");
        builderContext.append(tag);
        builderContext.append(" class=\"" + styleClass);
      }
      if (this.HighlightCallercodeSize > this.HighlightCallermaxCodeSize) {
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("\" title=\"");
          builderContext.append(this.getTitleCodeLimitExeededMessage());
        }
      }
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append("\">");
      }
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append(code);
      }
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append("</");
        builderContext.append(tag);
        builderContext.append(">");
      }
      return;
    }

    boolean nonDefaultLang = (langName != null && langName.length() > 0) && (((((JsDependencyManager) ServiceLocator.getOptionalBean("jsDependencyManager"))) != null && ((JsDependencyManager) ServiceLocator.getBean("jsDependencyManager")).containsDependency("jetbrains.mps.webr.prettify." + "lang-" + langName + "-min")));
    if (!(this.HighlightCallernoJs)) {
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append("<span class=\"");
        builderContext.append("js-wrapper");
        builderContext.append("\">");
      }
      {
        TBuilderContext builderContext = (TBuilderContext) this.builderContext;
        LinkUtil.addScriptDependencies(builderContext, ListSequence.fromListAndArray(new ArrayList<String>(), "jetbrains.mps.webr.prettify.prettify"));
      }
      if (nonDefaultLang) {
        {
          TBuilderContext builderContext = (TBuilderContext) this.builderContext;
          String fname = "jetbrains.mps.webr.prettify." + "lang-" + langName + "-min";
          LinkUtil.addScriptDependencies(builderContext, ListSequence.fromListAndArray(new ArrayList<String>(), fname));
        }
      }
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append("</span>");
      }
    }

    boolean isPlainText = eq_wuech9_a0a6a82(langName, WikiUtil.PLAIN_TEXT);
    {
      TBaseBuilderContext builderContext = this.builderContext;
      builderContext.append("<");
      builderContext.append(tag);
      builderContext.append(" class=\"");
      builderContext.append(styleClass);
    }
    if (nonDefaultLang) {
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append(" lang-");
        builderContext.append(langName);
      }
    }
    if (!(isPlainText)) {
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append(" prettyprint");
      }
    }
    {
      TBaseBuilderContext builderContext = this.builderContext;
      builderContext.append("\">");
    }

    {
      TBaseBuilderContext builderContext = this.builderContext;
      builderContext.append(code);
    }
    {
      TBaseBuilderContext builderContext = this.builderContext;
      builderContext.append("</");
      builderContext.append(tag);
      builderContext.append(">");
    }

    if (isPlainText || this.HighlightCallernoJs) {
      return;
    }

    {
      TBaseBuilderContext builderContext = this.builderContext;
      builderContext.append("<span class=\"");
      builderContext.append("js-wrapper");
      builderContext.append("\">");
    }
    if (this.HighlightCallerlivePreviewMode) {
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append(ContentBuilder.toString(new _FunctionTypes._void_P1_E0<TBuilderContext>() {
          public void invoke(TBuilderContext builderContext) {
            builderContext.appendIndent();
            builderContext.append("<script type=\"text/javascript\">");
            builderContext.appendIndent();
            LinkUtil.addScriptDependencies(builderContext, ListSequence.fromList(new ArrayList<String>()));
            builderContext.appendIndent();
            builderContext.append("setTimeout(function () {");
            builderContext.appendNewLine();
            builderContext.increaseIndent();
            builderContext.appendIndent();
            builderContext.append("prettyPrint();");
            builderContext.appendNewLine();
            builderContext.decreaseIndent();
            builderContext.appendIndent();
            builderContext.append("}, 3000);");
            builderContext.appendNewLine();
            builderContext.appendNewLine();
            builderContext.append("</script>");
            builderContext.appendNewLine();
          }
        }, false));
      }
    } else {
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append(ContentBuilder.toString(new _FunctionTypes._void_P1_E0<TBuilderContext>() {
          public void invoke(TBuilderContext builderContext) {
            builderContext.appendIndent();
            builderContext.append("<script type=\"text/javascript\">");
            builderContext.appendIndent();
            LinkUtil.addScriptDependencies(builderContext, ListSequence.fromList(new ArrayList<String>()));
            builderContext.appendIndent();
            builderContext.append("prettyPrint();");
            builderContext.appendNewLine();
            builderContext.appendNewLine();
            builderContext.append("</script>");
            builderContext.appendNewLine();
          }
        }, false));
      }
    }
    {
      TBaseBuilderContext builderContext = this.builderContext;
      builderContext.append("</span>");
    }
  }

  public void processStackTrace(String input) {
    try {
      input = input.trim();
      StackProcessorUniversal.getInstance().createProcessor(input).process(this.builderContext);
    } catch (Exception e) {
      if (this.UniversalStacktraceCallerCustomlog.isErrorEnabled()) {
        this.UniversalStacktraceCallerCustomlog.error("Exception while processing exception content [" + input + "]", e);
      }
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append(HtmlStringUtil.html(((Localizer) ServiceLocator.getBean("localizer")).localizedMsg("UniversalStacktraceCallerCustom.Can_t_apply_wiki_stacktrace_markup_{0}", e.getMessage())));
        builderContext.append(HtmlStringUtil.html("\n"));
        builderContext.append(HtmlStringUtil.html(((Localizer) ServiceLocator.getBean("localizer")).localizedMsg("UniversalStacktraceCallerCustom.Original_text")));
        builderContext.append(HtmlStringUtil.html("\n"));
        builderContext.append(HtmlStringUtil.html(input));
      }
    }
  }

  public void appendException(int pos) {
    String stacktrace = this.yytext(pos, 0);
    if (!(this.UniversalStacktraceCallerCustomnoJS)) {
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append(ContentBuilder.toString(new _FunctionTypes._void_P1_E0<TBuilderContext>() {
          public void invoke(TBuilderContext builderContext) {
            builderContext.appendIndent();
            builderContext.append("<script type=\"text/javascript\">");
            builderContext.appendNewLine();
            builderContext.increaseIndent();
            LinkUtil.addScriptDependencies(builderContext, ListSequence.fromListAndArray(new ArrayList<String>(), "jetbrains.charisma.smartui.js.Idea"));
            builderContext.appendIndent();
            builderContext.append("setTimeout(function () {");
            builderContext.appendNewLine();
            builderContext.increaseIndent();
            builderContext.appendIndent();
            builderContext.append("charisma.Idea.layoutWikiLinks();");
            builderContext.appendNewLine();
            builderContext.decreaseIndent();
            builderContext.appendIndent();
            builderContext.append("}, 1000);");
            builderContext.appendNewLine();
            builderContext.appendIndent();
            builderContext.append("");
            builderContext.appendNewLine();
            builderContext.decreaseIndent();
            builderContext.appendIndent();
            builderContext.append("</script>");
            builderContext.appendNewLine();
          }
        }, false));
      }
      {
        TBuilderContext builderContext = (TBuilderContext) this.builderContext;
        LinkUtil.addScriptDependencies(builderContext, ListSequence.fromListAndArray(new ArrayList<String>(), "jetbrains.mps.webr.wiki.processor.scripts.WikiUtil"));
      }
    }
    int endOfFirstLine = stacktrace.indexOf('\n');
    try {
      TBaseBuilderContext ctx = new TBaseBuilderContext();
      ctx.initBuffer();

      if (this.UniversalStacktraceCallerCustompattern.matcher(stacktrace).matches()) {
        String s1 = "<div><pre class=\"";
        String s2 = "wiki-exception-title";
        String s3 = "\">";
        ctx.append(s1);
        ctx.append(s2);
        ctx.append(s3);
        StackProcessorUniversal.getInstance().createProcessor(((stacktrace == null ?
          null :
          stacktrace.trim()
        ))).processSafe(ctx);
        String s4 = "</pre></div>";
        ctx.append(s4);
      } else {
        CharismaStackTraceCollapser collapser = new CharismaStackTraceCollapser(ctx, this.UniversalStacktraceCallerCustomnoJS);
        String head = stacktrace.substring(0, endOfFirstLine);
        IWikiProcessor headProccessor = StackProcessorUniversal.getInstance().createProcessor(((head == null ?
          null :
          head.trim()
        )));
        IWikiProcessor bodyProccessor = StackProcessorUniversal.getInstance().createProcessor(((stacktrace == null ?
          null :
          stacktrace.trim()
        )));
        if (!(this.UniversalStacktraceCallerCustomexceptionsExpanded)) {
          collapser.appendCollapsedExceptionMarkup(headProccessor, bodyProccessor);
        } else {
          collapser.appendExpandedExceptionMarkup(headProccessor, bodyProccessor);
        }
      }
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append(ctx.getText());
      }
    } catch (Throwable t) {
      // TODO remove this when WD-1493 is implemented 
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append("<div><pre class=\"");
        builderContext.append("wiki-exception");
        builderContext.append("\">");
      }
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append(HtmlStringUtil.html(stacktrace));
      }
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append("</pre></div>");
      }
    }
  }

  public String getNewline(int n, String val) {
    StringBuilder sb = new StringBuilder();
    for (int i = 0; i < n; i++) {
      sb.append(val);
    }
    return sb.toString();
  }

  private String giveMeNumber(int number) {
    return number + ".";
  }

  private int diff(String str, List<Character> source, List<Character> result) {
    int count = 0;
    int bound = ListSequence.fromList(source).count();
    for (int i = 0; i < str.length(); i++) {
      if (i >= bound || str.charAt(i) != ListSequence.fromList(source).getElement(count)) {
        this.appendResult(str, result, i);
        return count;
      }
      count++;
    }
    return count;
  }

  private void appendResult(String str, List<Character> result, int i) {
    for (char __; i < str.length(); i++) {
      ListSequence.fromList(result).addElement(str.charAt(i));
    }
  }

  private void flushNewLines(boolean noMarkup) {
    for (int i = 0; i < this.ListsnewLineCount; i++) {
      MarkupClass.newLine(this.builderContext, noMarkup, this.ListsjabberMode);
    }
    this.ListsnewLineCount = 0;
  }

  private void transformList(String str, boolean noMarkup) throws IOException {
    ListSequence.fromList(this.Listsresult).clear();
    int length = this.diff(str, this.ListslistPrefix, this.Listsresult);
    this.flushNewLines(noMarkup);
    while (ListSequence.fromList(this.ListslistPrefix).count() > length) {
      char it = ListSequence.fromList(this.ListslistPrefix).removeLastElement();
      if (!(noMarkup)) {
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append((it == '#' ?
            "</li></ol>" :
            "</li></ul>"
          ));
        }
      }
    }
    switch (ListSequence.fromList(this.Listsresult).count()) {
      case 0:
        //  empty item
        if (!(noMarkup)) {
          {
            TBaseBuilderContext builderContext = this.builderContext;
            builderContext.append("</li><li>");
          }
        } else {
          char[] shift = new char[ListSequence.fromList(this.ListslistPrefix).count() - 1];
          Arrays.fill(shift, ' ');
          {
            TBaseBuilderContext builderContext = this.builderContext;
            builderContext.append(new String(shift));
          }
          if ((int) ListSequence.fromList(this.Listsnumeration).last() == -1) {
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append("*");
            }
          } else {
            int last = ListSequence.fromList(this.Listsnumeration).removeLastElement();
            last++;
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append(this.giveMeNumber(last));
            }
            ListSequence.fromList(this.Listsnumeration).addElement(last);
          }
        }
        break;
      case 1:
        //  nested item
        char it = ListSequence.fromList(this.Listsresult).first();
        if (!(noMarkup)) {
          if (it == '#') {
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append("<ol class=\"wiki-list");
              builderContext.append(Integer.toString(ListSequence.fromList(this.ListslistPrefix).count()));
              builderContext.append("\">");
            }
          } else {
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append("<ul class=\"wiki-list");
              builderContext.append(Integer.toString(ListSequence.fromList(this.ListslistPrefix).count()));
              builderContext.append("\">");
            }
          }
          {
            TBaseBuilderContext builderContext = this.builderContext;
            builderContext.append("<li>");
          }
        } else {
          char[] shift = new char[ListSequence.fromList(this.ListslistPrefix).count()];
          Arrays.fill(shift, ' ');
          {
            TBaseBuilderContext builderContext = this.builderContext;
            builderContext.append(new String(shift));
          }
          if (it != '#') {
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append("*");
            }
            ListSequence.fromList(this.Listsnumeration).addElement(-1);
          } else {
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append(this.giveMeNumber(1));
            }
            ListSequence.fromList(this.Listsnumeration).addElement(1);
          }
        }
        ListSequence.fromList(this.ListslistPrefix).addElement(it);
        break;
      default:
        //  too many items
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append(str);
        }
    }
  }

  private void processNewLineChecking(boolean nomarkup) throws IOException {
    if (this.getText().length() > 0 && this.getText().charAt(this.getText().length() - 1) == '\n') {
      this.transformList(this.ListsrememberFirstPrefix, nomarkup);
    } else {
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append(this.ListsrememberFirstPrefix);
      }
    }
    this.ListsrememberFirstPrefix = "";
    this.yypushback(this.getText().length());
    this.endState();
  }

  private void processList(boolean nomarkup) throws IOException {
    if (ListSequence.fromList(this.ListslistPrefix).isEmpty() && this.getText().length() == 1) {
      this.ListsrememberFirstPrefix = this.getText();
      this.beginState(this.CHECK_NEW_LINE);
    } else {
      this.transformList(this.getText(), nomarkup);
    }
  }

  private void appendLabeledLink() throws IOException {
    int linkEnds = this.getLinkEnds();
    if (linkEnds != -1) {
      String link = StringUtils.substring(this.getText(), 1, linkEnds).trim();
      this.appendLinkTag(link, RichTextWikiProcessor.getInstance().createProcessor(StringUtils.substring(this.getText(), linkEnds + 1, this.getText().length() - 1)).processSafe());
    } else {
      String link = StringUtils.substring(this.getText(), 1, this.getText().length() - 1).trim();
      this.appendLinkTag(link, StringEscapeUtils.escapeHtml(link));
    }
  }

  private int getLinkEnds() {
    int linkEnds = this.getText().indexOf(' ');
    while (linkEnds > 1 && this.getText().charAt(linkEnds - 1) == ',' && (Character.isLetter(this.getText().charAt(linkEnds - 2)) || Character.isDigit(linkEnds - 2))) {
      boolean flag = false;
      for (int i = linkEnds; i >= 0; --i) {
        flag = this.getText().charAt(i) == '(';
        if (flag || this.getText().charAt(i) == ')' || this.getText().charAt(i) == '[') {
          break;
        }
      }
      if (flag) {
        for (int i = linkEnds; i < this.getText().length(); ++i) {
          flag = this.getText().charAt(i) == ')';
          if (flag || this.getText().charAt(i) == '(' || this.getText().charAt(i) == ']') {
            break;
          }
        }
      }
      if (flag) {
        linkEnds = this.getText().indexOf(' ', linkEnds + 1);
      } else {
        break;
      }
    }
    return linkEnds;
  }

  public void appendConfluenceStyledLink() throws IOException {
    int linkEnds = this.getText().indexOf('|');
    String link = StringUtils.substring(this.getText(), linkEnds + 1, this.getText().length() - 1).trim();
    String label = RichTextWikiProcessor.getInstance().createProcessor(StringUtils.substring(this.getText(), 1, linkEnds)).processSafe();
    this.appendLinkTag(link.trim(), label);
  }

  public void appendHttpLink(String url) {
    url = url.trim();
    int lastCharIndex = url.length() - 1;
    char lastChar = url.charAt(lastCharIndex);
    boolean append = lastChar == '.' || lastChar == ',' || lastChar == ':' || lastChar == ';';
    if (append) {
      url = StringUtils.substring(url, 0, lastCharIndex);
      this.appendLinkTag(url, url);
      BaseHtmlStringUtil.html(BaseProcessor.characterToStringSafe(lastChar));
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append(BaseHtmlStringUtil.html(BaseProcessor.characterToStringSafe(lastChar)));
      }
    } else {
      this.appendLinkTag(url, url);
    }
  }

  /*package*/ void appendMailToLinkTag(String link) {
    if (!(this.LinkslinkAppender.isInitialized())) {
      this.LinkslinkAppender.init(this.builderContext, this.Linksmobile, this.LinksbaseUrl);
    }
    this.LinkslinkAppender.appendMailToLink(link);
  }

  /*package*/ void appendLinkTag(String link, String displayedText) {
    if (!(this.LinkslinkAppender.isInitialized())) {
      this.LinkslinkAppender.init(this.builderContext, this.Linksmobile, this.LinksbaseUrl);
    }
    this.LinkslinkAppender.appendLink(link, displayedText, this.LinksnoJs);
  }

  public final void appendBlank(char a) {
    switch (a) {
      case '\n':
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("<br/>");
        }
        break;
      case '\t':
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("\t");
        }
        break;
      case ' ':
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append(" ");
        }
        break;
      default:
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("" + a);
        }
    }
  }

  public final void appendBlank(String s) {
    for (int i = 0; i < s.length(); i++) {
      this.appendBlank(s.charAt(i));
    }
  }

  public void appendTitledText() {
    int contentEnds = this.getText().lastIndexOf('|');
    String title = StringUtils.substring(this.getText(), contentEnds + 1, this.getText().length() - 2).trim();
    String content = StringUtils.substring(this.getText(), 2, contentEnds);
    {
      TBaseBuilderContext builderContext = this.builderContext;
      builderContext.append("<span title=\"");
      builderContext.append(title.trim());
      builderContext.append("\">");
    }
    {
      TBaseBuilderContext builderContext = this.builderContext;
      this.clone(content).processSafe(builderContext);
    }
    {
      TBaseBuilderContext builderContext = this.builderContext;
      builderContext.append("</span>");
    }
  }

  public void removeFramingMarkup(String symbol, String tag, boolean addHtml) {
    int indexOfSymbol = this.getText().indexOf(symbol);
    int indexOfLastSymbol = this.getText().lastIndexOf(symbol);
    this.appendBlank(StringUtils.substring(this.getText(), 0, indexOfSymbol));
    int delemiterIdx = indexOfSymbol + 1;
    String[] strings = StringUtils.substring(this.getText(), indexOfSymbol + 1, indexOfLastSymbol).split('\\' + symbol + "[ \t\r\n]" + '\\' + symbol);
    for (String str : strings) {
      if (addHtml) {
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("<");
        }
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append(tag);
        }
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append(">");
        }
      }
      {
        TBaseBuilderContext builderContext = this.builderContext;
        this.clone(str).processSafe(builderContext);
      }
      if (addHtml) {
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("</");
        }
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append(tag);
        }
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append(">");
        }
      }
      delemiterIdx += str.length() + symbol.length();
      if (str != strings[strings.length - 1]) {
        this.appendBlank(this.getText().charAt(delemiterIdx));
        delemiterIdx += symbol.length() + 1;
      }
    }
    this.appendBlank((this.getText().charAt(this.getText().length() - 1) == '\r' ?
      StringUtils.substring(this.getText(), indexOfLastSymbol + 1, this.getText().length() - 2) :
      StringUtils.substring(this.getText(), indexOfLastSymbol + 1)
    ));
  }

  public String getPicture() {
    String logo = ((ApplicationMetaDataImpl) DnqUtils.getPersistentClassInstance(((Entity) ServiceLocator.getBean("applicationMetaData")), "ApplicationMetaData")).getLogoUrl(((Entity) ServiceLocator.getBean("applicationMetaData")));
    int ind = logo.lastIndexOf('/');
    return "!" + logo.substring(ind + 1) + "!";
  }

  public void transformIssue() {
    Entity i = IssueImpl.fromId(this.getText());
    Entity contextUser = ((CurrentUserProvider) ServiceLocator.getBean("currentUser")).get();
    if (EntityOperations.equals(i, null) || EntityOperations.equals(contextUser, null) || !(((IssueImpl) DnqUtils.getPersistentClassInstance(i, "Issue")).isAccessible(Operation.READ, contextUser, i))) {
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append(HtmlStringUtil.html(this.getText()));
      }
    } else {
      if (this.IssueLinkuseGlobalLinks) {
        try {
          BuilderThreadContext.initNonLocalBuilderThreadContext();
          this.appendIssueLink(i, contextUser, this.getText());
        } finally {
          BuilderThreadContext.close();
        }
      } else {
        this.appendIssueLink(i, contextUser, this.getText());
      }
    }
  }

  public void appendIssueLink(Entity i, Entity contextUser, String mentionedId) {
    LinkAppender.appendHrefForMobile(this.builderContext, this.IssueLinkmobile);
    {
      TBaseBuilderContext builderContext = this.builderContext;
      builderContext.append(((IssueImpl) DnqUtils.getPersistentClassInstance(i, "Issue")).getUrl(!(this.IssueLinkuseGlobalLinks), i) + "\"");
    }
    if (((IssueImpl) DnqUtils.getPersistentClassInstance(i, "Issue")).isResolved(i)) {
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append(" class=\"issue-resolved\"");
      }
    }
    {
      TBaseBuilderContext builderContext = this.builderContext;
      builderContext.append(" target=\"_self\"");
    }
    {
      TBaseBuilderContext builderContext = this.builderContext;
      builderContext.append(" data-issue-id=\"" + ((Entity) i).getId().toString() + "\"");
    }
    {
      TBaseBuilderContext builderContext = this.builderContext;
      builderContext.append(" title=\"" + BaseHtmlStringUtil.html(PrimitiveAssociationSemantics.get(i, "summary", String.class, null)) + "\">" + mentionedId + "</a>");
    }
  }

  public void appendImage(boolean noMarkup) throws IOException {
    if (noMarkup) {
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append("!");
      }
      {
        TBaseBuilderContext builderContext = this.builderContext;
        this.clone(this.yytext(1, 1)).processSafe(builderContext);
      }
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append("!");
      }
    } else {
      String[] result = this.yytext(1, 1).split("[|]");
      String name = null;
      int last = -1;
      if (result.length > 0) {
        last = result.length - 1;
        name = result[last];
      }

      if (EntityOperations.equals(this.IssueLinkissue, null) && this.getText().equals(this.getPicture())) {
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("<div class=\"wiki picture\"><img src=\"");
          builderContext.append(((ApplicationMetaDataImpl) DnqUtils.getPersistentClassInstance(((Entity) ServiceLocator.getBean("applicationMetaData")), "ApplicationMetaData")).getLogoUrl(((Entity) ServiceLocator.getBean("applicationMetaData"))));
          builderContext.append("\"/></div>");
        }
        return;
      }

      Entity attach = this.getAttachment(name);

      if (EntityOperations.equals(attach, null)) {
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("!");
        }
        {
          TBaseBuilderContext builderContext = this.builderContext;
          this.clone(this.yytext(1, 1)).processSafe(builderContext);
        }
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("!");
        }
      } else {
        String alt = null;
        String position = null;
        for (int i = 0; i < last; i++) {
          String value = result[i].trim();
          if (IssueLinkConst.POS.contains(value)) {
            position = value;
          } else {
            alt = value;
          }
        }
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("<div class=\"wiki picture\"");
        }
        if (position != null) {
          {
            TBaseBuilderContext builderContext = this.builderContext;
            builderContext.append(" style=\"");
          }
          if (position.equals(IssueLinkConst.INLINE)) {
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append("display:inline;");
            }
          } else {
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append(HtmlStringUtil.html("align:"));
              builderContext.append(HtmlStringUtil.html(position));
              builderContext.append(HtmlStringUtil.html(";"));
            }
          }
          {
            TBaseBuilderContext builderContext = this.builderContext;
            builderContext.append("\"");
          }
        }
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("><img src=\"");
          builderContext.append(((IssueAttachmentImpl) DnqUtils.getPersistentClassInstance(attach, "IssueAttachment")).getUrl(attach));
          builderContext.append("\"");
        }
        if (alt != null) {
          {
            TBaseBuilderContext builderContext = this.builderContext;
            builderContext.append(" alt=\"");
          }
          {
            TBaseBuilderContext builderContext = this.builderContext;
            builderContext.append(HtmlStringUtil.html(alt));
          }
          {
            TBaseBuilderContext builderContext = this.builderContext;
            builderContext.append("\"");
          }
        }
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("/></div>");
        }
      }
    }
  }

  private void fixForRTL(String str) {
    if (!(PrimitiveAssociationSemantics.get(((Entity) ServiceLocator.getBean("applicationMetaData")), "rtlEnabled", Boolean.class, null))) {
      return;
    }

    boolean flag = false;
    for (int i = 0; i < str.length(); ++i) {
      if (str.charAt(i) > '\u05BE') {
        flag = true;
      }
    }

    if (!(flag)) {
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append("&lrm;");
      }
    }
  }

  private void appendUsername() {
    Entity user = ((UserFilterService) ServiceLocator.getBean("userFilterService")).searchGreedyByLogin(StringUtils.substring(this.getText(), 1));

    int pushBackCount;
    if (!(EntityOperations.equals(user, null))) {
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append("<a href=\"");
      }
      if (this.IssueLinkfromWorkflow) {
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append(((UserProfileService) ServiceLocator.getBean("userProfileService")).getAbsoluteProfileUrl(user));
        }
      } else {
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append(((UserProfileService) ServiceLocator.getBean("userProfileService")).getProfileUrl(user));
        }
      }
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append("\" title=\"");
        builderContext.append(PrimitiveAssociationSemantics.get(user, "login", String.class, "<no user>"));
      }
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append("\" data-user-id=\"");
        builderContext.append(((Entity) user).toIdString());
      }
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append("\">");
      }
      String displayedText = PrimitiveAssociationSemantics.get(user, "fullName", String.class, null);
      this.fixForRTL(displayedText);
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append(displayedText);
        builderContext.append("</a>");
      }
      pushBackCount = (this.getText().length() - 1 - PrimitiveAssociationSemantics.get(user, "login", String.class, "<no user>").length());
      ListSequence.fromList(this.IssueLinkmentionedUsers).addElement(user);
    } else {
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append(Character.toString(this.getText().charAt(0)));
      }
      pushBackCount = this.getText().length() - 1;
    }
    if (pushBackCount > 0) {
      this.yypushback(pushBackCount);
    }
  }

  public void appendAttachment(boolean removeMarkup) {
    String name = StringUtils.substring(this.getText(), 6, this.getText().length() - 1);
    Entity attach = this.getAttachment(name);
    if (!(EntityOperations.equals(attach, null))) {
      if (removeMarkup) {
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append(HtmlStringUtil.html(name));
        }
      } else {
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("<a href=\"");
        }
        if (this.IssueLinkfromWorkflow) {
          {
            TBaseBuilderContext builderContext = this.builderContext;
            builderContext.append(UrlUtil.getRestPathUri("wikiattachment").addPathElements(((IssueImpl) DnqUtils.getPersistentClassInstance(this.IssueLinkissue, "Issue")).getId(this.IssueLinkissue), name).addQueryParameters(new QueryParameter("code", ((IssueAttachmentImpl) DnqUtils.getPersistentClassInstance(attach, "IssueAttachment")).getAccessCode(attach))).toString());
          }
        } else {
          {
            TBaseBuilderContext builderContext = this.builderContext;
            builderContext.append(UrlUtil.getPersistentFileUrl(attach, null, null, true));
          }
        }
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("\">");
        }
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append(HtmlStringUtil.html(name));
        }
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("</a>");
        }
      }
    } else {
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append(this.getText());
      }
    }
  }

  private Entity getAttachment(final String name) {
    Iterable<Entity> caseInsensitiveMatches = Sequence.fromIterable(IssueAttachmentImpl.applyPermissions(QueryOperations.query(AssociationSemantics.getToMany(this.IssueLinkissue, "attachments"), "IssueAttachment", new PropertyEqual("name", (String) (name))), ((CurrentUserProvider) ServiceLocator.getBean("currentUser")).get(), Operation.READ)).toListSequence();
    if (QueryOperations.isEmpty(caseInsensitiveMatches)) {
      Entity comment = QueryOperations.getFirst(QueryOperations.query(QueryOperations.query(null, "DraftComment", new LinkEqual("issue", this.IssueLinkissue)), "DraftComment", new LinkEqual("owner", ((CurrentUserProvider) ServiceLocator.getBean("currentUser")).get())));
      if (!(EntityOperations.equals(comment, null))) {
        caseInsensitiveMatches = Sequence.fromIterable(AssociationSemantics.getToMany(comment, "attachments")).where(new IWhereFilter<Entity>() {
          public boolean accept(Entity it) {
            return PrimitiveAssociationSemantics.get(it, "name", String.class, null).equalsIgnoreCase(name);
          }
        });
      }
    }
    if (QueryOperations.isEmpty(caseInsensitiveMatches)) {
      return null;
    }
    if (QueryOperations.getSize(caseInsensitiveMatches) == 1) {
      return QueryOperations.getFirst(caseInsensitiveMatches);
    }
    for (Entity attachment : caseInsensitiveMatches) {
      if (PrimitiveAssociationSemantics.get(attachment, "name", String.class, null).equals(name)) {
        return attachment;
      }
    }
    return QueryOperations.getFirst(caseInsensitiveMatches);
  }

  private void addGitHubLink(boolean skip) {
    final Wrappers._T<String> t = new Wrappers._T<String>();
    if (skip) {
      t.value = this.getText().substring(1);
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append(BaseHtmlStringUtil.html(Character.toString(this.getText().charAt(0))));
      }
    } else {
      t.value = this.getText();
    }
    Iterable<WikiIssueLinkProvider> providers = ListSequence.fromList(((PluginHolder) ServiceLocator.getBean("wikiPluginHolder")).getIssueLinkProviders()).where(new IWhereFilter<WikiIssueLinkProvider>() {
      public boolean accept(WikiIssueLinkProvider it) {
        return it.canCreateLink(CharismaWikiProcessorRemoveMarkup.this.IssueLinkissue, t.value);
      }
    });
    if (Sequence.fromIterable(providers).isEmpty()) {
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append(t.value);
      }
    } else {
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append(Sequence.fromIterable(providers).first().createLink(this.IssueLinkissue, t.value));
      }
    }
  }

  public void appendQuery(boolean removeMarkup) {
    String query = this.yytext(7, 1);
    if (removeMarkup) {
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append(query);
      }
    } else {
      LinkAppender.appendHrefForMobile(this.builderContext, this.QueryLinkmobile);
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append(UrlUtil.getHtmlTemplateUri("Issues", "folderId", new QueryParameter("q", query, ((TypeConvertManager) ServiceLocator.getBean("typeConvertManager")))));
      }
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append("\">");
      }
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append(HtmlStringUtil.html(query));
      }
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append("</a>");
      }
    }
  }


  public static CharismaWikiProcessorRemoveMarkup create(String s) {
    if (s == null) {
      Reader reader = null;
      return new CharismaWikiProcessorRemoveMarkup(reader);
    } else {
      return new CharismaWikiProcessorRemoveMarkup(new TrailingCharStringReader(s, '\n'));
    }
  }

  public static boolean isEmpty_wuech9_a0a0cb(String str) {
    return str == null || str.length() == 0;
  }

  private static boolean eq_wuech9_a0a6a82(Object a, Object b) {
    return (a != null ?
      a.equals(b) :
      a == b
    );
  }
%}

%type Void

color = ([a-zA-Z]+)|("#"[0-9a-fA-F]{6})
newline = \n
line = "|"[^\n]*"|"
block = {newline}*({line}\n)*{line}\n?
KeyWord = [:jletter:]+
EscapeHtmlCode = "&"[:jletterdigit:]+";"
SingleNetAngleId = ([0-9A-Za-z_<>`$\/]|{EscapeHtmlCode})
NetAngleId = {SingleNetAngleId}+
PossibleNetAngleId = {SingleNetAngleId}*
NetBrackId = ([0-9A-Za-z<>`\[\],$_\/]|{EscapeHtmlCode})+
KeyExcWord = ("Failure"|"Exception"|"Error"|"Throwable")
SquareBracketExpression = (("~")?"["[^ \r\n\t]+"]")
ExceptionClass = ({PossibleNetAngleId}".")+{PossibleNetAngleId}{KeyExcWord}
Exception = ({ExceptionClass}((":"([^\n-]|-*[^\n>])*("->"|\n)?)|({SpaceLine}))?)
Address = "<"0x[:jletterdigit:]+">"
SingleSpace = [\t ]
Space = ({SingleSpace}+)
PossibleSpace = ({SingleSpace}*)
SpaceLine = ({PossibleSpace}\n)
PossibleSpaceLine = ({PossibleSpace}(\n)?)
Number = [:digit:]+
NetLock = {Space}-({Space}{KeyWord}){0,5}({PossibleSpaceLine}{Address}{Space}"(" ~")" )?{PossibleSpaceLine}
ElementSuffix = {KeyWord}([^()]+(":"{KeyWord})){Space}{Number}({Space}{KeyWord}{Space}{Number})?
atFunctionWithSuffix = {PossibleSpace}{KeyWord}{Space}({NetAngleId}".")+"."?{NetBrackId}"("[^)\n]*")"{PossibleSpace}({ElementSuffix}|{SquareBracketExpression})?{PossibleSpaceLine}
Selector = {PossibleSpace}"---"~("---"){PossibleSpaceLine}
Cause = \n{PossibleSpace}{KeyWord}({Space}{KeyWord})+":"(({SpaceLine}{Space}[-])|({Space}{KeyWord}([.]{KeyWord})+)).*(\n)?
CauseOrDashes = ({Cause}|{Selector})
MorePart = ({PossibleSpace}"..."{Space}{Number}{Space}{KeyWord}{PossibleSpaceLine})
ExceptionLine = ({atFunctionWithSuffix}|{NetLock}|{MorePart})
Exc = {Exception}*({atFunctionWithSuffix})({ExceptionLine}|{CauseOrDashes}{Exception}*)*
newline = (\n)
listSymbol = [-#*]
schemas = "ftp" | "http" | "https" | "gopher" | "mailto" | "news" | "nntp" | "irc" | "prospero" | "telnet" | "wais" | "xmpp" | "file" | "data" | "afs" | "cid" | "mid" | "mailserver" | "nfs" | "tn3270" | "z39.50" | "skype" | "smsto" | "ed2k"
baseAllowedUrlSymbol = ([:jletterdigit:]|[-_.!\*$&+/:;=?@#%{}|\^~`',])
bracketsExpressionAllowedSymbol = (([:jletterdigit:]+", ")|{baseAllowedUrlSymbol})
indexExpression = "["{baseAllowedUrlSymbol}*"]"
brecketsExpression = "("{bracketsExpressionAllowedSymbol}*")"
allowedUrlSymbol = {indexExpression}|{baseAllowedUrlSymbol}|{brecketsExpression}|[()]
allowedUrlSymbolWOB = {indexExpression}|{baseAllowedUrlSymbol}|{brecketsExpression}
urlTemplate = {allowedUrlSymbol}*{allowedUrlSymbolWOB}
email = ([a-zA-Z]([:jletterdigit:]|[_.-])*[@][a-zA-Z]([:jletterdigit:]|[_.-])*[.]([a-zA-Z]{2,5}))
nonEmptyWord = [^ \t\n\r-]
baseUnderlineRegexp = [ \t\n\r]\+([^ \t\n\r\+]([ ]|\\\+)*)*(([^ \t\n\r\+\\]|\\\+)\+)
baseAsteriskRegexp = [ \t\n\r]\*([^ \t\n\r\*]([ ]|\\\*)*)*(([^ \t\n\r\*\\]|\\\*)\*)
nonWordSymbol = [ \r\n\t\/\[\]\(\)\`\"-_.!\*$&+/:;=?@#%{}|\^~`',]
separator = [ \t\,\;\.\:\"()\?#\^]
ussueStart = [#\^]
issue = [a-zA-Z0-9_]+ \- [0-9]+
hash = [a-fA-F0-9]{40}
space = [ \n\t]
attachment = "[file:"[^\]]+"]"
image = "!"[^!\n]+"!"
username = [@]([:jletterdigit:]|[\+\.\|\-\=\@]){1,32}
base64Symbol = ([:jletterdigit:]|[\+\/=])

%state CHECK_NEW_LINE, HTML, HTML, HTML

%%

/* ReplyQuotation */
<YYINITIAL> {
^">"(.)*([\n$]">"(.)*)* {
          try {
            String sb = "";
            boolean notFirst = false;
            for (String line : this.getText().split("\n")) {
              if (notFirst) {
                {
                  TBaseBuilderContext builderContext = this.builderContext;
                  builderContext.append("\n");
                }
              } else {
                notFirst = true;
              }
              {
                TBaseBuilderContext builderContext = this.builderContext;
                builderContext.append(">");
              }
              {
                TBaseBuilderContext builderContext = this.builderContext;
                this.clone(line.substring(1)).processSafe(builderContext);
              }
            }
          } finally {
            this.text = null;
          }
}}
/* Quote */
<YYINITIAL> {
("{quote}")~("{quote}") {
          try {
            this.transformQuote(7, 7, true);
          } finally {
            this.text = null;
          }
}}
/* Monospace */
<YYINITIAL> {
("{monospace}")~("{monospace}") {
          try {
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append(this.yytext(11, 11));
            }
          } finally {
            this.text = null;
          }
}}
/* MonospaceBracket */
<YYINITIAL> {
("{{")([^{}]|[{][^{]|[}][^}])*("}}") {
          try {
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append(this.yytext(this.QuotingmonospaceBracketLength, this.QuotingmonospaceBracketLength));
            }
          } finally {
            this.text = null;
          }
}}
/* NoFormat */
<YYINITIAL> {
("{noformat}")~("{noformat}") {
          try {
            this.appendNoformat(true);
          } finally {
            this.text = null;
          }
}}
/* CollapseExpand */
<YYINITIAL> {
"{cut"[ ]+[^}]+"}"\n?~("{cut}") {
          try {
            int first = this.getText().indexOf('}');
            int last = this.getText().lastIndexOf('{');
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append(this.getText().substring(first + 1, last));
            }
          } finally {
            this.text = null;
          }
}}
/* Html */
<YYINITIAL> {
"{html" ([ ]+ "class" [ ]* "=" [ ]* [a-zA-Z]+)? "}"~"{html}" {
          try {
            String str = CommonWikiUtils.valuableSubstring(this.getText(), this.HtmlTextCallertagLength, this.getText().length() - this.HtmlTextCallertagLength);
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append(((HtmlProcessorWrapper) ServiceLocator.getBean("htmlProcessorWrapper")).removeMarkup(str));
            }
          } finally {
            this.text = null;
          }
}}
/* MDash */
<YYINITIAL> {
[-]{3} {
          try {
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append("&mdash;");
            }
          } finally {
            this.text = null;
          }
}}
/* NDash */
<YYINITIAL> {
[-]{2} {
          try {
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append("&ndash;");
            }
          } finally {
            this.text = null;
          }
}}
/* WikiLink */
<YYINITIAL> {
"[["[^\]]+"]]" {
          try {
            int linkEnd = this.getText().indexOf('|');
            if (linkEnd == -1) {
              linkEnd = 1;
            }
            String url = this.getText().substring(linkEnd + 1, this.getText().length() - 2).trim();
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append(url);
            }
          } finally {
            this.text = null;
          }
}}
/* CodeSemicolon */
<YYINITIAL> {
"{code:"[^{}|]*("|"[^{}|]*)*~"{code}"([\n]?) {
          try {
            int first = this.getText().indexOf('}');
            int last = this.getText().lastIndexOf('{');
            if (last - first > 1) {
              {
                TBaseBuilderContext builderContext = this.builderContext;
                builderContext.append(this.getText().substring(first + 1, last));
              }
            }
          } finally {
            this.text = null;
          }
}}
/* Code */
<YYINITIAL> {
"{code" ([ ]+ "lang" [ ]* "=" [ ]* [a-zA-Z]+)? "}" ~"{code}"([\n]?) {
          try {
            int first = this.getText().indexOf('}');
            int last = this.getText().lastIndexOf('{');
            if (last - first > 1) {
              {
                TBaseBuilderContext builderContext = this.builderContext;
                builderContext.append(this.getText().substring(first + 1, last));
              }
            }
          } finally {
            this.text = null;
          }
}}
/* ThreeBackicksCode */
<YYINITIAL> {
^([`]{3}([`]*)([ ]*)([a-z]*)([ ]*)[\n])~(\n[`]{3}([`]*)([\n]?)) {
          try {
            int first = this.getText().indexOf('\n');
            int last = this.getText().lastIndexOf("\n`");
            if (last - first > 1) {
              {
                TBaseBuilderContext builderContext = this.builderContext;
                builderContext.append(this.getText().substring(first + 1, last));
              }
              {
                TBaseBuilderContext builderContext = this.builderContext;
                builderContext.append("\n");
              }
            }
          } finally {
            this.text = null;
          }
}}
/* InlineCodeSingleBacktick */
<YYINITIAL> {
("`")~(([^\\`])"`") {
          try {
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append(this.yytext(1, 1));
            }
          } finally {
            this.text = null;
          }
}}
/* InlineCodeTwoBackticks */
<YYINITIAL> {
("``")~(([^\\`])"``") {
          try {
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append(this.yytext(2, 2));
            }
          } finally {
            this.text = null;
          }
}}
/* Coloring */
<YYINITIAL> {
"{color:"{color}"}"~"{color}" {
          try {
            int beg = this.getText().indexOf('}');
            {
              TBaseBuilderContext builderContext = this.builderContext;
              this.clone(this.yytext(beg + 1, this.TextColorercolorSuffixKeyLength)).processSafe(builderContext);
            }
          } finally {
            this.text = null;
          }
}}
/* TableFst */
<YYINITIAL> {
^{block} {
          try {
            Table t = new Table(this.getText());
            t.appendNomarkup(builderContext, this);
          } finally {
            this.text = null;
          }
}}
/* Exception1 */
<YYINITIAL> {
[\t\n\r]{Space}?{Exc} {
          try {
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append(this.getText());
            }
          } finally {
            this.text = null;
          }
}}
/* Exception2 */
<YYINITIAL> {
^{Space}?{Exc} {
          try {
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append(this.getText());
            }
          } finally {
            this.text = null;
          }
}}
/* List */
<YYINITIAL> {
^{listSymbol}+ {
          try {
            this.processList(true);
          } finally {
            this.text = null;
          }
}}
/* NewLineCount */
<YYINITIAL> {
({newline})+$ {
          try {
            this.ListsnewLineCount += this.getText().length();
          } finally {
            this.text = null;
          }
}}
/* ListEnd */
<YYINITIAL> {
({newline})+/[^#*-] {
          try {
            this.ListsnewLineCount += this.getText().length();
            this.ListsnewLineCount -= (ListSequence.fromList(this.ListslistPrefix).isNotEmpty() ?
              1 :
              0
            );
            this.flushNewLines(true);
            ListSequence.fromList(this.ListslistPrefix).clear();
          } finally {
            this.text = null;
          }
}}
/* NewLineEofIgnore */
<YYINITIAL> {
{newline}+/. {
          try {
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append(this.getNewline(this.getText().length(), "\n"));
            }
            //  just ignore, newlines at the end of input are not appended
          } finally {
            this.text = null;
          }
}}
/* CheckNewLine */
<CHECK_NEW_LINE> {
[^\n]*(\n)? {
          try {
            this.processNewLineChecking(true);
          } finally {
            this.text = null;
          }
}}
/* NewLineEofIgnore */
<YYINITIAL> {
{newline}* {
          try {
            //  just ignore, newlines at the end of input are not appended
          } finally {
            this.text = null;
          }
}}
/* LabeledHttpLink */
<YYINITIAL> {
"["{schemas}"://"{allowedUrlSymbol}+(" "[^\n\[\]]+)?"]" {
          try {
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append(this.yytext(1, 1).trim());
            }
          } finally {
            this.text = null;
          }
}}
/* ConfluenceStyledLink */
<YYINITIAL> {
"["[^\n\]]+"|"{schemas}"://"({allowedUrlSymbol}|[ ])+"]" {
          try {
            int linkEnds = this.getText().indexOf('|');
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append(this.yytext(linkEnds + 1, 1).trim());
            }
          } finally {
            this.text = null;
          }
}}
/* SchemaLink */
<YYINITIAL> {
{schemas}"://"({allowedUrlSymbolWOB}|"("{allowedUrlSymbolWOB}*")")+ {
          try {
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append(this.getText());
            }
          } finally {
            this.text = null;
          }
}}
/* SchemaLinkInBraces */
<YYINITIAL> {
"("{schemas}"://"{allowedUrlSymbolWOB}+")" {
          try {
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append(this.getText());
            }
          } finally {
            this.text = null;
          }
}}
/* LinkToWithTagBrackets */
<YYINITIAL> {
"<"{schemas}"://"({allowedUrlSymbolWOB}+)">" {
          try {
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append(this.getText());
            }
          } finally {
            this.text = null;
          }
}}
/* Email */
<YYINITIAL> {
"<"{email}">" {
          try {
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append(this.getText());
            }
          } finally {
            this.text = null;
          }
}}
/* EmailImportFromHtml */
<YYINITIAL> {
"&lt;"{email}"&gt;" {
          try {
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append(this.getText());
            }
          } finally {
            this.text = null;
          }
}}
/* H4 */
<YYINITIAL> {
^"===="~"===="[\r\n] {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append(HtmlStringUtil.html(this.yytext(4, 5)));
          this.builderContext.append(" ");
}}
/* H3 */
<YYINITIAL> {
^"==="~"==="[\r\n] {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append(HtmlStringUtil.html(this.yytext(3, 4)));
          this.builderContext.append(" ");
}}
/* H2 */
<YYINITIAL> {
^"=="~"=="[\r\n] {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append(HtmlStringUtil.html(this.yytext(2, 3)));
          this.builderContext.append(" ");
}}
/* H1 */
<YYINITIAL> {
^"="~"="[\r\n] {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append(HtmlStringUtil.html(this.yytext(1, 2)));
          this.builderContext.append(" ");
}}
/* BoldItalic */
<YYINITIAL> {
"'''''"~"'''''" {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append(HtmlStringUtil.html(this.yytext(5, 5)));
}}
/* Bold */
<YYINITIAL> {
"'''"~"'''" {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append(HtmlStringUtil.html(this.yytext(3, 3)));
}}
/* Italic */
<YYINITIAL> {
"''"~"''" {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append(HtmlStringUtil.html(this.yytext(2, 2)));
}}
/* Strikethrough */
<YYINITIAL> {
--[^ \t\n\r-]-- {
          try {
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append("" + this.getText().charAt(2));
            }
          } finally {
            this.text = null;
          }
}}
/* Strikethrough */
<YYINITIAL> {
--[^ \t\n\r-]([^\n\r-]|([-][^-]))*[-]?[^ \t\n\r-]-- {
          try {
            {
              TBaseBuilderContext builderContext = this.builderContext;
              this.clone(this.yytext(2, 2)).processSafe(builderContext);
            }
          } finally {
            this.text = null;
          }
}}
/* Line */
<YYINITIAL> {
("-"){5}("-")*(" "*[\r\n])? {
          try {
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append(HtmlStringUtil.html(this.getText()));
            }
          } finally {
            this.text = null;
          }
}}
/* TitledText */
<YYINITIAL> {
\~\~~\|~(\~\~) {
          try {
            {
              TBaseBuilderContext builderContext = this.builderContext;
              this.clone(StringUtils.substring(this.getText(), 2, this.getText().lastIndexOf("|"))).processSafe(builderContext);
            }
          } finally {
            this.text = null;
          }
}}
/* Underlined */
<YYINITIAL> {
{baseUnderlineRegexp}({nonWordSymbol}|{baseUnderlineRegexp}) {
          try {
            this.removeFramingMarkup("+", "u", false);
          } finally {
            this.text = null;
          }
}}
/* Underlined */
<YYINITIAL> {
^\+([^ \t\n\r\+]([ ]|\\\+)*)*(([^ \t\n\r\+\\]|\\\+)\+)({nonWordSymbol}|{baseUnderlineRegexp}) {
          try {
            this.removeFramingMarkup("+", "u", false);
          } finally {
            this.text = null;
          }
}}
/* BoldAsterisk */
<YYINITIAL> {
{baseAsteriskRegexp}({nonWordSymbol}|{baseAsteriskRegexp}) {
          try {
            this.removeFramingMarkup("*", "strong", false);
          } finally {
            this.text = null;
          }
}}
/* BoldAsterisk */
<YYINITIAL> {
^\*([^ \t\n\r\*]([ ]|\\\*)*)*(([^ \t\n\r\*\\]|\\\*)\*)({nonWordSymbol}|{baseAsteriskRegexp}) {
          try {
            this.removeFramingMarkup("*", "strong", false);
          } finally {
            this.text = null;
          }
}}
/* EscapeSymbol */
<YYINITIAL> {
"\\"[+*_\-`{}\[\]\(\)#\.\!] {
          try {
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append(this.yytext(1, 0));
            }
          } finally {
            this.text = null;
          }
}}
/* SkipedCharacters */
<YYINITIAL> {
[\u0000-\u0008\u000B-\u000C\u000E-\u001F] {
          try {
          } finally {
            this.text = null;
          }
}}
/* empty */
<YYINITIAL> {
\r {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("\r");
}}
/* tab */
<YYINITIAL> {
\t {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("\t");
}}
/* Amp */
<YYINITIAL> {
"&" {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("&");
}}
/* Lt */
<YYINITIAL> {
"<" {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("<");
}}
/* Gt */
<YYINITIAL> {
">" {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append(">");
}}
/* DoubleQuote */
<YYINITIAL> {
\" {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("\"");
}}
/* SingleQuote */
<YYINITIAL> {
\' {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("\'");
}}
/* breakline */
<YYINITIAL> {
\n {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("\n");
}}
/* Issue */
<YYINITIAL, HTML> {
{issue} {
          try {
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append(this.getText());
            }
          } finally {
            this.text = null;
          }
}}
/* Issue */
<YYINITIAL, HTML> {
{issue}/([\.]?[:jletterdigit:]) {
          try {
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append(this.getText());
            }
          } finally {
            this.text = null;
          }
}}
/* issueAttachment */
<YYINITIAL> {
{attachment} {
          try {
            this.appendAttachment(true);
          } finally {
            this.text = null;
          }
}}
/* Image */
<YYINITIAL> {
{image} {
          try {
            this.appendImage(true);
          } finally {
            this.text = null;
          }
}}
/* Username */
<YYINITIAL, HTML> {
{username} {
          try {
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append(this.getText());
            }
          } finally {
            this.text = null;
          }
}}
/* UsernameCanNotBeInTheMiddle */
<YYINITIAL, HTML> {
[:jletterdigit:][@] {
          try {
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append(this.getText());
            }
          } finally {
            this.text = null;
          }
}}
/* CommitHash0 */
<YYINITIAL, HTML> {
{separator}{hash} {
          try {
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append(this.getText());
            }
          } finally {
            this.text = null;
          }
}}
/* CommitHash1 */
<YYINITIAL, HTML> {
^{hash} {
          try {
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append(this.getText());
            }
          } finally {
            this.text = null;
          }
}}
/* Query */
<YYINITIAL, HTML> {
"[query:"~"]" {
          try {
            this.appendQuery(true);
          } finally {
            this.text = null;
          }
}}
/* LongString */
<YYINITIAL, HTML> {
{base64Symbol}{666}{base64Symbol}* {
          try {
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append(HtmlStringUtil.html(this.getText()));
            }
          } finally {
            this.text = null;
          }
}}
/* Finish */
<YYINITIAL, CHECK_NEW_LINE, HTML, HTML, HTML> {
. {
          this.builderContext.append(BaseProcessor.characterToStringSafe(this.yycharat(0)));
}}
