<#escape x as x?html>
    <#assign comments = issue.comments>
    <#assign limit = 100>
    <#assign size = comments?size>
    <#if comments?has_content>
        <div class="rn-comment-wrp">
            <div class="rn-comment-title">
                Comments
                <#if (size > limit)>
                    <span class="nobold">
                        (last ${limit} of ${size} shown)
                    </span>
                </#if>
            </div>
            <#list comments as comment>
                <div class="rn-comment-item">
                    <div class="rn-comment-author">
                        ${comment.author.getVisibleName()}
                        <div class="rn-comment-date">
                            ${Utils.inUserTimeZone(comment.created)}
                        </div>
                    </div>
                    <div class="rn-comment-text">
                        <@wiki><#noescape>${comment.text}</#noescape></@wiki>
                    </div>
                </div>
            </#list>
        </div>
    </#if>
</#escape>