/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.customfields.oldRest.build;

import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import jetbrains.charisma.customfields.complex.common.RequireBundleIsAccessibleSecurityConstraint;
import jetbrains.charisma.customfields.oldRest.OldRestBundleServiceImplKt;
import jetbrains.charisma.customfields.oldRest.build.BuildBean;
import jetbrains.charisma.customfields.oldRest.build.BuildBundleBean;
import jetbrains.charisma.customfields.oldRest.build.BuildBundleRef;
import jetbrains.charisma.customfields.oldRest.build.OldRestBuildsBundleResource;
import jetbrains.charisma.customfields.persistence.fields.XdBuild;
import jetbrains.charisma.customfields.persistence.fields.XdBuildsBundle;
import jetbrains.charisma.customfields.persistence.fields.XdField;
import jetbrains.charisma.customfields.persistence.fields.XdFieldBundle;
import jetbrains.charisma.rest.IsLoggedInSecurityConstraint;
import jetbrains.charisma.smartadmin.rest.RequireAdminOrCreateProjectPermissionSecurityConstraint;
import jetbrains.charisma.smartadmin.rest.ResponseUtil;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.webr.rpc.rest.filter.runtime.Transactional;
import jetbrains.mps.webr.rpc.rest.runtime.Resource;
import jetbrains.mps.webr.runtime.uri.QueryParameter;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.XdEntityType;
import kotlinx.dnq.query.FilteringContext;
import kotlinx.dnq.query.XdFilteringQueryKt;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import webr.framework.url.UrlUtil;

@Path(value="/admin/customfield/buildBundle")
@Produces(value={"application/xml;charset=UTF-8", "application/json;charset=UTF-8"})
@Transactional
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u0006H\u0007J\u001c\u0010\u0007\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\b\u001a\u00020\u0006H\u0007J\"\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0007J\u0012\u0010\u0013\u001a\u00020\u00142\b\b\u0001\u0010\u0005\u001a\u00020\u0006H\u0007J\u001c\u0010\u0015\u001a\u00020\u00162\b\b\u0001\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\b\u001a\u00020\u0006H\u0007J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\nH\u0002J\u001c\u0010\u001a\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u001b\u001a\u00020\u0006H\u0007JQ\u0010\u001c\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\b\u001a\u00020\u00062\n\b\u0001\u0010\u001b\u001a\u0004\u0018\u00010\u00062\n\b\u0001\u0010\u001d\u001a\u0004\u0018\u00010\u00062\n\b\u0001\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\n\b\u0001\u0010 \u001a\u0004\u0018\u00010!H\u0007\u00a2\u0006\u0002\u0010\"J\u0010\u0010#\u001a\u00020\u00042\u0006\u0010$\u001a\u00020\u0014H\u0007JE\u0010%\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\b\u001a\u00020\u00062\n\b\u0001\u0010\u001d\u001a\u0004\u0018\u00010\u00062\n\b\u0001\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\n\b\u0001\u0010 \u001a\u0004\u0018\u00010!H\u0007\u00a2\u0006\u0002\u0010&\u00a8\u0006'"}, d2={"Ljetbrains/charisma/customfields/oldRest/build/OldRestBuildsBundleResource;", "Ljetbrains/mps/webr/rpc/rest/runtime/Resource;", "()V", "deleteBundleName", "Ljavax/ws/rs/core/Response;", "bundleName", "", "deleteBundleNameBuildName", "buildName", "findBuild", "Ljetbrains/charisma/customfields/persistence/fields/XdBuild;", "bundle", "Ljetbrains/charisma/customfields/persistence/fields/XdBuildsBundle;", "shouldExist", "", "findBundle", "get", "", "Ljetbrains/charisma/customfields/oldRest/build/BuildBundleRef;", "getBundleName", "Ljetbrains/charisma/customfields/oldRest/build/BuildBundleBean;", "getBundleNameBuildName", "Ljetbrains/charisma/customfields/oldRest/build/BuildBean;", "getUrl", "Lwebr/framework/url/UrlUtil$Url;", "build", "postBundleName", "newName", "postBundleNameBuildName", "description", "colorIndex", "", "assembleDate", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Long;)Ljavax/ws/rs/core/Response;", "put", "bundleBean", "putBundleNameBuildName", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Long;)Ljavax/ws/rs/core/Response;", "charisma-customfields"})
public final class OldRestBuildsBundleResource
implements Resource {
    @GET
    @NotNull
    public final List<BuildBundleRef> get() {
        IsLoggedInSecurityConstraint.check();
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)XdQueryKt.asSequence((XdQuery)XdBuildsBundle.Companion.all()), (Function1)get.1.INSTANCE));
    }

    @GET
    @Path(value="/{bundleName}")
    @NotNull
    public final BuildBundleBean getBundleName(@PathParam(value="bundleName") @NotNull String bundleName) {
        Intrinsics.checkParameterIsNotNull((Object)bundleName, (String)"bundleName");
        IsLoggedInSecurityConstraint.check();
        RequireBundleIsAccessibleSecurityConstraint.check(bundleName);
        XdBuildsBundle xdBuildsBundle = this.findBundle(bundleName, true);
        if (xdBuildsBundle == null) {
            Intrinsics.throwNpe();
        }
        return new BuildBundleBean(xdBuildsBundle);
    }

    /*
     * WARNING - void declaration
     */
    @PUT
    @Consumes(value={"application/xml"})
    @NotNull
    public final Response put(@NotNull BuildBundleBean bundleBean) {
        Intrinsics.checkParameterIsNotNull((Object)bundleBean, (String)"bundleBean");
        IsLoggedInSecurityConstraint.check();
        RequireAdminOrCreateProjectPermissionSecurityConstraint.check();
        String string = bundleBean.getName();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        this.findBundle(string, false);
        XdBuildsBundle bundle2 = (XdBuildsBundle)XdBuildsBundle.Companion.new((Function1)new Function1<XdBuildsBundle, Unit>(bundleBean){
            final /* synthetic */ BuildBundleBean $bundleBean;

            public final void invoke(@NotNull XdBuildsBundle $receiver) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)$receiver), (String)"receiver$0");
                String string = this.$bundleBean.getName();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                $receiver.setName(string);
            }
            {
                this.$bundleBean = buildBundleBean;
                super(1);
            }
        });
        List<BuildBean> list = bundleBean.getBuild();
        if (list != null) {
            Iterable $receiver$iv = list;
            int index$iv = 0;
            for (Object item$iv : $receiver$iv) {
                void buildBean;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                int n2 = n;
                BuildBean buildBean2 = (BuildBean)item$iv;
                int index = n2;
                XdBuild.Companion.new((Function1)new Function1<XdBuild, Unit>((BuildBean)buildBean, index, bundle2){
                    final /* synthetic */ BuildBean $buildBean;
                    final /* synthetic */ int $index;
                    final /* synthetic */ XdBuildsBundle $bundle$inlined;
                    {
                        this.$buildBean = buildBean;
                        this.$index = n;
                        this.$bundle$inlined = xdBuildsBundle;
                        super(1);
                    }

                    public final void invoke(@NotNull XdBuild $receiver) {
                        Intrinsics.checkParameterIsNotNull((Object)((Object)$receiver), (String)"receiver$0");
                        String string = this.$buildBean.getValue();
                        if (string == null) {
                            Intrinsics.throwNpe();
                        }
                        $receiver.setName(string);
                        $receiver.setBundle(this.$bundle$inlined);
                        $receiver.setAssembleDate(this.$buildBean.getAssembleDate());
                        $receiver.setDescription(this.$buildBean.getDescription());
                        Integer n = this.$buildBean.getColorIndex();
                        $receiver.setColorIndex(n != null ? n : 0);
                        $receiver.setOrdinal(this.$index);
                    }
                });
            }
        }
        Response response = ResponseUtil.created((UrlUtil.Url)OldRestBundleServiceImplKt.getOldRestBundleService().urlOf(bundle2));
        Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"ResponseUtil.created(old\u2026dleService.urlOf(bundle))");
        return response;
    }

    @POST
    @Path(value="/{bundleName}")
    @NotNull
    public final Response postBundleName(@PathParam(value="bundleName") @NotNull String bundleName, @QueryParam(value="newName") @NotNull String newName) {
        Intrinsics.checkParameterIsNotNull((Object)bundleName, (String)"bundleName");
        Intrinsics.checkParameterIsNotNull((Object)newName, (String)"newName");
        IsLoggedInSecurityConstraint.check();
        RequireAdminOrCreateProjectPermissionSecurityConstraint.check();
        XdBuildsBundle xdBuildsBundle = this.findBundle(bundleName, true);
        if (xdBuildsBundle == null) {
            Intrinsics.throwNpe();
        }
        XdBuildsBundle bundle2 = xdBuildsBundle;
        ResponseUtil.isRequired((String)"newName", (String)newName);
        String oldName = bundle2.getName();
        if (Intrinsics.areEqual((Object)newName, (Object)oldName) ^ true) {
            this.findBundle(newName, false);
            bundle2.setName(newName);
        }
        Response response = ResponseUtil.updated((UrlUtil.Url)OldRestBundleServiceImplKt.getOldRestBundleService().urlOf(bundle2), (String)oldName, (String)newName);
        Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"ResponseUtil.updated(old\u2026undle), oldName, newName)");
        return response;
    }

    @DELETE
    @Path(value="/{bundleName}")
    @NotNull
    public final Response deleteBundleName(@PathParam(value="bundleName") @NotNull String bundleName) {
        Intrinsics.checkParameterIsNotNull((Object)bundleName, (String)"bundleName");
        IsLoggedInSecurityConstraint.check();
        RequireAdminOrCreateProjectPermissionSecurityConstraint.check();
        XdBuildsBundle xdBuildsBundle = this.findBundle(bundleName, true);
        if (xdBuildsBundle == null) {
            Intrinsics.throwNpe();
        }
        Response response = ResponseUtil.deleted((Entity)xdBuildsBundle.getEntity());
        Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"ResponseUtil.deleted(fin\u2026ndleName, true)!!.entity)");
        return response;
    }

    @GET
    @Path(value="/{bundleName}/{buildName}")
    @NotNull
    public final BuildBean getBundleNameBuildName(@PathParam(value="bundleName") @NotNull String bundleName, @PathParam(value="buildName") @NotNull String buildName) {
        Intrinsics.checkParameterIsNotNull((Object)bundleName, (String)"bundleName");
        Intrinsics.checkParameterIsNotNull((Object)buildName, (String)"buildName");
        IsLoggedInSecurityConstraint.check();
        XdBuildsBundle xdBuildsBundle = this.findBundle(bundleName, true);
        if (xdBuildsBundle == null) {
            Intrinsics.throwNpe();
        }
        return new BuildBean(this.findBuild(xdBuildsBundle, buildName, true));
    }

    @PUT
    @Path(value="/{bundleName}/{buildName}")
    @NotNull
    public final Response putBundleNameBuildName(@PathParam(value="bundleName") @NotNull String bundleName, @PathParam(value="buildName") @NotNull String buildName, @QueryParam(value="description") @Nullable String description, @QueryParam(value="colorIndex") @Nullable Integer colorIndex, @QueryParam(value="assembleDate") @Nullable Long assembleDate) {
        XdBuildsBundle bundle2;
        Intrinsics.checkParameterIsNotNull((Object)bundleName, (String)"bundleName");
        Intrinsics.checkParameterIsNotNull((Object)buildName, (String)"buildName");
        IsLoggedInSecurityConstraint.check();
        RequireAdminOrCreateProjectPermissionSecurityConstraint.check();
        XdBuildsBundle xdBuildsBundle = bundle2 = this.findBundle(bundleName, true);
        if (xdBuildsBundle == null) {
            Intrinsics.throwNpe();
        }
        this.findBuild(xdBuildsBundle, buildName, false);
        XdBuild build2 = (XdBuild)XdBuild.Companion.new((Function1)new Function1<XdBuild, Unit>(bundle2, assembleDate, description, colorIndex, buildName){
            final /* synthetic */ XdBuildsBundle $bundle;
            final /* synthetic */ Long $assembleDate;
            final /* synthetic */ String $description;
            final /* synthetic */ Integer $colorIndex;
            final /* synthetic */ String $buildName;

            public final void invoke(@NotNull XdBuild $receiver) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)$receiver), (String)"receiver$0");
                this.$bundle.getChildren().add((XdEntity)$receiver);
                $receiver.setAssembleDate(this.$assembleDate);
                $receiver.setBundle(this.$bundle);
                $receiver.setAssembleDate(this.$assembleDate);
                $receiver.setDescription(this.$description);
                Integer n = this.$colorIndex;
                $receiver.setColorIndex(n != null ? n : 0);
                $receiver.setName(this.$buildName);
            }
            {
                this.$bundle = xdBuildsBundle;
                this.$assembleDate = l;
                this.$description = string;
                this.$colorIndex = n;
                this.$buildName = string2;
                super(1);
            }
        });
        Response response = ResponseUtil.created((UrlUtil.Url)this.getUrl(build2));
        Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"ResponseUtil.created(getUrl(build))");
        return response;
    }

    @POST
    @Path(value="/{bundleName}/{buildName}")
    @NotNull
    public final Response postBundleNameBuildName(@PathParam(value="bundleName") @NotNull String bundleName, @PathParam(value="buildName") @NotNull String buildName, @QueryParam(value="newName") @Nullable String newName, @QueryParam(value="description") @Nullable String description, @QueryParam(value="colorIndex") @Nullable Integer colorIndex, @QueryParam(value="assembleDate") @Nullable Long assembleDate) {
        CharSequence charSequence;
        Intrinsics.checkParameterIsNotNull((Object)bundleName, (String)"bundleName");
        Intrinsics.checkParameterIsNotNull((Object)buildName, (String)"buildName");
        IsLoggedInSecurityConstraint.check();
        RequireAdminOrCreateProjectPermissionSecurityConstraint.check();
        XdBuildsBundle xdBuildsBundle = this.findBundle(bundleName, true);
        if (xdBuildsBundle == null) {
            Intrinsics.throwNpe();
        }
        XdBuildsBundle bundle2 = xdBuildsBundle;
        XdBuild xdBuild = this.findBuild(bundle2, buildName, true);
        if (xdBuild == null) {
            Intrinsics.throwNpe();
        }
        XdBuild field2 = xdBuild;
        if (assembleDate != null) {
            field2.setAssembleDate(assembleDate);
        }
        String oldName = field2.getName();
        if (newName != null && (charSequence = (CharSequence)newName).length() > 0 && Intrinsics.areEqual((Object)oldName, (Object)newName) ^ true) {
            this.findBuild(bundle2, newName, false);
            field2.setName(newName);
        }
        if (description != null) {
            field2.setDescription(description);
        }
        if (colorIndex != null) {
            field2.setColorIndex(colorIndex);
        }
        Response response = ResponseUtil.updated((UrlUtil.Url)this.getUrl(field2), (String)oldName, (String)newName);
        Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"ResponseUtil.updated(\n  \u2026ldName, newName\n        )");
        return response;
    }

    @DELETE
    @Path(value="/{bundleName}/{buildName}")
    @NotNull
    public final Response deleteBundleNameBuildName(@PathParam(value="bundleName") @NotNull String bundleName, @PathParam(value="buildName") @NotNull String buildName) {
        Intrinsics.checkParameterIsNotNull((Object)bundleName, (String)"bundleName");
        Intrinsics.checkParameterIsNotNull((Object)buildName, (String)"buildName");
        IsLoggedInSecurityConstraint.check();
        RequireAdminOrCreateProjectPermissionSecurityConstraint.check();
        XdBuildsBundle xdBuildsBundle = this.findBundle(bundleName, true);
        if (xdBuildsBundle == null) {
            Intrinsics.throwNpe();
        }
        XdBuild xdBuild = this.findBuild(xdBuildsBundle, buildName, true);
        if (xdBuild == null) {
            Intrinsics.throwNpe();
        }
        Response response = ResponseUtil.deleted((Entity)xdBuild.getEntity());
        Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"ResponseUtil.deleted(fin\u2026uildName, true)!!.entity)");
        return response;
    }

    private final XdBuild findBuild(XdBuildsBundle bundle2, String buildName, boolean shouldExist) {
        XdBuild field2 = (XdBuild)XdQueryKt.firstOrNull((XdQuery)XdFilteringQueryKt.filter((XdQuery)XdQueryKt.filterIsInstance((XdQuery)((XdQuery)bundle2.getChildren()), (XdEntityType)((XdEntityType)XdBuild.Companion)), (Function2)((Function2)new Function2<FilteringContext, XdBuild, Unit>(buildName){
            final /* synthetic */ String $buildName;

            public final void invoke(@NotNull FilteringContext $receiver, @NotNull XdBuild it) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                Intrinsics.checkParameterIsNotNull((Object)((Object)it), (String)"it");
                $receiver.eq((Comparable)((Object)it.getName()), (Comparable)((Object)this.$buildName));
            }
            {
                this.$buildName = string;
                super(2);
            }
        })));
        ResponseUtil.assertExist((String)"Build", (Object)((Object)field2), (String)buildName, (boolean)shouldExist);
        return field2;
    }

    private final UrlUtil.Url getUrl(XdBuild build2) {
        UrlUtil.Url url = UrlUtil.getRestPathUri((String[])new String[]{"admin", "customfield", "buildBundle"});
        String[] stringArray = new String[2];
        XdFieldBundle<? extends XdField> xdFieldBundle = build2.getBundle();
        if (xdFieldBundle == null) {
            Intrinsics.throwNpe();
        }
        stringArray[0] = xdFieldBundle.getName();
        stringArray[1] = build2.getName();
        UrlUtil.Url url2 = url.addPathElements(stringArray).addQueryParameters(new QueryParameter[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)url2, (String)"UrlUtil.getRestPathUri(\"\u2026ame).addQueryParameters()");
        return url2;
    }

    private final XdBuildsBundle findBundle(String bundleName, boolean shouldExist) {
        XdBuildsBundle bundle2 = (XdBuildsBundle)XdQueryKt.firstOrNull((XdQuery)XdFilteringQueryKt.filter((XdEntityType)((XdEntityType)XdBuildsBundle.Companion), (Function2)((Function2)new Function2<FilteringContext, XdBuildsBundle, Unit>(bundleName){
            final /* synthetic */ String $bundleName;

            public final void invoke(@NotNull FilteringContext $receiver, @NotNull XdBuildsBundle it) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                Intrinsics.checkParameterIsNotNull((Object)((Object)it), (String)"it");
                $receiver.eq((Comparable)((Object)it.getName()), (Comparable)((Object)this.$bundleName));
            }
            {
                this.$bundleName = string;
                super(2);
            }
        })));
        ResponseUtil.assertExist((String)"Build bundle", (Object)((Object)bundle2), (String)bundleName, (boolean)shouldExist);
        return bundle2;
    }
}

