/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.customfields.simple.floatType;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Comparator;
import javax.annotation.PostConstruct;
import jetbrains.charisma.customfields.Localization;
import jetbrains.charisma.customfields.complex.common.parser.CustomFieldKeyWordInstaller;
import jetbrains.charisma.customfields.parser.CustomFieldInstaller;
import jetbrains.charisma.customfields.parser.EmptyCustomFieldPrefixTreeCreator;
import jetbrains.charisma.customfields.persistence.XdCustomFieldPrototype;
import jetbrains.charisma.customfields.persistence.XdProjectCustomField;
import jetbrains.charisma.customfields.simple.common.BeansKt;
import jetbrains.charisma.customfields.simple.common.persistence.SimpleComparableCustomFieldType;
import jetbrains.charisma.customfields.simple.floatType.FloatFieldType;
import jetbrains.charisma.customfields.simple.floatType.FloatFieldValue;
import jetbrains.charisma.customfields.simple.floatType.FloatFieldWrapper;
import jetbrains.charisma.customfields.simple.floatType.FloatPrefixIterable;
import jetbrains.charisma.customfields.simple.floatType.ParserFloatField;
import jetbrains.charisma.plugins.CustomFieldType;
import jetbrains.charisma.plugins.CustomFieldWrapper;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.youtrack.api.customfields.DetalizationLevel;
import jetbrains.youtrack.api.customfields.FieldValueRenderer;
import jetbrains.youtrack.api.parser.TreeKeyLocation;
import jetbrains.youtrack.parser.prefixTree.PrefixIterable;
import jetbrains.youtrack.persistent.XdIssue;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Service;

@Service(value="floatFieldType")
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0004\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0017\u0018\u0000 #2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001#B\u0005\u00a2\u0006\u0002\u0010\u0003J\"\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u0015\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u0011H\u0016\u00a2\u0006\u0002\u0010\u0012J\b\u0010\u0013\u001a\u00020\u0014H\u0014J\u0019\u0010\u0015\u001a\u0004\u0018\u00010\u00022\b\u0010\u000e\u001a\u0004\u0018\u00010\u0016H\u0016\u00a2\u0006\u0002\u0010\u0017J$\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001aH\u0016J\u0018\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0016H\u0016J\b\u0010 \u001a\u00020!H\u0007J\b\u0010\"\u001a\u00020!H\u0016R\u0018\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006$"}, d2={"Ljetbrains/charisma/customfields/simple/floatType/FloatFieldType;", "Ljetbrains/charisma/customfields/simple/common/persistence/SimpleComparableCustomFieldType;", "", "()V", "valueClass", "Ljava/lang/Class;", "getValueClass", "()Ljava/lang/Class;", "canSetValue", "", "issue", "Ljetbrains/youtrack/persistent/XdIssue;", "prototype", "Ljetbrains/charisma/customfields/persistence/XdCustomFieldPrototype;", "value", "", "convertNumericValue", "", "(Ljava/lang/Number;)Ljava/lang/Float;", "createInstaller", "Ljetbrains/charisma/customfields/parser/CustomFieldInstaller;", "createValueFromString", "", "(Ljava/lang/String;)Ljava/lang/Float;", "getFieldWrapper", "Ljetbrains/charisma/plugins/CustomFieldWrapper;", "Ljetbrains/exodus/entitystore/Entity;", "i", "field", "getValueRenderer", "Ljetbrains/youtrack/api/customfields/FieldValueRenderer;", "nullValueText", "init", "", "install", "Companion", "charisma-customfields"})
public class FloatFieldType
extends SimpleComparableCustomFieldType<Float> {
    @NotNull
    private final Class<?> valueClass = Float.TYPE;
    private static final String FORMAT = "#.#####";
    private static final String FLOATS = "FLOATS";
    @NotNull
    private static final Iterable<String> FLOAT_TREES;
    public static final Companion Companion;

    @PostConstruct
    public final void init() {
        this.setName("float");
        this.setLocalizationId("youtrack.customfieldtype.float");
        this.setEditor("FloatEditor");
        this.setEditorMobile("FloatEditorMobile");
    }

    @Nullable
    public Float createValueFromString(@Nullable String value2) {
        try {
            return Float.valueOf(Companion.getFormatter().parse(value2).floatValue());
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    @NotNull
    public Float convertNumericValue(@NotNull Number value2) {
        Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
        return Float.valueOf(value2.floatValue());
    }

    @Override
    @NotNull
    protected CustomFieldInstaller createInstaller() {
        return new CustomFieldKeyWordInstaller<ParserFloatField>(this, (CustomFieldType)this){
            final /* synthetic */ FloatFieldType this$0;

            @NotNull
            protected ParserFloatField toField(@NotNull XdCustomFieldPrototype entity) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)entity), (String)"entity");
                return new ParserFloatField(entity);
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1);
            }
        };
    }

    @NotNull
    public CustomFieldWrapper<Entity, Float> getFieldWrapper(@NotNull Entity i, @NotNull Entity field2) {
        Intrinsics.checkParameterIsNotNull((Object)i, (String)"i");
        Intrinsics.checkParameterIsNotNull((Object)field2, (String)"field");
        return new FloatFieldWrapper(i, field2, this);
    }

    @Override
    @NotNull
    public Class<?> getValueClass() {
        return this.valueClass;
    }

    @Override
    public void install() {
        jetbrains.charisma.keyword.BeansKt.getPrefixTrees().putTree(FLOATS, (PrefixIterable)new FloatPrefixIterable<FloatFieldValue>(){

            @NotNull
            public FloatFieldValue getValue(@NotNull StringBuilder number) {
                Intrinsics.checkParameterIsNotNull((Object)number, (String)"number");
                String string = number.toString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"number.toString()");
                String value2 = string;
                return new FloatFieldValue(BeansKt.getFloatFieldType().createValueFromString(value2), value2, jetbrains.charisma.customfields.simple.floatType.FloatFieldType$Companion.access$getFloatValueDescription$p(FloatFieldType.Companion));
            }
        }, TreeKeyLocation.NONE, TreeKeyLocation.NONE, FloatFieldType.Companion.createComparator());
        super.install();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean canSetValue(@NotNull XdIssue issue, @NotNull XdCustomFieldPrototype prototype2, @Nullable Object value2) {
        Intrinsics.checkParameterIsNotNull((Object)issue, (String)"issue");
        Intrinsics.checkParameterIsNotNull((Object)((Object)prototype2), (String)"prototype");
        if (!super.canSetValue(issue, prototype2, value2)) return false;
        if (value2 instanceof Float) return true;
        if (value2 != null) return false;
        XdProjectCustomField xdProjectCustomField = prototype2.getProjectCustomField(issue.getProject());
        if (xdProjectCustomField == null) return true;
        boolean bl = xdProjectCustomField.getCanBeEmpty();
        if (!bl) return false;
        return true;
    }

    @Override
    @NotNull
    public FieldValueRenderer<Float> getValueRenderer(@Nullable String nullValueText) {
        return (FieldValueRenderer)new FieldValueRenderer<Float>(nullValueText, nullValueText){
            final /* synthetic */ String $nullValueText;

            @Nullable
            public String renderValue(@Nullable Float value2, @NotNull DetalizationLevel level) {
                Intrinsics.checkParameterIsNotNull((Object)level, (String)"level");
                return value2 == null ? this.$nullValueText : FloatFieldType.Companion.getFormatter().format(value2);
            }
            {
                this.$nullValueText = $captured_local_variable$0;
                super($super_call_param$1);
            }
        };
    }

    static {
        Companion = new Companion(null);
        FLOAT_TREES = CollectionsKt.listOf((Object[])new String[]{EmptyCustomFieldPrefixTreeCreator.Companion.getEMPTY_CUSTOM_FIELD(), "OPEN_RANGE", FLOATS});
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0012H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0013"}, d2={"Ljetbrains/charisma/customfields/simple/floatType/FloatFieldType$Companion;", "", "()V", "FLOATS", "", "FLOAT_TREES", "", "getFLOAT_TREES", "()Ljava/lang/Iterable;", "FORMAT", "floatValueDescription", "getFloatValueDescription", "()Ljava/lang/String;", "formatter", "Ljava/text/DecimalFormat;", "getFormatter", "()Ljava/text/DecimalFormat;", "createComparator", "Ljava/util/Comparator;", "charisma-customfields"})
    public static final class Companion {
        @NotNull
        public final Iterable<String> getFLOAT_TREES() {
            return FLOAT_TREES;
        }

        private final String getFloatValueDescription() {
            return (String)Localization.INSTANCE.getFloatDescription().invoke();
        }

        private final Comparator<Object> createComparator() {
            return createComparator.1.INSTANCE;
        }

        @NotNull
        public final DecimalFormat getFormatter() {
            DecimalFormatSymbols s = new DecimalFormatSymbols();
            s.setDecimalSeparator(FloatPrefixIterable.Companion.getDECIMAL_SEPARATOR());
            return new DecimalFormat(FloatFieldType.FORMAT, s);
        }

        private Companion() {
        }

        @NotNull
        public static final /* synthetic */ String access$getFloatValueDescription$p(Companion $this) {
            return $this.getFloatValueDescription();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

