/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.persistence.customfields.meta;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import jetbrains.charisma.persistence.customfields.meta.YClazz;
import jetbrains.charisma.persistence.customfields.meta.YMember;
import jetbrains.charisma.persistence.customfields.meta.YType;
import jetbrains.charisma.persistence.customfields.meta.YTypeReference;

@XmlType(name="Field")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class YField
extends YMember {
    @XmlElement
    private YTypeReference typeRef;
    @XmlAttribute
    private Boolean readOnly = false;
    @XmlTransient
    private String dbName;

    public YField() {
    }

    public YField(String name, String domain, String description, boolean ignoreInJs, boolean ignoreInXml) {
        this(name, domain);
        this.setDescription(description);
        this.setIgnoreInJs(ignoreInJs);
        this.setIgnoreInXml(ignoreInXml);
    }

    public YField(String name, String domain) {
        super(name, domain);
    }

    public YField(String name, String domain, Object ktBackingField, Object ktReceiver) {
        super(name, domain, ktBackingField, ktReceiver);
    }

    public YField(YField that, String domain) {
        super(that, domain);
        this.readOnly = that.readOnly;
        this.dbName = that.dbName;
        YTypeReference tr = new YTypeReference(that.getTypeRef());
        tr.setType(that.getTypeRef().getType());
        this.setTypeRef(tr);
    }

    public YType getType() {
        return this.typeRef.getType();
    }

    public YTypeReference getTypeRef() {
        return this.typeRef;
    }

    public void setTypeRef(YTypeReference typeRef) {
        YClazz.checkAlreadySet(this.typeRef);
        this.typeRef = typeRef;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        if (this.readOnly.booleanValue()) {
            throw new IllegalStateException("Can call this setter only once");
        }
        this.readOnly = readOnly;
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String dbName) {
        YClazz.checkAlreadySet(this.dbName);
        this.dbName = dbName;
    }
}

