/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.teamcity.persistence;

import java.util.HashSet;
import java.util.Set;
import jetbrains.buildServer.server.rest.data.Build;
import jetbrains.buildServer.server.rest.data.IssueUsage;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.ISelector;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.internal.collections.runtime.SetSequence;
import jetbrains.youtrack.integration.build.BuildStatus;
import jetbrains.youtrack.integration.build.BuildType;
import jetbrains.youtrack.integration.build.CommonBuildDTO;
import jetbrains.youtrack.integration.vcs.VcsUtils;

public class TeamcityBuildDTO
extends CommonBuildDTO {
    public TeamcityBuildDTO(Build build) {
        this.id = build.id;
        this.number = build.number;
        this.defaultBranch = build.defaultBranch;
        this.branch = build.branchName;
        this.start = VcsUtils.toDatetime((String)build.startDate);
        this.status = "success".equalsIgnoreCase(build.status) ? BuildStatus.SUCCESSFUL : BuildStatus.FAILED;
        this.relatedIssues = SetSequence.fromSet(new HashSet());
        if (build.relatedIssues != null) {
            SetSequence.fromSet((Set)this.relatedIssues).addSequence(Sequence.fromIterable(build.relatedIssues.issueUsage).select((_FunctionTypes._return_P1_E0)new ISelector<IssueUsage, String>(){

                public String select(IssueUsage it) {
                    return it.issue.id;
                }
            }));
        }
        this.type = new BuildType(build.buildType.id, build.buildType.name);
    }
}

