/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.baseLanguage.dates.runtime;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Locale;
import jetbrains.mps.baseLanguage.dates.runtime.DateTimeOperations;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimePrinter;

public abstract class ConditionalDateTimePrinter
implements DateTimePrinter {
    private List<DateTimePrinter> myPrinters;

    public int estimatePrintedLength() {
        int max = 0;
        for (DateTimePrinter printer : this.getAllPrinters()) {
            max = Math.max(max, printer.estimatePrintedLength());
        }
        return max;
    }

    public void printTo(StringBuffer buf, long instant, Chronology chrono, int displayOffset, DateTimeZone displayZone, Locale locale) {
        this.getPrinter(instant, displayOffset, displayZone, locale).printTo(buf, instant, chrono, displayOffset, displayZone, locale);
    }

    public void printTo(Writer out, long instant, Chronology chrono, int displayOffset, DateTimeZone displayZone, Locale locale) throws IOException {
        this.getPrinter(instant, displayOffset, displayZone, locale).printTo(out, instant, chrono, displayOffset, displayZone, locale);
    }

    public void printTo(StringBuffer buf, ReadablePartial partial, Locale locale) {
        this.getPrinter(partial, locale).printTo(buf, partial, locale);
    }

    public void printTo(Writer out, ReadablePartial partial, Locale locale) throws IOException {
        this.getPrinter(partial, locale).printTo(out, partial, locale);
    }

    protected DateTimePrinter getPrinter(ReadablePartial partial, Locale locale) {
        return this.getPrinter(partial != null ? partial.toDateTime(null) : null);
    }

    protected DateTimePrinter getPrinter(long instant, int displayOffset, DateTimeZone displayZone, Locale locale) {
        return this.getPrinter(instant != 0L ? new DateTime(instant - (long)displayOffset, displayZone) : null);
    }

    private DateTimePrinter getPrinter(DateTime dateTime) {
        int index = this.getPrinterIndex(DateTimeOperations.convert(dateTime));
        if (index >= 0) {
            List<DateTimePrinter> printers = this.getAllPrinters();
            return printers.get(index);
        }
        return DateTimeFormat.shortDateTime().getPrinter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<DateTimePrinter> getAllPrinters() {
        if (this.myPrinters == null) {
            ConditionalDateTimePrinter conditionalDateTimePrinter = this;
            synchronized (conditionalDateTimePrinter) {
                if (this.myPrinters == null) {
                    this.myPrinters = this.createPrinters();
                }
            }
        }
        return this.myPrinters;
    }

    protected abstract int getPrinterIndex(Long var1);

    protected abstract List<DateTimePrinter> createPrinters();
}

