/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.baseLanguage.dates.runtime;

import jetbrains.mps.baseLanguage.dates.runtime.DateTimeOperations;
import org.joda.time.DateTime;
import org.joda.time.DateTimeComparator;
import org.joda.time.Duration;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;

public class DateTimeArithmetics {
    public static Duration minus(Long left, Long right) {
        if (left == null || right == null) {
            return right == null ? (left != null ? new Duration((Object)left) : null) : new Duration(-right.longValue());
        }
        return new Duration(right.longValue(), left.longValue());
    }

    public static Period minus(DateTime leftExpression, DateTime rightExpression) {
        if (leftExpression == null || rightExpression == null) {
            return Period.ZERO;
        }
        if (leftExpression.compareTo((ReadableInstant)rightExpression) < 0) {
            Interval i = new Interval((ReadableInstant)leftExpression, (ReadableInstant)rightExpression);
            return new Period(0L).minus((ReadablePeriod)i.toPeriod());
        }
        Interval i = new Interval((ReadableInstant)rightExpression, (ReadableInstant)leftExpression);
        return i.toPeriod();
    }

    public static Period minus(Period left, Period right) {
        if (left == null || right == null) {
            return left;
        }
        return left.minus((ReadablePeriod)right);
    }

    public static Duration minus(Duration left, Duration right) {
        if (left == null || right == null) {
            return null;
        }
        return left.minus((ReadableDuration)right);
    }

    @Deprecated
    public static Long minus(Long leftExpression, Period rightExpression) {
        if (leftExpression == null || rightExpression == null) {
            return leftExpression;
        }
        return new DateTime((Object)leftExpression, DateTimeOperations.getCurrentTimeZone()).minus((ReadablePeriod)rightExpression).getMillis();
    }

    public static Long minus(Long left, Duration right) {
        if (left == null || right == null) {
            return left;
        }
        return left - right.getMillis();
    }

    public static DateTime minus(DateTime leftExpression, Period rightExpression) {
        return leftExpression == null ? null : leftExpression.minus((ReadablePeriod)rightExpression);
    }

    public static Period plus(Period left, Period right) {
        if (left == null || right == null) {
            return left == null ? right : left;
        }
        return left.plus((ReadablePeriod)right);
    }

    public static Duration plus(Duration left, Duration right) {
        if (left == null || right == null) {
            return left == null ? right : left;
        }
        return left.plus((ReadableDuration)right);
    }

    @Deprecated
    public static Long plus(Period left, Long right) {
        return DateTimeArithmetics.plus(right, left);
    }

    @Deprecated
    public static Long plus(Long left, Period right) {
        if (left == null || right == null) {
            return left;
        }
        return new DateTime((Object)left, DateTimeOperations.getCurrentTimeZone()).plus((ReadablePeriod)right).getMillis();
    }

    public static Long plus(Duration left, Long right) {
        return DateTimeArithmetics.plus(right, left);
    }

    public static Long plus(Long left, Duration right) {
        if (left == null || right == null) {
            return left;
        }
        return left + right.getMillis();
    }

    public static DateTime plus(DateTime left, Period right) {
        if (left == null || right == null) {
            return left;
        }
        return left.plus((ReadablePeriod)right);
    }

    public static DateTime plus(Period left, DateTime right) {
        return DateTimeArithmetics.plus(right, left);
    }

    public static Long min(Long a, Long b) {
        return a == null || b == null ? null : Long.valueOf(Math.min(a, b));
    }

    public static Long max(Long a, Long b) {
        return a == null ? b : (b == null ? a : Math.max(a, b));
    }

    public static DateTime min(DateTime a, DateTime b) {
        if (a == null || b == null) {
            return null;
        }
        int res = DateTimeComparator.getInstance().compare((Object)a, (Object)b);
        return res < 0 ? a : b;
    }

    public static DateTime max(DateTime a, DateTime b) {
        if (a == null || b == null) {
            return a != null ? a : b;
        }
        int res = DateTimeComparator.getInstance().compare((Object)a, (Object)b);
        return res > 0 ? a : b;
    }
}

