/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.baseLanguage.dates.runtime;

import java.io.IOException;
import java.io.Writer;
import java.util.Locale;
import org.joda.time.Chronology;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeParser;
import org.joda.time.format.DateTimeParserBucket;
import org.joda.time.format.DateTimePrinter;

public class FixedLocaleDateTimeFormatter
implements DateTimePrinter,
DateTimeParser {
    private DateTimeFormatter myDateTimeFormatter;
    private Locale myLocale;

    public FixedLocaleDateTimeFormatter(DateTimeFormatter dateTimeFormatter, Locale locale) {
        this.myDateTimeFormatter = dateTimeFormatter;
        this.myLocale = locale;
    }

    public int estimatePrintedLength() {
        return this.myDateTimeFormatter.getPrinter().estimatePrintedLength();
    }

    public void printTo(StringBuffer buf, long instant, Chronology chrono, int displayOffset, DateTimeZone displayZone, Locale locale) {
        this.myDateTimeFormatter.getPrinter().printTo(buf, instant, chrono, displayOffset, displayZone, this.myLocale);
    }

    public void printTo(Writer out, long instant, Chronology chrono, int displayOffset, DateTimeZone displayZone, Locale locale) throws IOException {
        this.myDateTimeFormatter.getPrinter().printTo(out, instant, chrono, displayOffset, displayZone, this.myLocale);
    }

    public void printTo(StringBuffer buf, ReadablePartial partial, Locale locale) {
        this.myDateTimeFormatter.getPrinter().printTo(buf, partial, this.myLocale);
    }

    public void printTo(Writer out, ReadablePartial partial, Locale locale) throws IOException {
        this.myDateTimeFormatter.getPrinter().printTo(out, partial, this.myLocale);
    }

    public int estimateParsedLength() {
        return this.myDateTimeFormatter.getParser().estimateParsedLength();
    }

    public int parseInto(DateTimeParserBucket bucket, String text, int position) {
        return this.myDateTimeFormatter.getParser().parseInto((DateTimeParserBucket)new LocaledDateTimeParserBucketWrapper(bucket, this.myLocale), text, position);
    }

    private static class LocaledDateTimeParserBucketWrapper
    extends DateTimeParserBucket {
        private DateTimeParserBucket myBucket;
        private Locale myLocale;

        public LocaledDateTimeParserBucketWrapper(DateTimeParserBucket bucket, Locale locale) {
            super(0L, null, null);
            this.myBucket = bucket;
            this.myLocale = locale;
            this.setZone(DateTimeUtils.getChronology(null).getZone());
        }

        public Chronology getChronology() {
            return this.myBucket.getChronology();
        }

        public Locale getLocale() {
            return this.myLocale;
        }

        public DateTimeZone getZone() {
            return this.myBucket.getZone();
        }

        public void setZone(DateTimeZone zone) {
            if (this.myBucket != null) {
                this.myBucket.setZone(zone);
            }
        }

        public int getOffset() {
            return this.myBucket.getOffset();
        }

        public void setOffset(int offset) {
            this.myBucket.setOffset(offset);
        }

        public Integer getPivotYear() {
            return this.myBucket.getPivotYear();
        }

        public void setPivotYear(Integer pivotYear) {
            this.myBucket.setPivotYear(pivotYear);
        }

        public void saveField(DateTimeField field, int value) {
            this.myBucket.saveField(field, value);
        }

        public void saveField(DateTimeFieldType fieldType, int value) {
            this.myBucket.saveField(fieldType, value);
        }

        public void saveField(DateTimeFieldType fieldType, String text, Locale locale) {
            this.myBucket.saveField(fieldType, text, locale);
        }

        public Object saveState() {
            return this.myBucket.saveState();
        }

        public boolean restoreState(Object savedState) {
            return this.myBucket.restoreState(savedState);
        }

        public long computeMillis() {
            return this.myBucket.computeMillis();
        }

        public long computeMillis(boolean resetFields) {
            return this.myBucket.computeMillis(resetFields);
        }

        public long computeMillis(boolean resetFields, String text) {
            return this.myBucket.computeMillis(resetFields, text);
        }
    }
}

