/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.gap.resource.pojo;

import com.fasterxml.jackson.databind.ser.BeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.PropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import java.util.Map;
import java.util.Stack;
import jetbrains.gap.resource.Entity;
import jetbrains.gap.resource.pojo.FilterNotFoundException;
import jetbrains.gap.resource.pojo.FilteringPropertyFilter;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001a\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u0011\u001a\u0004\u0018\u00010\u000eH\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u0014H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Ljetbrains/gap/resource/pojo/FilteringFilterProvider;", "Lcom/fasterxml/jackson/databind/ser/FilterProvider;", "root", "Ljetbrains/gap/resource/pojo/FilteringPropertyFilter;", "(Ljetbrains/gap/resource/pojo/FilteringPropertyFilter;)V", "getRoot", "()Ljetbrains/gap/resource/pojo/FilteringPropertyFilter;", "stack", "Ljava/util/Stack;", "getStack", "()Ljava/util/Stack;", "findFilter", "Lcom/fasterxml/jackson/databind/ser/BeanPropertyFilter;", "filterId", "", "findPropertyFilter", "Lcom/fasterxml/jackson/databind/ser/PropertyFilter;", "valueToFilter", "isRootFilterId", "", "", "Companion", "gap-rest"})
public final class FilteringFilterProvider
extends FilterProvider {
    @NotNull
    private final Stack<FilteringPropertyFilter> stack;
    @NotNull
    private final FilteringPropertyFilter root;
    private static final boolean failFast;
    @NotNull
    private static final SimpleBeanPropertyFilter nothing;
    public static final Companion Companion;

    @NotNull
    public final Stack<FilteringPropertyFilter> getStack() {
        return this.stack;
    }

    @NotNull
    public BeanPropertyFilter findFilter(@NotNull Object filterId) {
        Intrinsics.checkParameterIsNotNull((Object)filterId, (String)"filterId");
        throw (Throwable)new UnsupportedOperationException("Access to deprecated filters not supported");
    }

    @NotNull
    public PropertyFilter findPropertyFilter(@NotNull Object filterId, @Nullable Object valueToFilter) {
        Intrinsics.checkParameterIsNotNull((Object)filterId, (String)"filterId");
        if (filterId instanceof String) {
            if (this.isRootFilterId((String)filterId)) {
                this.stack.clear();
                return this.root;
            }
            if (valueToFilter instanceof Map) {
                Map map = (Map)valueToFilter;
                return new FilteringPropertyFilter(Map.class, map.keySet(), null, 4, null);
            }
            if (this.stack.isEmpty()) {
                throw (Throwable)new IllegalStateException();
            }
            FilteringPropertyFilter filteringPropertyFilter = this.stack.peek().findSubFilter((String)filterId);
            if (filteringPropertyFilter != null) {
                FilteringPropertyFilter filteringPropertyFilter2;
                FilteringPropertyFilter it = filteringPropertyFilter2 = filteringPropertyFilter;
                return it;
            }
            if (failFast) {
                throw (Throwable)new FilterNotFoundException("filter with id " + filterId + " for value " + valueToFilter + " was not found");
            }
        }
        return (PropertyFilter)nothing;
    }

    private final boolean isRootFilterId(String filterId) {
        Class<?> clazz = this.root.getEntityClass();
        if (clazz == null) {
            throw (Throwable)new IllegalStateException("Sub-graph not expected as root filter");
        }
        Class<?> rootClass = clazz;
        if (Intrinsics.areEqual((Object)filterId, (Object)rootClass.getName())) {
            return true;
        }
        if (Intrinsics.areEqual((Object)filterId, (Object)Entity.Companion.getClazz().getName())) {
            return Entity.Companion.getClazz().isAssignableFrom(rootClass);
        }
        if (StringsKt.contains$default((CharSequence)filterId, (CharSequence)".", (boolean)false, (int)2, null)) {
            try {
                return Class.forName(filterId).isAssignableFrom(rootClass);
            }
            catch (ClassNotFoundException cnfe) {
                return false;
            }
        }
        return false;
    }

    @NotNull
    public final FilteringPropertyFilter getRoot() {
        return this.root;
    }

    public FilteringFilterProvider(@NotNull FilteringPropertyFilter root) {
        Intrinsics.checkParameterIsNotNull((Object)root, (String)"root");
        this.root = root;
        this.stack = new Stack();
    }

    static {
        Companion = new Companion(null);
        failFast = Intrinsics.areEqual((Object)System.getProperty("jetbrains.gap.resource.filterProvider.failFast"), (Object)"false") ^ true;
        SimpleBeanPropertyFilter simpleBeanPropertyFilter = SimpleBeanPropertyFilter.filterOutAllExcept((String[])new String[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)simpleBeanPropertyFilter, (String)"SimpleBeanPropertyFilter.filterOutAllExcept()");
        nothing = simpleBeanPropertyFilter;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Ljetbrains/gap/resource/pojo/FilteringFilterProvider$Companion;", "", "()V", "failFast", "", "nothing", "Lcom/fasterxml/jackson/databind/ser/impl/SimpleBeanPropertyFilter;", "getNothing", "()Lcom/fasterxml/jackson/databind/ser/impl/SimpleBeanPropertyFilter;", "gap-rest"})
    public static final class Companion {
        @NotNull
        public final SimpleBeanPropertyFilter getNothing() {
            return nothing;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

