/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.gtext.runtime;

import java.util.regex.Pattern;

public class BaseHtmlStringUtil {
    private static final String EMPTY_STRING = "";
    private static final String BAD_SYMBOL_CHAR = "\u25a1";
    private static final String[] _charsToEntities;
    private static final String[] _charsToLiterals;
    private static final String _literalChars;
    private static final Pattern _newLine;
    private static final Pattern _doubleQuote;
    private static final DeprecatedSymbolsInterval[] _deprecatedIntervals;

    protected BaseHtmlStringUtil() {
    }

    public static String html(Object object) {
        if (object == null) {
            return EMPTY_STRING;
        }
        String str = object.toString();
        int capacity = str.length();
        StringBuilder builder = null;
        for (int i = 0; i < capacity; ++i) {
            char c = str.charAt(i);
            if (_charsToEntities[c] != null) {
                if (builder == null) {
                    builder = new StringBuilder(capacity + 100);
                    builder.append(str.substring(0, i));
                }
                builder.append(_charsToEntities[c]);
                continue;
            }
            if (builder == null) continue;
            builder.append(c);
        }
        if (builder != null) {
            return builder.toString();
        }
        return str;
    }

    public static String stringLiteral(Object object) {
        if (object == null) {
            return EMPTY_STRING;
        }
        String str = object.toString();
        int capacity = str.length();
        StringBuilder builder = null;
        for (int i = 0; i < capacity; ++i) {
            String literal;
            char c = str.charAt(i);
            String string = literal = c < _charsToLiterals.length ? _charsToLiterals[c] : null;
            if (literal != null) {
                if (builder == null) {
                    builder = new StringBuilder(capacity + 16);
                    builder.append(str.substring(0, i));
                }
                builder.append(literal);
                continue;
            }
            if (builder == null) continue;
            builder.append(c);
        }
        if (builder != null) {
            return builder.toString();
        }
        return str;
    }

    public static String singleLine(String string) {
        if (string == null) {
            return EMPTY_STRING;
        }
        return _newLine.matcher(string).replaceAll(" ");
    }

    public static String doubleToSingleQuotes(String string) {
        if (string == null) {
            return EMPTY_STRING;
        }
        return _doubleQuote.matcher(string).replaceAll("'");
    }

    public static String singleLineAnddoubleToSingleQuotes(String string) {
        return BaseHtmlStringUtil.doubleToSingleQuotes(BaseHtmlStringUtil.singleLine(string));
    }

    static {
        _newLine = Pattern.compile("\n");
        _doubleQuote = Pattern.compile("\"");
        _charsToEntities = new String[65536];
        for (DeprecatedSymbolsInterval deprecatedInterval : _deprecatedIntervals = new DeprecatedSymbolsInterval[]{new DeprecatedSymbolsInterval(0, 8), new DeprecatedSymbolsInterval(11, 12), new DeprecatedSymbolsInterval(14, 31), new DeprecatedSymbolsInterval(127, 132), new DeprecatedSymbolsInterval(134, 159), new DeprecatedSymbolsInterval(55296, 57343), new DeprecatedSymbolsInterval(64976, 64991), new DeprecatedSymbolsInterval(65534, 65535)}) {
            for (int i = deprecatedInterval.start; i <= deprecatedInterval.end; ++i) {
                BaseHtmlStringUtil._charsToEntities[i] = BAD_SYMBOL_CHAR;
            }
        }
        BaseHtmlStringUtil._charsToEntities[60] = "&lt;";
        BaseHtmlStringUtil._charsToEntities[62] = "&gt;";
        BaseHtmlStringUtil._charsToEntities[38] = "&amp;";
        BaseHtmlStringUtil._charsToEntities[34] = "&quot;";
        BaseHtmlStringUtil._charsToEntities[39] = "&#39;";
        _charsToLiterals = new String[128];
        BaseHtmlStringUtil._charsToLiterals[0] = " ";
        BaseHtmlStringUtil._charsToLiterals[92] = "\\\\";
        BaseHtmlStringUtil._charsToLiterals[34] = "\\\"";
        BaseHtmlStringUtil._charsToLiterals[39] = "\\'";
        BaseHtmlStringUtil._charsToLiterals[10] = "\\n";
        BaseHtmlStringUtil._charsToLiterals[13] = "\\r";
        BaseHtmlStringUtil._charsToLiterals[9] = "\\t";
        _literalChars = "\\\"'\n\r\t\u0000";
    }

    private static class DeprecatedSymbolsInterval {
        private final int start;
        private final int end;

        private DeprecatedSymbolsInterval(int start, int end) {
            this.start = start;
            this.end = end;
        }
    }
}

