/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.hub.auth;

import com.intellij.hub.auth.InvalidTokenException;
import com.intellij.hub.auth.oauth2.provider.source.DSAPublicKeySource;
import com.intellij.hub.auth.oauth2.token.AccessToken;
import java.security.Signature;
import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=2, d1={"\u0000\"\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a#\u0010\u0000\u001a\u00020\u00012\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006\u001a\n\u0010\u0007\u001a\u00020\u0001*\u00020\b\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0004\u001a\u0012\u0010\t\u001a\u00020\u0001*\u00020\b2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"verifyScope", "", "allowedScopes", "", "", "requiredScope", "([Ljava/lang/String;Ljava/lang/String;)V", "verifyExpiration", "Lcom/intellij/hub/auth/oauth2/token/AccessToken;", "verifySignature", "publicKeySource", "Lcom/intellij/hub/auth/oauth2/provider/source/DSAPublicKeySource;", "com.intellij.hub.auth"})
@JvmName(name="TokenVerification")
public final class TokenVerification {
    public static final void verifyExpiration(@NotNull AccessToken $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Date checkedAt = new Date();
        Date grantedTill = $receiver.getExpirationDate();
        if (grantedTill.before(checkedAt)) {
            throw (Throwable)InvalidTokenException.Companion.expired(checkedAt, grantedTill);
        }
    }

    public static final void verifySignature(@NotNull AccessToken $receiver, @NotNull DSAPublicKeySource publicKeySource) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)publicKeySource, (String)"publicKeySource");
        if ($receiver.getKeyVersion() > publicKeySource.getVersion()) {
            publicKeySource.forceUpdate();
        }
        try {
            Signature signature;
            Signature $receiver2 = signature = Signature.getInstance("SHA1withDSA");
            $receiver2.initVerify(publicKeySource.getKey());
            $receiver2.update($receiver.getData().getBytes());
            Signature sig = signature;
            if (!sig.verify($receiver.getSignature())) {
                throw (Throwable)InvalidTokenException.Companion.invalidTokenSignature();
            }
        }
        catch (Exception e) {
            throw (Throwable)InvalidTokenException.Companion.malformedTokenSignature(e);
        }
    }

    public static final void verifyScope(@NotNull AccessToken $receiver, @NotNull String requiredScope) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)requiredScope, (String)"requiredScope");
        TokenVerification.verifyScope($receiver.getScope(), requiredScope);
    }

    public static final void verifyScope(@NotNull String[] allowedScopes, @NotNull String requiredScope) {
        boolean bl;
        block2: {
            String[] $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)allowedScopes, (String)"allowedScopes");
            Intrinsics.checkParameterIsNotNull((Object)requiredScope, (String)"requiredScope");
            for (String element$iv : $receiver$iv = allowedScopes) {
                String it = element$iv;
                if (!Intrinsics.areEqual((Object)it, (Object)requiredScope)) continue;
                bl = false;
                break block2;
            }
            bl = true;
        }
        if (bl) {
            throw (Throwable)InvalidTokenException.Companion.invalidTokenScope(requiredScope, allowedScopes);
        }
    }
}

