/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.hub.auth.oauth2.error;

import com.intellij.hub.auth.oauth2.error.OAuthErrorCode;
import com.intellij.hub.core.Error;
import java.net.URI;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0013\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002B!\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0007\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018\u00a8\u0006\u0019"}, d2={"Lcom/intellij/hub/auth/oauth2/error/OAuthAuthErrorCode;", "", "Lcom/intellij/hub/auth/oauth2/error/OAuthErrorCode;", "statusCode", "", "asciiCode", "", "description", "(Ljava/lang/String;IILjava/lang/String;Ljava/lang/String;)V", "getAsciiCode", "()Ljava/lang/String;", "getDescription", "getStatusCode", "()I", "INVALID_REQUEST", "UNAUTHORIZED_CLIENT", "INVALID_REDIRECT_URI", "ACCESS_DENIED", "UNSUPPORTED_RESPONSE_TYPE", "INVALID_SCOPE", "SERVER_ERROR", "TEMPORARILY_UNAVAILABLE", "LOGIN_REQUIRED", "REQUEST_NOT_SUPPORTED", "REQUEST_URI_NOT_SUPPORTED", "com.intellij.hub.auth"})
public final class OAuthAuthErrorCode
extends Enum<OAuthAuthErrorCode>
implements OAuthErrorCode {
    public static final /* enum */ OAuthAuthErrorCode INVALID_REQUEST;
    public static final /* enum */ OAuthAuthErrorCode UNAUTHORIZED_CLIENT;
    public static final /* enum */ OAuthAuthErrorCode INVALID_REDIRECT_URI;
    public static final /* enum */ OAuthAuthErrorCode ACCESS_DENIED;
    public static final /* enum */ OAuthAuthErrorCode UNSUPPORTED_RESPONSE_TYPE;
    public static final /* enum */ OAuthAuthErrorCode INVALID_SCOPE;
    public static final /* enum */ OAuthAuthErrorCode SERVER_ERROR;
    public static final /* enum */ OAuthAuthErrorCode TEMPORARILY_UNAVAILABLE;
    public static final /* enum */ OAuthAuthErrorCode LOGIN_REQUIRED;
    public static final /* enum */ OAuthAuthErrorCode REQUEST_NOT_SUPPORTED;
    public static final /* enum */ OAuthAuthErrorCode REQUEST_URI_NOT_SUPPORTED;
    private static final /* synthetic */ OAuthAuthErrorCode[] $VALUES;
    private final int statusCode;
    @NotNull
    private final String asciiCode;
    @NotNull
    private final String description;

    static {
        OAuthAuthErrorCode[] oAuthAuthErrorCodeArray = new OAuthAuthErrorCode[11];
        OAuthAuthErrorCode[] oAuthAuthErrorCodeArray2 = oAuthAuthErrorCodeArray;
        oAuthAuthErrorCodeArray[0] = INVALID_REQUEST = new OAuthAuthErrorCode("INVALID_REQUEST", 0, 400, "invalid_request", null, 4, null);
        oAuthAuthErrorCodeArray[1] = UNAUTHORIZED_CLIENT = new OAuthAuthErrorCode(400, "unauthorized_client", "The client is not authorized to request an authorization entity using this method");
        oAuthAuthErrorCodeArray[2] = INVALID_REDIRECT_URI = new OAuthAuthErrorCode("INVALID_REDIRECT_URI", 2, 400, "invalid_redirect_uri", null, 4, null);
        oAuthAuthErrorCodeArray[3] = ACCESS_DENIED = new OAuthAuthErrorCode(403, "access_denied", "The resource owner or authorization server denied the request");
        oAuthAuthErrorCodeArray[4] = UNSUPPORTED_RESPONSE_TYPE = new OAuthAuthErrorCode(400, "unsupported_response_type", "The authorization server does not support obtaining an authorization entity using this method");
        oAuthAuthErrorCodeArray[5] = INVALID_SCOPE = new OAuthAuthErrorCode("INVALID_SCOPE", 5, 400, "invalid_scope", null, 4, null);
        oAuthAuthErrorCodeArray[6] = SERVER_ERROR = new OAuthAuthErrorCode(500, "server_error", "Internal server error");
        oAuthAuthErrorCodeArray[7] = TEMPORARILY_UNAVAILABLE = new OAuthAuthErrorCode("TEMPORARILY_UNAVAILABLE", 7, 503, "temporarily_unavailable", null, 4, null);
        oAuthAuthErrorCodeArray[8] = LOGIN_REQUIRED = new OAuthAuthErrorCode(403, "login_required", "The user is required to be logged in");
        oAuthAuthErrorCodeArray[9] = REQUEST_NOT_SUPPORTED = new OAuthAuthErrorCode(400, "request_not_supported", "The request parameter not supported");
        oAuthAuthErrorCodeArray[10] = REQUEST_URI_NOT_SUPPORTED = new OAuthAuthErrorCode(400, "request_uri_not_supported", "The request_uri parameter not supported");
        $VALUES = oAuthAuthErrorCodeArray;
    }

    @Override
    public int getStatusCode() {
        return this.statusCode;
    }

    @Override
    @NotNull
    public String getAsciiCode() {
        return this.asciiCode;
    }

    @Override
    @NotNull
    public String getDescription() {
        return this.description;
    }

    protected OAuthAuthErrorCode(@NotNull int statusCode, String asciiCode, String description) {
        Intrinsics.checkParameterIsNotNull((Object)asciiCode, (String)"asciiCode");
        Intrinsics.checkParameterIsNotNull((Object)description, (String)"description");
        this.statusCode = statusCode;
        this.asciiCode = asciiCode;
        this.description = description;
    }

    /* synthetic */ OAuthAuthErrorCode(String string, int n, int n2, String string2, String string3, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 4) != 0) {
            string3 = string2;
        }
        this(n2, string2, string3);
    }

    @Override
    @NotNull
    public Error createError(@Nullable String description, @Nullable String devDescription, @Nullable URI errorUri) {
        return OAuthErrorCode.DefaultImpls.createError(this, description, devDescription, errorUri);
    }

    public static OAuthAuthErrorCode[] values() {
        return (OAuthAuthErrorCode[])$VALUES.clone();
    }

    public static OAuthAuthErrorCode valueOf(String string) {
        return Enum.valueOf(OAuthAuthErrorCode.class, string);
    }
}

