/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.hub.core.data.uri;

import java.io.InputStream;
import javax.xml.bind.DatatypeConverter;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u000f\b\u0016\u0012\u0006\u0010\t\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\nR\u0011\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\t\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\r\u00a8\u0006\u0013"}, d2={"Lcom/intellij/hub/core/data/uri/DataURI;", "", "mimeType", "", "content", "", "(Ljava/lang/String;[B)V", "Ljava/io/InputStream;", "(Ljava/lang/String;Ljava/io/InputStream;)V", "dataURI", "(Ljava/lang/String;)V", "base64Content", "getBase64Content", "()Ljava/lang/String;", "getContent", "()[B", "getDataURI", "getMimeType", "Companion", "com.intellij.hub.core"})
public final class DataURI {
    @NotNull
    private final String mimeType;
    @NotNull
    private final String base64Content;
    @NotNull
    private static final Regex DATA_URI_PATTERN;
    public static final Companion Companion;

    @NotNull
    public final String getMimeType() {
        return this.mimeType;
    }

    @NotNull
    public final String getBase64Content() {
        return this.base64Content;
    }

    @NotNull
    public final String getDataURI() {
        return "data:" + this.mimeType + ";base64," + this.base64Content;
    }

    @NotNull
    public final byte[] getContent() {
        byte[] byArray = DatatypeConverter.parseBase64Binary((String)this.base64Content);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"DatatypeConverter.parseBase64Binary(base64Content)");
        return byArray;
    }

    public DataURI(@NotNull String mimeType, @NotNull byte[] content) {
        Intrinsics.checkParameterIsNotNull((Object)mimeType, (String)"mimeType");
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        this.mimeType = mimeType;
        String string = DatatypeConverter.printBase64Binary((byte[])content);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"DatatypeConverter.printBase64Binary(content)");
        this.base64Content = string;
    }

    public DataURI(@NotNull String mimeType, @NotNull InputStream content) {
        Intrinsics.checkParameterIsNotNull((Object)mimeType, (String)"mimeType");
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        this(mimeType, ByteStreamsKt.readBytes$default((InputStream)content, (int)0, (int)1, null));
    }

    /*
     * WARNING - void declaration
     */
    public DataURI(@NotNull String dataURI) {
        void mimeType;
        MatchResult.Destructured destructured;
        Intrinsics.checkParameterIsNotNull((Object)dataURI, (String)"dataURI");
        MatchResult matcher = DATA_URI_PATTERN.matchEntire((CharSequence)dataURI);
        if (matcher == null) {
            throw (Throwable)new IllegalArgumentException("Bad Data URI format: " + dataURI);
        }
        MatchResult.Destructured destructured2 = destructured = matcher.getDestructured();
        String string = (String)destructured2.getMatch().getGroupValues().get(1);
        destructured2 = destructured;
        String base64Content = (String)destructured2.getMatch().getGroupValues().get(2);
        this.mimeType = mimeType;
        this.base64Content = base64Content;
    }

    static {
        Companion = new Companion(null);
        DATA_URI_PATTERN = new Regex("data:(.+?);base64,(.+)", SetsKt.setOf((Object[])new RegexOption[]{RegexOption.IGNORE_CASE, RegexOption.DOT_MATCHES_ALL}));
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\nR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lcom/intellij/hub/core/data/uri/DataURI$Companion;", "", "()V", "DATA_URI_PATTERN", "Lkotlin/text/Regex;", "getDATA_URI_PATTERN", "()Lkotlin/text/Regex;", "parse", "Lcom/intellij/hub/core/data/uri/DataURI;", "dataUri", "", "com.intellij.hub.core"})
    public static final class Companion {
        @NotNull
        public final Regex getDATA_URI_PATTERN() {
            return DATA_URI_PATTERN;
        }

        @Nullable
        public final DataURI parse(@Nullable String dataUri) {
            DataURI dataURI;
            String string = dataUri;
            if (string != null) {
                DataURI dataURI2;
                String string2;
                String it = string2 = string;
                try {
                    dataURI2 = new DataURI(dataUri);
                }
                catch (IllegalArgumentException e) {
                    dataURI2 = null;
                }
                dataURI = dataURI2;
            } else {
                dataURI = null;
            }
            return dataURI;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

