/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.auth.module.rest.client.json;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import jetbrains.jetpass.auth.module.rest.client.api.AuthModuleGroupMapping;
import jetbrains.jetpass.auth.module.rest.client.api.ExternalAuthModule;
import jetbrains.jetpass.auth.module.rest.client.json.AuthModuleGroupMappingJSON;
import jetbrains.jetpass.rest.dto.UserCreationAuthModuleJSON;
import jetbrains.jetpass.rest.dto.utils.JsonUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="externalauthmodule")
@XmlAccessorType(value=XmlAccessType.FIELD)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type", defaultImpl=ExternalauthmoduleJSON.class)
public class ExternalauthmoduleJSON
extends UserCreationAuthModuleJSON
implements ExternalAuthModule {
    @XmlElement(name="serverUrl")
    private String serverUrl;
    @XmlElement(name="connectionTimeout")
    private Integer connectionTimeout;
    @XmlElement(name="readTimeout")
    private Integer readTimeout;
    @XmlElement(name="groupMappings")
    private List<AuthModuleGroupMappingJSON> groupMappings;

    public ExternalauthmoduleJSON() {
    }

    public ExternalauthmoduleJSON(@NotNull ExternalAuthModule that) {
        super(that);
        this.setServerUrl(that.getServerUrl());
        this.setConnectionTimeout(that.getConnectionTimeout());
        this.setReadTimeout(that.getReadTimeout());
        this.setAllowedCreateNewUsers(that.isAllowedCreateNewUsers());
        if (that.getGroupMappings() != null) {
            ArrayList<AuthModuleGroupMappingJSON> jsons = new ArrayList<AuthModuleGroupMappingJSON>();
            for (AuthModuleGroupMapping authModuleGroupMapping : that.getGroupMappings()) {
                jsons.add(AuthModuleGroupMappingJSON.wrap(authModuleGroupMapping));
            }
            this.setGroupMappings(jsons);
        }
    }

    @Override
    @Nullable
    public String getServerUrl() {
        return this.serverUrl;
    }

    @Override
    @Nullable
    public Integer getConnectionTimeout() {
        return this.connectionTimeout;
    }

    @Override
    @Nullable
    public Integer getReadTimeout() {
        return this.readTimeout;
    }

    public List<AuthModuleGroupMappingJSON> getGroupMappings() {
        return this.groupMappings;
    }

    @XmlTransient
    public void setServerUrl(@Nullable String serverUrl) {
        this.serverUrl = serverUrl;
    }

    @XmlTransient
    public void setConnectionTimeout(@Nullable Integer connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    @XmlTransient
    public void setReadTimeout(@Nullable Integer readTimeout) {
        this.readTimeout = readTimeout;
    }

    @XmlTransient
    public void setGroupMappings(@Nullable Iterable<AuthModuleGroupMappingJSON> groupMappings) {
        this.groupMappings = JsonUtils.iterableToList(groupMappings);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExternalAuthModule)) {
            return false;
        }
        ExternalAuthModule that = (ExternalAuthModule)o;
        return this.getId() != null && this.getId().equals(that.getId());
    }

    @Override
    public int hashCode() {
        if (this.getId() == null) {
            return System.identityHashCode(this);
        }
        int result = 0;
        result = result * 31 + this.getId().hashCode();
        return result;
    }

    @NotNull
    public static ExternalauthmoduleJSON wrap(@NotNull ExternalAuthModule that) {
        if (that instanceof ExternalauthmoduleJSON) {
            return (ExternalauthmoduleJSON)that;
        }
        return new ExternalauthmoduleJSON(that);
    }
}

