/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.client.resource;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Ticker;
import com.intellij.hub.auth.InvalidPermanentTokenException;
import com.intellij.hub.auth.oauth2.error.VerifyTokenErrorCode;
import com.intellij.hub.auth.oauth2.token.PermanentToken;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.Base64;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import jetbrains.jetpass.api.authority.auth.TokenInfo;
import jetbrains.jetpass.client.resource.PermanentTokenCache;
import jetbrains.jetpass.client.resource.TokenInfoProvider;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 \u001b2\u00020\u0001:\u0002\u001b\u001cB3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u0010\b\u0002\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u000eH\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000eH\u0016J\u0006\u0010\u001a\u001a\u00020\u000eR*\u0010\f\u001a\u001e\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u000e0\u000e\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u00100\u00100\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Ljetbrains/jetpass/client/resource/PermanentTokenCacheImpl;", "Ljetbrains/jetpass/client/resource/PermanentTokenCache;", "tokenInfoProvider", "Ljetbrains/jetpass/client/resource/TokenInfoProvider;", "config", "Ljetbrains/jetpass/client/resource/PermanentTokenCache$Config;", "ticker", "Ljava/util/function/Supplier;", "", "recordStats", "", "(Ljetbrains/jetpass/client/resource/TokenInfoProvider;Ljetbrains/jetpass/client/resource/PermanentTokenCache$Config;Ljava/util/function/Supplier;Z)V", "cache", "Lcom/github/benmanes/caffeine/cache/Cache;", "", "kotlin.jvm.PlatformType", "Ljetbrains/jetpass/client/resource/PermanentTokenCacheImpl$Item;", "getTokenInfo", "Ljetbrains/jetpass/api/authority/auth/TokenInfo;", "token", "Lcom/intellij/hub/auth/oauth2/token/PermanentToken;", "hash", "message", "invalidate", "", "tokenId", "printStats", "Companion", "Item", "jetbrains.jetpass.client.accounts"})
public final class PermanentTokenCacheImpl
implements PermanentTokenCache {
    private final Cache<String, Item> cache;
    private final TokenInfoProvider tokenInfoProvider;
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public TokenInfo getTokenInfo(@NotNull PermanentToken token) {
        Item item2;
        Intrinsics.checkParameterIsNotNull((Object)token, (String)"token");
        String secret = this.hash(token.getSecret());
        try {
            Object object = this.cache.get((Object)secret, (Function)new Function<String, Item>(this, token){
                final /* synthetic */ PermanentTokenCacheImpl this$0;
                final /* synthetic */ PermanentToken $token;

                @NotNull
                public final Item apply(String it) {
                    Item item2;
                    try {
                        item2 = new Item(PermanentTokenCacheImpl.access$getTokenInfoProvider$p(this.this$0).getTokenInfo(this.$token));
                    }
                    catch (InvalidPermanentTokenException ex) {
                        item2 = new Item(null);
                    }
                    return item2;
                }
                {
                    this.this$0 = permanentTokenCacheImpl;
                    this.$token = permanentToken;
                }
            });
            if (object == null) {
                Intrinsics.throwNpe();
            }
            item2 = (Item)object;
        }
        catch (ExecutionException ex) {
            Throwable throwable = ex.getCause();
            if (throwable == null) {
                throwable = ex;
            }
            throw throwable;
        }
        Item item3 = item2;
        TokenInfo tokenInfo = item3.getTokenInfo();
        if (tokenInfo == null) {
            throw (Throwable)new InvalidPermanentTokenException(VerifyTokenErrorCode.PERMANENT_TOKEN_INVALID, "Invalid authorization header: " + token.encode());
        }
        return tokenInfo;
    }

    @Override
    public void invalidate(@NotNull String tokenId) {
        Intrinsics.checkParameterIsNotNull((Object)tokenId, (String)"tokenId");
        ConcurrentMap concurrentMap = this.cache.asMap();
        Intrinsics.checkExpressionValueIsNotNull((Object)concurrentMap, (String)"cache.asMap()");
        Object $receiver$iv = concurrentMap;
        LinkedHashMap result$iv = new LinkedHashMap();
        Map map = $receiver$iv;
        for (Map.Entry entry$iv : map.entrySet()) {
            Item it = (Item)entry$iv.getValue();
            TokenInfo tokenInfo = it.getTokenInfo();
            if (!Intrinsics.areEqual((Object)(tokenInfo != null ? tokenInfo.getId() : null), (Object)tokenId)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        Set keys2 = ((Map)result$iv).keySet();
        $receiver$iv = keys2;
        Iterator iterator2 = $receiver$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv = iterator2.next();
            String it = (String)element$iv;
            this.cache.put((Object)it, (Object)new Item(null));
        }
    }

    @NotNull
    public final String printStats() {
        String string = this.cache.stats().toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"cache.stats().toString()");
        return string;
    }

    private final String hash(String message) {
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        String string = message;
        Charset charset = Charsets.UTF_8;
        MessageDigest messageDigest = digest;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = byArray;
        byte[] hash = messageDigest.digest(byArray2);
        String string3 = Base64.getEncoder().encodeToString(hash);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"Base64.getEncoder().encodeToString(hash)");
        return string3;
    }

    public PermanentTokenCacheImpl(@NotNull TokenInfoProvider tokenInfoProvider, @NotNull PermanentTokenCache.Config config, @Nullable Supplier<Long> ticker, boolean recordStats) {
        Intrinsics.checkParameterIsNotNull((Object)tokenInfoProvider, (String)"tokenInfoProvider");
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        this.tokenInfoProvider = tokenInfoProvider;
        Caffeine caffeine = Caffeine.newBuilder().expireAfterAccess(config.getTtlMinutes(), TimeUnit.MINUTES).maximumSize(config.getMaxSize());
        PermanentTokenCacheImpl permanentTokenCacheImpl = this;
        Caffeine $receiver = caffeine;
        if (recordStats) {
            $receiver.recordStats();
        }
        if (ticker != null) {
            $receiver.ticker(new Ticker(recordStats, ticker){
                final /* synthetic */ boolean $recordStats$inlined;
                final /* synthetic */ Supplier $ticker$inlined;
                {
                    this.$recordStats$inlined = bl;
                    this.$ticker$inlined = supplier;
                }

                @NotNull
                public final Long read() {
                    T t = this.$ticker$inlined.get();
                    Intrinsics.checkExpressionValueIsNotNull(t, (String)"ticker.get()");
                    return (Long)t;
                }
            });
        }
        Caffeine caffeine2 = caffeine;
        permanentTokenCacheImpl.cache = caffeine2.build();
    }

    public /* synthetic */ PermanentTokenCacheImpl(TokenInfoProvider tokenInfoProvider, PermanentTokenCache.Config config, Supplier supplier, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            config = new PermanentTokenCache.Config(0L, 0L, 3, null);
        }
        if ((n & 4) != 0) {
            supplier = null;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        this(tokenInfoProvider, config, supplier, bl);
    }

    @NotNull
    public static final /* synthetic */ TokenInfoProvider access$getTokenInfoProvider$p(PermanentTokenCacheImpl $this) {
        return $this.tokenInfoProvider;
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u000b\u0010\u0007\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0015\u0010\b\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Ljetbrains/jetpass/client/resource/PermanentTokenCacheImpl$Item;", "", "tokenInfo", "Ljetbrains/jetpass/api/authority/auth/TokenInfo;", "(Ljetbrains/jetpass/api/authority/auth/TokenInfo;)V", "getTokenInfo", "()Ljetbrains/jetpass/api/authority/auth/TokenInfo;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "jetbrains.jetpass.client.accounts"})
    private static final class Item {
        @Nullable
        private final TokenInfo tokenInfo;

        @Nullable
        public final TokenInfo getTokenInfo() {
            return this.tokenInfo;
        }

        public Item(@Nullable TokenInfo tokenInfo) {
            this.tokenInfo = tokenInfo;
        }

        @Nullable
        public final TokenInfo component1() {
            return this.tokenInfo;
        }

        @NotNull
        public final Item copy(@Nullable TokenInfo tokenInfo) {
            return new Item(tokenInfo);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ Item copy$default(Item item2, TokenInfo tokenInfo, int n, Object object) {
            if ((n & 1) != 0) {
                tokenInfo = item2.tokenInfo;
            }
            return item2.copy(tokenInfo);
        }

        public String toString() {
            return "Item(tokenInfo=" + this.tokenInfo + ")";
        }

        public int hashCode() {
            TokenInfo tokenInfo = this.tokenInfo;
            return tokenInfo != null ? tokenInfo.hashCode() : 0;
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Item)) break block3;
                    Item item2 = (Item)object;
                    if (!Intrinsics.areEqual((Object)this.tokenInfo, (Object)item2.tokenInfo)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/jetpass/client/resource/PermanentTokenCacheImpl$Companion;", "Lmu/KLogging;", "()V", "jetbrains.jetpass.client.accounts"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

