/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.dao.api.authority;

import java.util.List;
import jetbrains.jetpass.api.authority.EndUserAgreementConsent;
import jetbrains.jetpass.api.authority.Profile;
import jetbrains.jetpass.api.authority.SshPublicKey;
import jetbrains.jetpass.api.authority.User;
import jetbrains.jetpass.api.authority.auth.ApprovedScope;
import jetbrains.jetpass.api.authority.auth.PermanentToken;
import jetbrains.jetpass.api.authority.auth.RefreshToken;
import jetbrains.jetpass.api.authority.details.UserDetails;
import jetbrains.jetpass.api.authority.totp.ApplicationPassword;
import jetbrains.jetpass.api.security.Project;
import jetbrains.jetpass.api.settings.LicenseSettings;
import jetbrains.jetpass.dao.api.DataAccessException;
import jetbrains.jetpass.dao.api.MutableDAO;
import jetbrains.jetpass.dao.api.NamedDAO;
import jetbrains.jetpass.dao.api.authority.AuthorityHolderDAO;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface UserDAO
extends NamedDAO<User>,
MutableDAO<User>,
AuthorityHolderDAO<User> {
    public User getGuest();

    public UserDetails addUserDetails(String var1, UserDetails var2) throws DataAccessException;

    public void removeUserDetails(String var1, String var2) throws DataAccessException;

    public User invite(String var1, @Nullable String var2) throws DataAccessException;

    public User invite(String var1) throws DataAccessException;

    @NotNull
    default public User merge(@NotNull Iterable<User> users, @Nullable String login, @Nullable String name, @Nullable String email, @Nullable String jabber, @Nullable Boolean banned) throws DataAccessException {
        return this.merge(users, login, name, email, jabber, banned, null);
    }

    @NotNull
    public User merge(@NotNull Iterable<User> var1, @Nullable String var2, @Nullable String var3, @Nullable String var4, @Nullable String var5, @Nullable Boolean var6, @Nullable String var7) throws DataAccessException;

    public Profile verifyContact(String var1, Profile var2) throws DataAccessException;

    public SshPublicKey addSshPublicKey(String var1, SshPublicKey var2) throws DataAccessException;

    public void removeSshPublicKey(String var1, String var2) throws DataAccessException;

    public LicenseSettings addLicense(User var1, LicenseSettings var2) throws DataAccessException;

    public void removeLicense(User var1, LicenseSettings var2) throws DataAccessException;

    public void removeRefreshToken(@NotNull User var1, @NotNull RefreshToken var2) throws DataAccessException;

    public void removeApprovedScope(@NotNull User var1, @NotNull ApprovedScope var2) throws DataAccessException;

    @NotNull
    public PermanentToken addPermanentToken(@NotNull User var1, @NotNull PermanentToken var2) throws DataAccessException;

    public void removePermanentToken(@NotNull User var1, @NotNull PermanentToken var2) throws DataAccessException;

    public ApplicationPassword addApplicationPassword(@NotNull User var1, @NotNull ApplicationPassword var2) throws DataAccessException;

    public void removeApplicationPassword(@NotNull User var1, @NotNull ApplicationPassword var2) throws DataAccessException;

    public Project addFavoriteProject(@NotNull User var1, @NotNull Project var2) throws DataAccessException;

    public void removeFavoriteProject(@NotNull User var1, @NotNull Project var2) throws DataAccessException;

    @NotNull
    public EndUserAgreementConsent acceptEndUserAgreement() throws DataAccessException;

    public void revokeEndUserAgreementConsent() throws DataAccessException;

    public void removeUserLocale(@NotNull User var1);

    @NotNull
    public List<List<String>> getPersonalData(@NotNull User var1);

    @NotNull
    public User erasePersonalData(@NotNull User var1);
}

