/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.dao.api.permissionCache.uuid;

import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import jetbrains.jetpass.dao.api.permissionCache.uuid.BinaryHeap;
import jetbrains.jetpass.dao.api.permissionCache.uuid.UnionDistinctIterator;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010(\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0002\u0012\u0013B1\u0012\u0012\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00020\u0004\u0012\u0016\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00028\u00000\u0006j\b\u0012\u0004\u0012\u00028\u0000`\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000e\u001a\u00020\u000fH\u0096\u0002J\u000e\u0010\u0010\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u0011R!\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00028\u00000\u0006j\b\u0012\u0004\u0012\u00028\u0000`\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Ljetbrains/jetpass/dao/api/permissionCache/uuid/UnionDistinctIterator;", "T", "", "orderedIterator", "Lkotlin/sequences/Sequence;", "comparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "(Lkotlin/sequences/Sequence;Ljava/util/Comparator;)V", "getComparator", "()Ljava/util/Comparator;", "iteratorsQueue", "Ljetbrains/jetpass/dao/api/permissionCache/uuid/BinaryHeap;", "Ljetbrains/jetpass/dao/api/permissionCache/uuid/UnionDistinctIterator$Node;", "hasNext", "", "next", "()Ljava/lang/Object;", "Node", "NodeComparator", "jetbrains.jetpass.dao"})
public final class UnionDistinctIterator<T>
implements Iterator<T>,
KMappedMarker {
    private final BinaryHeap<Node<T>> iteratorsQueue;
    @NotNull
    private final Comparator<T> comparator;

    @Override
    public boolean hasNext() {
        return !this.iteratorsQueue.isEmpty();
    }

    @Override
    public T next() {
        if (this.iteratorsQueue.isEmpty()) {
            throw (Throwable)new NoSuchElementException();
        }
        T next = this.iteratorsQueue.min().getHead();
        while (!this.iteratorsQueue.isEmpty() && this.comparator.compare(this.iteratorsQueue.min().getHead(), next) == 0) {
            boolean hasMore;
            Node<T> node = this.iteratorsQueue.removeMin();
            while ((hasMore = node.shift()) && this.comparator.compare(node.getHead(), next) == 0) {
            }
            if (!hasMore) continue;
            this.iteratorsQueue.add(node);
        }
        return next;
    }

    @NotNull
    public final Comparator<T> getComparator() {
        return this.comparator;
    }

    /*
     * WARNING - void declaration
     */
    public UnionDistinctIterator(@NotNull Sequence<? extends Iterator<? extends T>> orderedIterator, @NotNull Comparator<T> comparator) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull(orderedIterator, (String)"orderedIterator");
        Intrinsics.checkParameterIsNotNull(comparator, (String)"comparator");
        this.comparator = comparator;
        BinaryHeap<Node> binaryHeap = new BinaryHeap<Node>(SequencesKt.count(orderedIterator), (Comparator)new NodeComparator<T>(this.comparator));
        UnionDistinctIterator unionDistinctIterator = this;
        BinaryHeap<Node> $receiver = binaryHeap;
        Sequence sequence = SequencesKt.mapNotNull(orderedIterator, (Function1)iteratorsQueue.1.1.INSTANCE);
        for (Object element$iv : $receiver$iv) {
            Node it = (Node)element$iv;
            $receiver.add(it);
        }
        BinaryHeap<Node> binaryHeap2 = binaryHeap;
        unionDistinctIterator.iteratorsQueue = binaryHeap2;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010(\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002B\u001b\u0012\u0006\u0010\u0003\u001a\u00028\u0001\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u000e\u001a\u00020\u000fR\u001c\u0010\u0003\u001a\u00028\u0001X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000b\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0010"}, d2={"Ljetbrains/jetpass/dao/api/permissionCache/uuid/UnionDistinctIterator$Node;", "T", "", "head", "orderedIterator", "", "(Ljava/lang/Object;Ljava/util/Iterator;)V", "getHead", "()Ljava/lang/Object;", "setHead", "(Ljava/lang/Object;)V", "Ljava/lang/Object;", "getOrderedIterator", "()Ljava/util/Iterator;", "shift", "", "jetbrains.jetpass.dao"})
    private static final class Node<T> {
        private T head;
        @NotNull
        private final Iterator<T> orderedIterator;

        public final boolean shift() {
            boolean bl;
            if (this.orderedIterator.hasNext()) {
                this.head = this.orderedIterator.next();
                bl = true;
            } else {
                bl = false;
            }
            return bl;
        }

        public final T getHead() {
            return this.head;
        }

        public final void setHead(T t) {
            this.head = t;
        }

        @NotNull
        public final Iterator<T> getOrderedIterator() {
            return this.orderedIterator;
        }

        public Node(T head, @NotNull Iterator<? extends T> orderedIterator) {
            Intrinsics.checkParameterIsNotNull(orderedIterator, (String)"orderedIterator");
            this.head = head;
            this.orderedIterator = orderedIterator;
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\b\u0002\u0018\u0000*\u0004\b\u0001\u0010\u00012\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00030\u0002j\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u0003`\u0004B\u001d\u0012\u0016\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00028\u00010\u0002j\b\u0012\u0004\u0012\u00028\u0001`\u0004\u00a2\u0006\u0002\u0010\u0006J(\u0010\t\u001a\u00020\n2\u000e\u0010\u000b\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u00032\u000e\u0010\f\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0003H\u0016R!\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00028\u00010\u0002j\b\u0012\u0004\u0012\u00028\u0001`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\r"}, d2={"Ljetbrains/jetpass/dao/api/permissionCache/uuid/UnionDistinctIterator$NodeComparator;", "T", "Ljava/util/Comparator;", "Ljetbrains/jetpass/dao/api/permissionCache/uuid/UnionDistinctIterator$Node;", "Lkotlin/Comparator;", "comparator", "(Ljava/util/Comparator;)V", "getComparator", "()Ljava/util/Comparator;", "compare", "", "o1", "o2", "jetbrains.jetpass.dao"})
    private static final class NodeComparator<T>
    implements Comparator<Node<T>> {
        @NotNull
        private final Comparator<T> comparator;

        @Override
        public int compare(@Nullable Node<T> o1, @Nullable Node<T> o2) {
            Node<T> node = o1;
            if (node == null) {
                throw (Throwable)new NullPointerException();
            }
            Node<T> n1 = node;
            Node<T> node2 = o2;
            if (node2 == null) {
                throw (Throwable)new NullPointerException();
            }
            Node<T> n2 = node2;
            return this.comparator.compare(n1.getHead(), n2.getHead());
        }

        @NotNull
        public final Comparator<T> getComparator() {
            return this.comparator;
        }

        public NodeComparator(@NotNull Comparator<T> comparator) {
            Intrinsics.checkParameterIsNotNull(comparator, (String)"comparator");
            this.comparator = comparator;
        }
    }
}

