/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.dao.api.widget;

import java.util.LinkedHashMap;
import java.util.Map;
import jetbrains.jetpass.dao.api.DataAccessException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WidgetException
extends DataAccessException {
    public static final String METADATA_EMPTY_FIELD_CODE = "widget-metadata-empty-field";
    public static final String FILE_NOT_FOUND_CODE = "widget-file-not-found";
    public static final String UNEXPECTED_MANIFEST_LOCATION_CODE = "widget-manifest-not-at-root";
    public static final String ARCHIVE_MALFORMED_CODE = "widget-archive-malformed";
    public static final String KEY_DOES_NOT_MATCH_CODE = "widget-key-does-not-match";
    public static final String METADATA_MALFORMED_CODE = "widget-metadata-malformed";
    public static final String DOWNLOAD_FAILED_CODE = "widget-download-failed";
    public static final String CAPABILITIES_WRONG_FORMAT_CODE = "widget-metadata-capabilities-wrong-format";
    public static final String REPOSITORY_FAILURE_CODE = "widget-repository-failure";
    public static final String REPOSITORY_ERROR_CODE = "widget-repository-error";
    public static final String FILE_SIZE_EXCEEDED_CODE = "widget-file-size-exceeded";
    public static final String ARCHIVE_SIZE_EXCEEDED_CODE = "widget-archive-size-exceeded";
    public static final String ARCHIVE_TOO_MANY_ENTRIES_CODE = "widget-archive-too-many-entries";

    private WidgetException(@NotNull String code, @NotNull String message, @Nullable Map<String, String> parameters, @NotNull DataAccessException.Severity severity) {
        super(message);
        this.setCode(code);
        this.setParameters(parameters);
        this.setSeverity(severity);
    }

    private WidgetException(@NotNull String code, @NotNull String message, @Nullable Map<String, String> parameters, @NotNull Throwable cause, @NotNull DataAccessException.Severity severity) {
        super(message, cause);
        this.setCode(code);
        this.setParameters(parameters);
        this.setSeverity(severity);
    }

    @NotNull
    public static WidgetException emptyMetadataFieldException(@NotNull String metadataFileName, @NotNull String fieldName) {
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>(2);
        parameters.put("file", metadataFileName);
        parameters.put("field", fieldName);
        return new WidgetException(METADATA_EMPTY_FIELD_CODE, "The " + fieldName + " field in the " + metadataFileName + " is empty", parameters, DataAccessException.Severity.INFO);
    }

    @NotNull
    public static WidgetException fileNotFound(@NotNull String fileName) {
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>(1);
        parameters.put("file", fileName);
        return new WidgetException(FILE_NOT_FOUND_CODE, "The archive package does not contain the required " + fileName + " file", parameters, DataAccessException.Severity.WARN);
    }

    @NotNull
    public static WidgetException manifestNotAtRoot(@NotNull String directory) {
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>(1);
        parameters.put("directory", directory);
        return new WidgetException(UNEXPECTED_MANIFEST_LOCATION_CODE, "The manifest.json file that was found in the " + directory + " folder must be stored in the top-most directory of the archive package", parameters, DataAccessException.Severity.INFO);
    }

    @NotNull
    public static WidgetException archiveIsMalformed(@NotNull Throwable cause) {
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>(1);
        parameters.put("cause", cause.getMessage());
        return new WidgetException(ARCHIVE_MALFORMED_CODE, "The archive package is formatted incorrectly: " + cause.getMessage(), parameters, cause, DataAccessException.Severity.INFO);
    }

    @NotNull
    public static WidgetException keyDoesNotMatch() {
        return new WidgetException(KEY_DOES_NOT_MATCH_CODE, "The key does not match the key from the previous version", null, DataAccessException.Severity.INFO);
    }

    @NotNull
    public static WidgetException metadataIsMalformed(@NotNull Throwable cause) {
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>(1);
        parameters.put("cause", cause.getMessage());
        return new WidgetException(METADATA_MALFORMED_CODE, "The manifest.json file is formatted incorrectly: " + cause.getMessage(), parameters, cause, DataAccessException.Severity.INFO);
    }

    @NotNull
    public static WidgetException downloadFailed() {
        return new WidgetException(DOWNLOAD_FAILED_CODE, "Widget download failed", null, DataAccessException.Severity.INFO);
    }

    @NotNull
    public static WidgetException capabilitiesWrongFormat() {
        return new WidgetException(CAPABILITIES_WRONG_FORMAT_CODE, "The capabilities attribute in the manifest.json file is formatted incorrectly", null, DataAccessException.Severity.INFO);
    }

    @NotNull
    public static WidgetException repositoryFailed(@NotNull Exception cause) {
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>(1);
        parameters.put("cause", cause.getMessage());
        return new WidgetException(REPOSITORY_FAILURE_CODE, "Failed to retrieve widget list from repository", parameters, cause, DataAccessException.Severity.WARN);
    }

    @NotNull
    public static WidgetException repositoryError(@NotNull String message) {
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>(1);
        parameters.put("reason", message);
        return new WidgetException(REPOSITORY_ERROR_CODE, "Cannot retrieve widgets from repository. " + message, parameters, DataAccessException.Severity.WARN);
    }

    @NotNull
    public static WidgetException archiveSizeExceeded(@NotNull Long maxSize) {
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>(1);
        parameters.put("maxSize", maxSize.toString());
        return new WidgetException(ARCHIVE_SIZE_EXCEEDED_CODE, "The widget archive is too large. The maximum archive size is " + maxSize + " Mb", parameters, DataAccessException.Severity.INFO);
    }

    @NotNull
    public static WidgetException archiveContentSizeExceeded(@NotNull String fileName, @NotNull Long maxSize) {
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>(2);
        parameters.put("fileName", fileName);
        parameters.put("maxSize", maxSize.toString());
        return new WidgetException(FILE_SIZE_EXCEEDED_CODE, "The " + fileName + " file in the widget archive is too large. The maximum file size is " + maxSize + " Mb", parameters, DataAccessException.Severity.INFO);
    }

    @NotNull
    public static WidgetException archiveFileNumberExceeded(@NotNull Integer maxNumber) {
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>(1);
        parameters.put("maxNumber", maxNumber.toString());
        return new WidgetException(ARCHIVE_TOO_MANY_ENTRIES_CODE, "The widget archive contains too many files. The maximum number of files is " + maxNumber, parameters, DataAccessException.Severity.INFO);
    }
}

