/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.dao.util;

import jetbrains.jetpass.dao.util.AbstractPersistentHashSet;
import jetbrains.jetpass.dao.util.PersistentHashSet;

public class PersistentHashMap<K, V> {
    private final PersistentHashSet<Entry<K, V>> set;

    public PersistentHashMap() {
        this.set = new PersistentHashSet();
    }

    private PersistentHashMap(AbstractPersistentHashSet.RootTableNode<Entry<K, V>> root) {
        this.set = new PersistentHashSet<Entry<Entry<K, V>, V>>(root);
    }

    public ImmutablePersistentHashMap getCurrent() {
        return new ImmutablePersistentHashMap();
    }

    public PersistentHashMap<K, V> getClone() {
        return new PersistentHashMap<K, V>(this.set.getRoot());
    }

    public MutablePersistentHashMap beginWrite() {
        return new MutablePersistentHashMap();
    }

    public boolean endWrite(MutablePersistentHashMap tree) {
        return this.set.endWrite(tree);
    }

    public static class Entry<K, V> {
        private final K key;
        private final V value;

        private Entry(K key) {
            this(key, null);
        }

        private Entry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        public boolean equals(Object obj) {
            return this.key.equals(((Entry)obj).key);
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        public K getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }
    }

    public class MutablePersistentHashMap
    extends PersistentHashSet.MutablePersistentHashSet<Entry<K, V>> {
        MutablePersistentHashMap() {
            super(PersistentHashMap.this.set);
        }

        public V get(K key) {
            Entry entry = this.getRoot().getKey(new Entry(key), key.hashCode(), 0);
            return entry == null ? null : (Object)entry.getValue();
        }

        public boolean containsKey(K key) {
            return this.getRoot().getKey(new Entry(key), key.hashCode(), 0) != null;
        }

        public void put(K key, V value) {
            this.add(new Entry(key, value));
        }

        public V removeKey(K key) {
            Object result;
            Entry entry = this.getRoot().getKey(new Entry(key), key.hashCode(), 0);
            Object v = result = entry == null ? null : (Object)entry.getValue();
            if (entry != null) {
                this.remove(entry);
            }
            return result;
        }
    }

    public class ImmutablePersistentHashMap
    extends PersistentHashSet.ImmutablePersistentHashSet<Entry<K, V>> {
        ImmutablePersistentHashMap() {
            super(PersistentHashMap.this.set.getRoot());
        }

        public V get(K key) {
            Entry entry = this.getRoot().getKey(new Entry(key), key.hashCode(), 0);
            return entry == null ? null : (Object)entry.getValue();
        }

        public boolean containsKey(K key) {
            return this.getRoot().getKey(new Entry(key), key.hashCode(), 0) != null;
        }
    }
}

