/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.rest.dto;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import jetbrains.jetpass.api.Service;
import jetbrains.jetpass.api.authority.auth.ApprovedScope;
import jetbrains.jetpass.rest.dto.AuthorityHolderJSON;
import jetbrains.jetpass.rest.dto.ServiceJSON;
import jetbrains.jetpass.rest.dto.UserJSON;
import jetbrains.jetpass.rest.dto.utils.JsonUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="approvedScope")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ApprovedScopeJSON
implements ApprovedScope {
    @XmlElement(name="id")
    private String id;
    @XmlElement(name="client")
    private ServiceJSON client;
    @XmlElement(name="scope")
    private List<ServiceJSON> scope;
    @XmlElement(name="user")
    private UserJSON user;
    @XmlElement(name="expiresOn")
    private Calendar expiresOn;

    public ApprovedScopeJSON() {
    }

    public ApprovedScopeJSON(@NotNull ApprovedScope that) {
        AuthorityHolderJSON ref;
        this.setId(that.getId());
        if (that.getClient() != null) {
            ref = new ServiceJSON();
            ref.setId(that.getClient().getId());
            this.setClient((ServiceJSON)ref);
        }
        if (that.getScope() != null) {
            ArrayList<ServiceJSON> references = new ArrayList<ServiceJSON>();
            for (Service service2 : that.getScope()) {
                ServiceJSON ref2 = new ServiceJSON();
                ref2.setId(service2.getId());
                references.add(ref2);
            }
            this.setScope(references);
        }
        if (that.getUser() != null) {
            ref = new UserJSON();
            ref.setId(that.getUser().getId());
            this.setUser((UserJSON)ref);
        }
        this.setExpiresOn(that.getExpiresOn());
    }

    @Override
    @Nullable
    public String getId() {
        return this.id;
    }

    @Override
    @Nullable
    public ServiceJSON getClient() {
        return this.client;
    }

    @Nullable
    public Iterable<ServiceJSON> getScope() {
        return this.scope;
    }

    @Override
    @Nullable
    public UserJSON getUser() {
        return this.user;
    }

    @Override
    @Nullable
    public Calendar getExpiresOn() {
        return this.expiresOn;
    }

    @XmlTransient
    public void setId(@Nullable String id) {
        this.id = id;
    }

    @XmlTransient
    public void setClient(@Nullable ServiceJSON client) {
        this.client = client;
    }

    @XmlTransient
    public void setScope(@Nullable Iterable<ServiceJSON> scope2) {
        this.scope = JsonUtils.iterableToList(scope2);
    }

    @XmlTransient
    public void setUser(@Nullable UserJSON user) {
        this.user = user;
    }

    @XmlTransient
    public void setExpiresOn(@Nullable Calendar expiresOn) {
        this.expiresOn = expiresOn;
    }

    @NotNull
    public static ApprovedScopeJSON wrap(@NotNull ApprovedScope that) {
        if (that instanceof ApprovedScopeJSON) {
            return (ApprovedScopeJSON)that;
        }
        return new ApprovedScopeJSON(that);
    }
}

