/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.rest.dto;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import jetbrains.jetpass.api.Alias;
import jetbrains.jetpass.api.authority.UserGroup;
import jetbrains.jetpass.api.authority.module.AuthModule;
import jetbrains.jetpass.rest.dto.AliasJSON;
import jetbrains.jetpass.rest.dto.UserGroupJSON;
import jetbrains.jetpass.rest.dto.utils.JsonUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="authmodule")
@XmlAccessorType(value=XmlAccessType.FIELD)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type", defaultImpl=AuthmoduleJSON.class)
public class AuthmoduleJSON
implements AuthModule {
    @XmlElement(name="id")
    private String id;
    @XmlElement(name="aliasIds")
    private List<String> aliasIds;
    @XmlElement(name="aliases")
    private List<AliasJSON> aliases;
    @XmlElement(name="name")
    private String name;
    @XmlElement(name="ordinal")
    private Integer ordinal;
    @XmlElement(name="accountsSize")
    private Integer accountsSize;
    @XmlElement(name="disabled")
    private Boolean disabled;
    @XmlElement(name="autoJoinGroups")
    private List<UserGroupJSON> autoJoinGroups;

    public AuthmoduleJSON() {
    }

    public AuthmoduleJSON(@NotNull AuthModule that) {
        this.setId(that.getId());
        this.setAliasIds(that.getAliasIds());
        if (that.getAliases() != null) {
            ArrayList<AliasJSON> aggregated = new ArrayList<AliasJSON>();
            for (Alias alias : that.getAliases()) {
                aggregated.add(new AliasJSON(alias));
            }
            this.setAliases(aggregated);
        }
        this.setName(that.getName());
        this.setOrdinal(that.getOrdinal());
        this.setAccountsSize(that.getAccountsSize());
        this.setDisabled(that.isDisabled());
        if (that.getAutoJoinGroups() != null) {
            ArrayList<UserGroupJSON> references = new ArrayList<UserGroupJSON>();
            for (UserGroup userGroup : that.getAutoJoinGroups()) {
                UserGroupJSON ref = new UserGroupJSON();
                ref.setId(userGroup.getId());
                references.add(ref);
            }
            this.setAutoJoinGroups(references);
        }
    }

    @Override
    @Nullable
    public String getId() {
        return this.id;
    }

    @Override
    @Nullable
    public Iterable<String> getAliasIds() {
        return this.aliasIds;
    }

    @Nullable
    public Iterable<AliasJSON> getAliases() {
        return this.aliases;
    }

    @Override
    @Nullable
    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public Integer getOrdinal() {
        return this.ordinal;
    }

    @Override
    @Nullable
    public Integer getAccountsSize() {
        return this.accountsSize;
    }

    @Override
    @Nullable
    public Boolean isDisabled() {
        return this.disabled;
    }

    @Nullable
    public Iterable<UserGroupJSON> getAutoJoinGroups() {
        return this.autoJoinGroups;
    }

    @XmlTransient
    public void setId(@Nullable String id) {
        this.id = id;
    }

    @XmlTransient
    public void setAliasIds(@Nullable Iterable<String> aliasIds) {
        this.aliasIds = JsonUtils.iterableToList(aliasIds);
    }

    @XmlTransient
    public void setAliases(@Nullable Iterable<AliasJSON> aliases) {
        this.aliases = JsonUtils.iterableToList(aliases);
    }

    @XmlTransient
    public void setName(@Nullable String name) {
        this.name = name;
    }

    @XmlTransient
    public void setOrdinal(@Nullable Integer ordinal) {
        this.ordinal = ordinal;
    }

    @XmlTransient
    public void setAccountsSize(@Nullable Integer accountsSize) {
        this.accountsSize = accountsSize;
    }

    @XmlTransient
    public void setDisabled(@Nullable Boolean disabled) {
        this.disabled = disabled;
    }

    @XmlTransient
    public void setAutoJoinGroups(@Nullable Iterable<UserGroupJSON> autoJoinGroups) {
        this.autoJoinGroups = JsonUtils.iterableToList(autoJoinGroups);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AuthModule)) {
            return false;
        }
        AuthModule that = (AuthModule)o;
        return this.getId() != null && this.getId().equals(that.getId());
    }

    public int hashCode() {
        if (this.getId() == null) {
            return System.identityHashCode(this);
        }
        int result = 0;
        result = result * 31 + this.getId().hashCode();
        return result;
    }

    @NotNull
    public static AuthmoduleJSON wrap(@NotNull AuthModule that) {
        if (that instanceof AuthmoduleJSON) {
            return (AuthmoduleJSON)that;
        }
        return new AuthmoduleJSON(that);
    }
}

