/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.rest.dto;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import jetbrains.jetpass.api.Alias;
import jetbrains.jetpass.api.event.Change;
import jetbrains.jetpass.api.event.Event;
import jetbrains.jetpass.rest.dto.AliasJSON;
import jetbrains.jetpass.rest.dto.ChangeJSON;
import jetbrains.jetpass.rest.dto.utils.JsonUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="event")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class EventJSON
implements Event {
    @XmlElement(name="id")
    private String id;
    @XmlElement(name="aliasIds")
    private List<String> aliasIds;
    @XmlElement(name="aliases")
    private List<AliasJSON> aliases;
    @XmlElement(name="targetId")
    private String targetId;
    @XmlElement(name="targetType")
    private String targetType;
    @XmlElement(name="targetPresentation")
    private String targetPresentation;
    @XmlElement(name="author")
    private String author;
    @XmlElement(name="authorPresentation")
    private String authorPresentation;
    @XmlElement(name="authorType")
    private String authorType;
    @XmlElement(name="changes")
    private List<ChangeJSON> changes;
    @XmlElement(name="type")
    private String type;
    @XmlElement(name="timestamp")
    private Calendar timestamp;
    @XmlElement(name="eraseTimestamp")
    private Calendar eraseTimestamp;

    public EventJSON() {
    }

    public EventJSON(@NotNull Event that) {
        ArrayList<AliasJSON> aggregated;
        this.setId(that.getId());
        this.setAliasIds(that.getAliasIds());
        if (that.getAliases() != null) {
            aggregated = new ArrayList<AliasJSON>();
            for (Alias alias : that.getAliases()) {
                aggregated.add(new AliasJSON(alias));
            }
            this.setAliases(aggregated);
        }
        this.setTargetId(that.getTargetId());
        this.setTargetType(that.getTargetType());
        this.setTargetPresentation(that.getTargetPresentation());
        this.setAuthor(that.getAuthor());
        this.setAuthorPresentation(that.getAuthorPresentation());
        this.setAuthorType(that.getAuthorType());
        if (that.getChanges() != null) {
            aggregated = new ArrayList();
            for (Change change : that.getChanges()) {
                aggregated.add((AliasJSON)((Object)new ChangeJSON(change)));
            }
            this.setChanges(aggregated);
        }
        this.setType(that.getType());
        this.setTimestamp(that.getTimestamp());
        this.setEraseTimestamp(that.getEraseTimestamp());
    }

    @Override
    @Nullable
    public String getId() {
        return this.id;
    }

    @Override
    @Nullable
    public Iterable<String> getAliasIds() {
        return this.aliasIds;
    }

    @Nullable
    public Iterable<AliasJSON> getAliases() {
        return this.aliases;
    }

    @Override
    @Nullable
    public String getTargetId() {
        return this.targetId;
    }

    @Override
    @Nullable
    public String getTargetType() {
        return this.targetType;
    }

    @Override
    @Nullable
    public String getTargetPresentation() {
        return this.targetPresentation;
    }

    @Override
    @Nullable
    public String getAuthor() {
        return this.author;
    }

    @Override
    @Nullable
    public String getAuthorPresentation() {
        return this.authorPresentation;
    }

    @Override
    @Nullable
    public String getAuthorType() {
        return this.authorType;
    }

    @Nullable
    public Iterable<ChangeJSON> getChanges() {
        return this.changes;
    }

    @Override
    @Nullable
    public String getType() {
        return this.type;
    }

    @Override
    @Nullable
    public Calendar getTimestamp() {
        return this.timestamp;
    }

    @Override
    @Nullable
    public Calendar getEraseTimestamp() {
        return this.eraseTimestamp;
    }

    @XmlTransient
    public void setId(@Nullable String id) {
        this.id = id;
    }

    @XmlTransient
    public void setAliasIds(@Nullable Iterable<String> aliasIds) {
        this.aliasIds = JsonUtils.iterableToList(aliasIds);
    }

    @XmlTransient
    public void setAliases(@Nullable Iterable<AliasJSON> aliases) {
        this.aliases = JsonUtils.iterableToList(aliases);
    }

    @XmlTransient
    public void setTargetId(@Nullable String targetId) {
        this.targetId = targetId;
    }

    @XmlTransient
    public void setTargetType(@Nullable String targetType) {
        this.targetType = targetType;
    }

    @XmlTransient
    public void setTargetPresentation(@Nullable String targetPresentation) {
        this.targetPresentation = targetPresentation;
    }

    @XmlTransient
    public void setAuthor(@Nullable String author) {
        this.author = author;
    }

    @XmlTransient
    public void setAuthorPresentation(@Nullable String authorPresentation) {
        this.authorPresentation = authorPresentation;
    }

    @XmlTransient
    public void setAuthorType(@Nullable String authorType) {
        this.authorType = authorType;
    }

    @XmlTransient
    public void setChanges(@Nullable Iterable<ChangeJSON> changes) {
        this.changes = JsonUtils.iterableToList(changes);
    }

    @XmlTransient
    public void setType(@Nullable String type) {
        this.type = type;
    }

    @XmlTransient
    public void setTimestamp(@Nullable Calendar timestamp) {
        this.timestamp = timestamp;
    }

    @XmlTransient
    public void setEraseTimestamp(@Nullable Calendar timestamp) {
        this.eraseTimestamp = timestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Event)) {
            return false;
        }
        Event that = (Event)o;
        return this.getId() != null && this.getId().equals(that.getId());
    }

    public int hashCode() {
        if (this.getId() == null) {
            return System.identityHashCode(this);
        }
        int result = 0;
        result = result * 31 + this.getId().hashCode();
        return result;
    }

    @NotNull
    public static EventJSON wrap(@NotNull Event that) {
        if (that instanceof EventJSON) {
            return (EventJSON)that;
        }
        return new EventJSON(that);
    }
}

