/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.rest.dto;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.ArrayList;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import jetbrains.jetpass.api.Alias;
import jetbrains.jetpass.api.feature.HubFeature;
import jetbrains.jetpass.rest.dto.AliasJSON;
import jetbrains.jetpass.rest.dto.UuidJSON;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="hubFeature")
@XmlAccessorType(value=XmlAccessType.FIELD)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type", defaultImpl=HubFeatureJSON.class)
public class HubFeatureJSON
extends UuidJSON
implements HubFeature {
    @XmlElement(name="key")
    private String key;
    @XmlElement(name="name")
    private String name;
    @XmlElement(name="description")
    private String description;
    @XmlElement(name="restartRequired")
    private Boolean restartRequired;
    @XmlElement(name="enabled")
    private Boolean enabled;

    public HubFeatureJSON() {
    }

    public HubFeatureJSON(@NotNull HubFeature that) {
        this.setId(that.getId());
        this.setAliasIds(that.getAliasIds());
        if (that.getAliases() != null) {
            ArrayList<AliasJSON> aggregated = new ArrayList<AliasJSON>();
            for (Alias alias : that.getAliases()) {
                aggregated.add(new AliasJSON(alias));
            }
            this.setAliases(aggregated);
        }
        this.setKey(that.getKey());
        this.setName(that.getName());
        this.setDescription(that.getDescription());
        this.setRestartRequired(that.isRestartRequired());
        this.setEnabled(that.isEnabled());
    }

    @Override
    @Nullable
    public String getKey() {
        return this.key;
    }

    @Override
    @Nullable
    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Override
    @Nullable
    public Boolean isRestartRequired() {
        return this.restartRequired;
    }

    @Override
    @Nullable
    public Boolean isEnabled() {
        return this.enabled;
    }

    @XmlTransient
    public void setKey(@Nullable String key) {
        this.key = key;
    }

    @XmlTransient
    public void setName(@Nullable String name) {
        this.name = name;
    }

    @XmlTransient
    public void setDescription(@Nullable String description) {
        this.description = description;
    }

    @XmlTransient
    public void setRestartRequired(@Nullable Boolean restartRequired) {
        this.restartRequired = restartRequired;
    }

    @XmlTransient
    public void setEnabled(@Nullable Boolean enabled2) {
        this.enabled = enabled2;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HubFeature)) {
            return false;
        }
        HubFeature that = (HubFeature)o;
        return this.getId() != null && this.getId().equals(that.getId());
    }

    @Override
    public int hashCode() {
        if (this.getId() == null) {
            return System.identityHashCode(this);
        }
        int result = 0;
        result = result * 31 + this.getId().hashCode();
        return result;
    }

    @NotNull
    public static HubFeatureJSON wrap(@NotNull HubFeature that) {
        if (that instanceof HubFeatureJSON) {
            return (HubFeatureJSON)that;
        }
        return new HubFeatureJSON(that);
    }
}

