/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.rest.dto;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import jetbrains.jetpass.api.Alias;
import jetbrains.jetpass.api.ssl.CertificateInfo;
import jetbrains.jetpass.api.ssl.KeyStore;
import jetbrains.jetpass.rest.dto.AliasJSON;
import jetbrains.jetpass.rest.dto.CertificateInfoJSON;
import jetbrains.jetpass.rest.dto.KeyStoreDataJSON;
import jetbrains.jetpass.rest.dto.utils.JsonUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="keyStore")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class KeyStoreJSON
implements KeyStore {
    @XmlElement(name="id")
    private String id;
    @XmlElement(name="aliasIds")
    private List<String> aliasIds;
    @XmlElement(name="aliases")
    private List<AliasJSON> aliases;
    @XmlElement(name="name")
    private String name;
    @XmlElement(name="data")
    private KeyStoreDataJSON data;
    @XmlElement(name="certificates")
    private List<CertificateInfoJSON> certificates;
    @XmlElement(name="certificate")
    private CertificateInfoJSON certificate;
    @XmlElement(name="certificateData")
    private String certificateData;

    public KeyStoreJSON() {
    }

    public KeyStoreJSON(@NotNull KeyStore that) {
        ArrayList<AliasJSON> aggregated;
        this.setId(that.getId());
        this.setAliasIds(that.getAliasIds());
        if (that.getAliases() != null) {
            aggregated = new ArrayList<AliasJSON>();
            for (Alias alias : that.getAliases()) {
                aggregated.add(new AliasJSON(alias));
            }
            this.setAliases(aggregated);
        }
        this.setName(that.getName());
        if (that.getData() != null) {
            this.setData(new KeyStoreDataJSON(that.getData()));
        }
        if (that.getCertificates() != null) {
            aggregated = new ArrayList();
            for (CertificateInfo certificateInfo : that.getCertificates()) {
                aggregated.add((AliasJSON)((Object)new CertificateInfoJSON(certificateInfo)));
            }
            this.setCertificates(aggregated);
        }
        if (that.getCertificate() != null) {
            this.setCertificate(new CertificateInfoJSON(that.getCertificate()));
        }
        if (that.getCertificateData() != null) {
            this.setCertificateData(that.getCertificateData());
        }
    }

    @Override
    @Nullable
    public String getId() {
        return this.id;
    }

    @Override
    @Nullable
    public Iterable<String> getAliasIds() {
        return this.aliasIds;
    }

    @Nullable
    public Iterable<AliasJSON> getAliases() {
        return this.aliases;
    }

    @Override
    @Nullable
    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public KeyStoreDataJSON getData() {
        return this.data;
    }

    @Nullable
    public Iterable<CertificateInfoJSON> getCertificates() {
        return this.certificates;
    }

    @Override
    @Nullable
    public CertificateInfoJSON getCertificate() {
        return this.certificate;
    }

    @Override
    public String getCertificateData() {
        return this.certificateData;
    }

    @XmlTransient
    public void setId(@Nullable String id) {
        this.id = id;
    }

    @XmlTransient
    public void setAliasIds(@Nullable Iterable<String> aliasIds) {
        this.aliasIds = JsonUtils.iterableToList(aliasIds);
    }

    @XmlTransient
    public void setAliases(@Nullable Iterable<AliasJSON> aliases) {
        this.aliases = JsonUtils.iterableToList(aliases);
    }

    @XmlTransient
    public void setName(@Nullable String name) {
        this.name = name;
    }

    @XmlTransient
    public void setData(@Nullable KeyStoreDataJSON data) {
        this.data = data;
    }

    @XmlTransient
    public void setCertificates(@Nullable Iterable<CertificateInfoJSON> certificates) {
        this.certificates = JsonUtils.iterableToList(certificates);
    }

    @XmlTransient
    public void setCertificate(@Nullable CertificateInfoJSON certificate) {
        this.certificate = certificate;
    }

    @XmlTransient
    public void setCertificateData(String certificateData) {
        this.certificateData = certificateData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof KeyStore)) {
            return false;
        }
        KeyStore that = (KeyStore)o;
        return this.getId() != null && this.getId().equals(that.getId());
    }

    public int hashCode() {
        if (this.getId() == null) {
            return System.identityHashCode(this);
        }
        int result = 0;
        result = result * 31 + this.getId().hashCode();
        return result;
    }

    @NotNull
    public static KeyStoreJSON wrap(@NotNull KeyStore that) {
        if (that instanceof KeyStoreJSON) {
            return (KeyStoreJSON)that;
        }
        return new KeyStoreJSON(that);
    }
}

