/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.rest.dto;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import jetbrains.jetpass.api.Alias;
import jetbrains.jetpass.api.security.Permission;
import jetbrains.jetpass.rest.dto.AliasJSON;
import jetbrains.jetpass.rest.dto.ServiceJSON;
import jetbrains.jetpass.rest.dto.utils.JsonUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="permission")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class PermissionJSON
implements Permission {
    @XmlElement(name="id")
    private String id;
    @XmlElement(name="aliasIds")
    private List<String> aliasIds;
    @XmlElement(name="aliases")
    private List<AliasJSON> aliases;
    @XmlElement(name="key")
    private String key;
    @XmlElement(name="name")
    private String name;
    @XmlElement(name="service")
    private ServiceJSON service;
    @XmlElement(name="description")
    private String description;
    @XmlElement(name="global")
    private Boolean global;
    @XmlElement(name="entityType")
    private String entityType;
    @XmlElement(name="operation")
    private String operation;
    @XmlElement(name="impliedPermissions")
    private List<PermissionJSON> impliedPermissions;

    public PermissionJSON() {
    }

    public PermissionJSON(@NotNull Permission that) {
        this.setId(that.getId());
        this.setAliasIds(that.getAliasIds());
        if (that.getAliases() != null) {
            ArrayList<AliasJSON> aggregated = new ArrayList<AliasJSON>();
            for (Alias alias : that.getAliases()) {
                aggregated.add(new AliasJSON(alias));
            }
            this.setAliases(aggregated);
        }
        this.setKey(that.getKey());
        this.setName(that.getName());
        if (that.getService() != null) {
            ServiceJSON ref = new ServiceJSON();
            ref.setId(that.getService().getId());
            this.setService(ref);
        }
        this.setDescription(that.getDescription());
        this.setGlobal(that.isGlobal());
        this.setEntityType(that.getEntityType());
        this.setOperation(that.getOperation());
        if (that.getImpliedPermissions() != null) {
            ArrayList<PermissionJSON> implied = new ArrayList<PermissionJSON>();
            for (Permission permission : that.getImpliedPermissions()) {
                implied.add(new PermissionJSON(permission));
            }
            this.setImpliedPermissions(implied);
        }
    }

    @Override
    @Nullable
    public String getId() {
        return this.id;
    }

    @Override
    @Nullable
    public Iterable<String> getAliasIds() {
        return this.aliasIds;
    }

    @Nullable
    public Iterable<AliasJSON> getAliases() {
        return this.aliases;
    }

    @Override
    @Nullable
    public String getKey() {
        return this.key;
    }

    @Override
    @Nullable
    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public ServiceJSON getService() {
        return this.service;
    }

    @Override
    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Override
    @Nullable
    public Boolean isGlobal() {
        return this.global;
    }

    @Override
    @Nullable
    public String getEntityType() {
        return this.entityType;
    }

    @Override
    @Nullable
    public String getOperation() {
        return this.operation;
    }

    public Iterable<PermissionJSON> getImpliedPermissions() {
        return this.impliedPermissions;
    }

    @XmlTransient
    public void setId(@Nullable String id) {
        this.id = id;
    }

    @XmlTransient
    public void setAliasIds(@Nullable Iterable<String> aliasIds) {
        this.aliasIds = JsonUtils.iterableToList(aliasIds);
    }

    @XmlTransient
    public void setAliases(@Nullable Iterable<AliasJSON> aliases) {
        this.aliases = JsonUtils.iterableToList(aliases);
    }

    @XmlTransient
    public void setKey(@Nullable String key) {
        this.key = key;
    }

    @XmlTransient
    public void setName(@Nullable String name) {
        this.name = name;
    }

    @XmlTransient
    public void setService(@Nullable ServiceJSON service2) {
        this.service = service2;
    }

    @XmlTransient
    public void setDescription(@Nullable String description) {
        this.description = description;
    }

    @XmlTransient
    public void setGlobal(@Nullable Boolean global) {
        this.global = global;
    }

    @XmlTransient
    public void setEntityType(@Nullable String entityType) {
        this.entityType = entityType;
    }

    @XmlTransient
    public void setOperation(@Nullable String operation) {
        this.operation = operation;
    }

    @XmlTransient
    public void setImpliedPermissions(@Nullable Iterable<PermissionJSON> impliedPermissions) {
        this.impliedPermissions = JsonUtils.iterableToList(impliedPermissions);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Permission)) {
            return false;
        }
        Permission that = (Permission)o;
        return this.getId() != null && this.getId().equals(that.getId());
    }

    public int hashCode() {
        if (this.getId() == null) {
            return System.identityHashCode(this);
        }
        int result = 0;
        result = result * 31 + this.getId().hashCode();
        return result;
    }

    @NotNull
    public static PermissionJSON wrap(@NotNull Permission that) {
        if (that instanceof PermissionJSON) {
            return (PermissionJSON)that;
        }
        return new PermissionJSON(that);
    }
}

