/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.pnm;

import com.twelvemonkeys.util.StringTokenIterator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;

final class Plain16BitDecoder
extends InputStream {
    private final BufferedReader reader;
    private StringTokenIterator currentLine;
    private int leftOver = -1;

    public Plain16BitDecoder(InputStream inputStream) {
        this.reader = new BufferedReader(new InputStreamReader(inputStream, Charset.forName("ASCII")));
    }

    @Override
    public int read() throws IOException {
        if (this.leftOver != -1) {
            int n = this.leftOver;
            this.leftOver = -1;
            return n;
        }
        if (this.currentLine == null || !this.currentLine.hasNext()) {
            String string = this.reader.readLine();
            if (string == null) {
                return -1;
            }
            this.currentLine = new StringTokenIterator(string);
            if (!this.currentLine.hasNext()) {
                return -1;
            }
        }
        int n = Integer.parseInt(this.currentLine.next()) & 0xFFFF;
        this.leftOver = n & 0xFF;
        return n >> 8 & 0xFF;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }
}

