/*
 * Decompiled with CFR 0.152.
 */
package com.offbytwo.jenkins.client;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import com.google.common.io.ByteStreams;
import com.offbytwo.jenkins.client.JenkinsHttpConnection;
import com.offbytwo.jenkins.client.PreemptiveAuth;
import com.offbytwo.jenkins.client.util.EncodingUtils;
import com.offbytwo.jenkins.client.util.RequestReleasingInputStream;
import com.offbytwo.jenkins.client.util.ResponseUtils;
import com.offbytwo.jenkins.client.util.UrlUtils;
import com.offbytwo.jenkins.client.validator.HttpResponseValidator;
import com.offbytwo.jenkins.model.BaseModel;
import com.offbytwo.jenkins.model.Crumb;
import com.offbytwo.jenkins.model.ExtractHeader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONObject;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JenkinsHttpClient
implements JenkinsHttpConnection {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private URI uri;
    private CloseableHttpClient client;
    private HttpContext localContext;
    private HttpResponseValidator httpResponseValidator;
    private ObjectMapper mapper;
    private String context;
    private String jenkinsVersion;
    public static final String EMPTY_VERSION = "UNKNOWN";

    public JenkinsHttpClient(URI uri, CloseableHttpClient client) {
        this.context = uri.getPath();
        if (!this.context.endsWith("/")) {
            this.context = this.context + "/";
        }
        this.uri = uri;
        this.mapper = this.getDefaultMapper();
        this.client = client;
        this.httpResponseValidator = new HttpResponseValidator();
        this.jenkinsVersion = EMPTY_VERSION;
        this.LOGGER.debug("uri={}", (Object)uri.toString());
    }

    public JenkinsHttpClient(URI uri, HttpClientBuilder builder) {
        this(uri, builder.build());
    }

    public JenkinsHttpClient(URI uri) {
        this(uri, HttpClientBuilder.create());
    }

    public JenkinsHttpClient(URI uri, String username, String password) {
        this(uri, HttpClientBuilder.create(), username, password);
    }

    public JenkinsHttpClient(URI uri, HttpClientBuilder builder, String username, String password) {
        this(uri, JenkinsHttpClient.addAuthentication(builder, uri, username, password));
        if (StringUtils.isNotBlank((String)username)) {
            this.localContext = new BasicHttpContext();
            this.localContext.setAttribute("preemptive-auth", (Object)new BasicScheme());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends BaseModel> T get(String path, Class<T> cls) throws IOException {
        HttpGet getMethod = new HttpGet(UrlUtils.toJsonApiUri(this.uri, this.context, path));
        CloseableHttpResponse response = this.client.execute((HttpUriRequest)getMethod, this.localContext);
        this.jenkinsVersion = ResponseUtils.getJenkinsVersion((HttpResponse)response);
        try {
            this.httpResponseValidator.validateResponse((HttpResponse)response);
            T t = this.objectFromResponse(cls, (HttpResponse)response);
            return t;
        }
        finally {
            EntityUtils.consume((HttpEntity)response.getEntity());
            this.releaseConnection((HttpRequestBase)getMethod);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String get(String path) throws IOException {
        HttpGet getMethod = new HttpGet(UrlUtils.toJsonApiUri(this.uri, this.context, path));
        CloseableHttpResponse response = this.client.execute((HttpUriRequest)getMethod, this.localContext);
        this.jenkinsVersion = ResponseUtils.getJenkinsVersion((HttpResponse)response);
        this.LOGGER.debug("get({}), version={}, responseCode={}", new Object[]{path, this.jenkinsVersion, response.getStatusLine().getStatusCode()});
        try {
            this.httpResponseValidator.validateResponse((HttpResponse)response);
            String string = IOUtils.toString((InputStream)response.getEntity().getContent());
            return string;
        }
        finally {
            EntityUtils.consume((HttpEntity)response.getEntity());
            this.releaseConnection((HttpRequestBase)getMethod);
        }
    }

    @Override
    public <T extends BaseModel> T getQuietly(String path, Class<T> cls) {
        try {
            T value = this.get(path, cls);
            return value;
        }
        catch (IOException e) {
            this.LOGGER.debug("getQuietly({}, {})", new Object[]{path, cls.getName(), e});
            return null;
        }
    }

    @Override
    public InputStream getFile(URI path) throws IOException {
        HttpGet getMethod = new HttpGet(path);
        CloseableHttpResponse response = this.client.execute((HttpUriRequest)getMethod, this.localContext);
        this.jenkinsVersion = ResponseUtils.getJenkinsVersion((HttpResponse)response);
        this.httpResponseValidator.validateResponse((HttpResponse)response);
        return new RequestReleasingInputStream(response.getEntity().getContent(), (HttpRequestBase)getMethod);
    }

    @Override
    public <R extends BaseModel, D> R post(String path, D data, Class<R> cls) throws IOException {
        return this.post(path, data, cls, null, true);
    }

    @Override
    public <R extends BaseModel, D> R post(String path, D data, Class<R> cls, boolean crumbFlag) throws IOException {
        return this.post(path, data, cls, null, crumbFlag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R extends BaseModel, D> R post(String path, D data, Class<R> cls, Map<String, File> fileParams, boolean crumbFlag) throws IOException {
        Crumb crumb;
        HttpPost request = new HttpPost(UrlUtils.toJsonApiUri(this.uri, this.context, path));
        if (crumbFlag && (crumb = this.getQuietly("/crumbIssuer", Crumb.class)) != null) {
            request.addHeader((Header)new BasicHeader(crumb.getCrumbRequestField(), crumb.getCrumb()));
        }
        if (data != null) {
            String value = this.mapper.writeValueAsString(data);
            StringEntity stringEntity = new StringEntity(value, ContentType.APPLICATION_JSON);
            request.setEntity((HttpEntity)stringEntity);
        }
        if (fileParams != null && !fileParams.isEmpty()) {
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
            for (Map.Entry r : fileParams.entrySet()) {
                FileBody fileBody = new FileBody((File)r.getValue());
                builder.addPart((String)r.getKey(), (ContentBody)fileBody);
            }
            HttpEntity entity = builder.build();
            request.setEntity(entity);
        }
        CloseableHttpResponse response = this.client.execute((HttpUriRequest)request, this.localContext);
        this.jenkinsVersion = ResponseUtils.getJenkinsVersion((HttpResponse)response);
        try {
            this.httpResponseValidator.validateResponse((HttpResponse)response);
            if (cls != null) {
                Object responseObject;
                if (cls.equals(ExtractHeader.class)) {
                    ExtractHeader extractHeader = new ExtractHeader();
                    extractHeader.setLocation(response.getFirstHeader("Location").getValue());
                    responseObject = extractHeader;
                } else {
                    responseObject = this.objectFromResponse(cls, (HttpResponse)response);
                }
                R r = responseObject;
                return r;
            }
            R r = null;
            return r;
        }
        finally {
            EntityUtils.consume((HttpEntity)response.getEntity());
            this.releaseConnection((HttpRequestBase)request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void post_form(String path, Map<String, String> data, boolean crumbFlag) throws IOException {
        Crumb crumb;
        HttpPost request;
        if (data != null) {
            ArrayList queryParams = Lists.newArrayList();
            for (String param : data.keySet()) {
                queryParams.add(param + "=" + EncodingUtils.encodeParam(data.get(param)));
            }
            queryParams.add("json=" + EncodingUtils.encodeParam(JSONObject.fromObject(data).toString()));
            String value = this.mapper.writeValueAsString(data);
            StringEntity stringEntity = new StringEntity(value, ContentType.APPLICATION_FORM_URLENCODED);
            request = new HttpPost(UrlUtils.toNoApiUri(this.uri, this.context, path) + StringUtils.join((Collection)queryParams, (String)"&"));
            request.setEntity((HttpEntity)stringEntity);
        } else {
            request = new HttpPost(UrlUtils.toNoApiUri(this.uri, this.context, path));
        }
        if (crumbFlag && (crumb = this.get("/crumbIssuer", Crumb.class)) != null) {
            request.addHeader((Header)new BasicHeader(crumb.getCrumbRequestField(), crumb.getCrumb()));
        }
        CloseableHttpResponse response = this.client.execute((HttpUriRequest)request, this.localContext);
        this.jenkinsVersion = ResponseUtils.getJenkinsVersion((HttpResponse)response);
        try {
            this.httpResponseValidator.validateResponse((HttpResponse)response);
        }
        finally {
            EntityUtils.consume((HttpEntity)response.getEntity());
            this.releaseConnection((HttpRequestBase)request);
        }
    }

    @Override
    public HttpResponse post_form_with_result(String path, List<NameValuePair> data, boolean crumbFlag) throws IOException {
        Crumb crumb;
        HttpPost request;
        if (data != null) {
            UrlEncodedFormEntity urlEncodedFormEntity = new UrlEncodedFormEntity(data);
            request = new HttpPost(UrlUtils.toNoApiUri(this.uri, this.context, path));
            request.setEntity((HttpEntity)urlEncodedFormEntity);
        } else {
            request = new HttpPost(UrlUtils.toNoApiUri(this.uri, this.context, path));
        }
        if (crumbFlag && (crumb = this.get("/crumbIssuer", Crumb.class)) != null) {
            request.addHeader((Header)new BasicHeader(crumb.getCrumbRequestField(), crumb.getCrumb()));
        }
        CloseableHttpResponse response = this.client.execute((HttpUriRequest)request, this.localContext);
        this.jenkinsVersion = ResponseUtils.getJenkinsVersion((HttpResponse)response);
        return response;
    }

    @Override
    public String post_xml(String path, String xml_data) throws IOException {
        return this.post_xml(path, xml_data, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String post_xml(String path, String xml_data, boolean crumbFlag) throws IOException {
        Crumb crumb;
        HttpPost request = new HttpPost(UrlUtils.toJsonApiUri(this.uri, this.context, path));
        if (crumbFlag && (crumb = this.getQuietly("/crumbIssuer", Crumb.class)) != null) {
            request.addHeader((Header)new BasicHeader(crumb.getCrumbRequestField(), crumb.getCrumb()));
        }
        if (xml_data != null) {
            request.setEntity((HttpEntity)new StringEntity(xml_data, ContentType.create((String)"text/xml", (String)"utf-8")));
        }
        CloseableHttpResponse response = this.client.execute((HttpUriRequest)request, this.localContext);
        this.jenkinsVersion = ResponseUtils.getJenkinsVersion((HttpResponse)response);
        try {
            this.httpResponseValidator.validateResponse((HttpResponse)response);
            String string = IOUtils.toString((InputStream)response.getEntity().getContent());
            return string;
        }
        finally {
            EntityUtils.consume((HttpEntity)response.getEntity());
            this.releaseConnection((HttpRequestBase)request);
        }
    }

    @Override
    public String post_text(String path, String textData, boolean crumbFlag) throws IOException {
        return this.post_text(path, textData, ContentType.DEFAULT_TEXT, crumbFlag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String post_text(String path, String textData, ContentType contentType, boolean crumbFlag) throws IOException {
        Crumb crumb;
        HttpPost request = new HttpPost(UrlUtils.toJsonApiUri(this.uri, this.context, path));
        if (crumbFlag && (crumb = this.get("/crumbIssuer", Crumb.class)) != null) {
            request.addHeader((Header)new BasicHeader(crumb.getCrumbRequestField(), crumb.getCrumb()));
        }
        if (textData != null) {
            request.setEntity((HttpEntity)new StringEntity(textData, contentType));
        }
        CloseableHttpResponse response = this.client.execute((HttpUriRequest)request, this.localContext);
        this.jenkinsVersion = ResponseUtils.getJenkinsVersion((HttpResponse)response);
        try {
            this.httpResponseValidator.validateResponse((HttpResponse)response);
            String string = IOUtils.toString((InputStream)response.getEntity().getContent());
            return string;
        }
        finally {
            EntityUtils.consume((HttpEntity)response.getEntity());
            this.releaseConnection((HttpRequestBase)request);
        }
    }

    @Override
    public void post(String path) throws IOException {
        this.post(path, null, null, null, false);
    }

    @Override
    public void post(String path, boolean crumbFlag) throws IOException {
        this.post(path, null, null, null, crumbFlag);
    }

    @Override
    public String getJenkinsVersion() {
        return this.jenkinsVersion;
    }

    @Override
    public boolean isJenkinsVersionSet() {
        return !EMPTY_VERSION.equals(this.jenkinsVersion);
    }

    @Override
    public void close() {
        try {
            this.client.close();
        }
        catch (IOException ex) {
            this.LOGGER.debug("I/O exception closing client", (Throwable)ex);
        }
    }

    protected static HttpClientBuilder addAuthentication(HttpClientBuilder builder, URI uri, String username, String password) {
        if (StringUtils.isNotBlank((String)username)) {
            BasicCredentialsProvider provider = new BasicCredentialsProvider();
            AuthScope scope = new AuthScope(uri.getHost(), uri.getPort(), "realm");
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(username, password);
            provider.setCredentials(scope, (Credentials)credentials);
            builder.setDefaultCredentialsProvider((CredentialsProvider)provider);
            builder.addInterceptorFirst((HttpRequestInterceptor)new PreemptiveAuth());
        }
        return builder;
    }

    protected HttpContext getLocalContext() {
        return this.localContext;
    }

    protected void setLocalContext(HttpContext localContext) {
        this.localContext = localContext;
    }

    private <T extends BaseModel> T objectFromResponse(Class<T> cls, HttpResponse response) throws IOException {
        InputStream content = response.getEntity().getContent();
        byte[] bytes = ByteStreams.toByteArray((InputStream)content);
        BaseModel result = (BaseModel)this.mapper.readValue(bytes, cls);
        result.setClient(this);
        return (T)result;
    }

    private ObjectMapper getDefaultMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        return mapper;
    }

    private void releaseConnection(HttpRequestBase httpRequestBase) {
        httpRequestBase.releaseConnection();
    }
}

