/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.internationalization.dates.runtime;

import java.io.IOException;
import java.io.Writer;
import java.util.Locale;
import jetbrains.mps.internationalization.runtime.Localizer;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import org.joda.time.Chronology;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeParser;
import org.joda.time.format.DateTimeParserBucket;
import org.joda.time.format.DateTimePrinter;

public class LocalizedLiteralDateTime
implements DateTimePrinter,
DateTimeParser {
    private String localizationId;

    public LocalizedLiteralDateTime(String localizationId) {
        this.localizationId = localizationId;
    }

    public int estimatePrintedLength() {
        return 100;
    }

    public void printTo(StringBuffer buffer, long l, Chronology chronology, int i, DateTimeZone zone, Locale locale) {
        buffer.append(this.getLocalizedPresentation(locale));
    }

    public void printTo(Writer writer, long l, Chronology chronology, int i, DateTimeZone zone, Locale locale) throws IOException {
        writer.write(this.getLocalizedPresentation(locale));
    }

    public void printTo(StringBuffer buffer, ReadablePartial partial, Locale locale) {
        buffer.append(this.getLocalizedPresentation(locale));
    }

    public void printTo(Writer writer, ReadablePartial partial, Locale locale) throws IOException {
        writer.write(this.getLocalizedPresentation(locale));
    }

    private String getLocalizedPresentation(Locale locale) {
        return ((Localizer)ServiceLocator.getBean((String)"localizer")).getMsgInLocale(this.localizationId, locale, new Object[0]);
    }

    public int parseInto(DateTimeParserBucket bucket, String text, int position) {
        String localizedPresentation = this.getLocalizedPresentation(bucket.getLocale());
        if (text.regionMatches(true, position, localizedPresentation, 0, localizedPresentation.length())) {
            return position + localizedPresentation.length();
        }
        return ~position;
    }

    public int estimateParsedLength() {
        return 100;
    }
}

