Webr.component.BindedComboBoxHighlighter = function (combo, message) {
  if (combo.shown) {
    Webr.component.BindedComboBoxHighlighter.superclass.constructor.call(this, combo.comboComponent, message);
  } else {
    this.elementHighlighter = new Webr.component.ElementHighlighter(combo.bindedToElement, message);
  }

};
{
  var F = new Function();
  F.prototype = Webr.component.BaseComboboxHighlighter.prototype;
  Webr.component.BindedComboBoxHighlighter.prototype = new F();
  Webr.component.BindedComboBoxHighlighter.prototype.constructor = Webr.component.BindedComboBoxHighlighter;
  Webr.component.BindedComboBoxHighlighter.superclass = Webr.component.BaseComboboxHighlighter.prototype;
}

Webr.component.BindedComboBoxHighlighter.prototype.create = function () {
  if (this.elementHighlighter) {
    this.elementHighlighter.create();
  } else {
    Webr.component.BindedComboBoxHighlighter.superclass.create.call(this);
  }

};
Webr.component.BindedComboBoxHighlighter.prototype.destroy = function () {
  if (this.elementHighlighter) {
    this.elementHighlighter.destroy();
    delete this.elementHighlighter;
  } else {
    Webr.component.BindedComboBoxHighlighter.superclass.destroy.call(this);
  }

};
Webr.component.ElementHighlighter = function (el, message) {
  this.element = el;
  this.message = message;
  var self = this;
  this.dismissHandler = function () {
    self.destroy();
  };
};
Webr.component.ElementHighlighter.prototype.create = function () {
  $(this.element).addClass(Webr.component.ElementHighlighter.HIGHLIGHT_STYLE);
  this.registerInputEvents();
};
Webr.component.ElementHighlighter.prototype.destroy = function () {
  $(this.element).removeClass(Webr.component.ElementHighlighter.HIGHLIGHT_STYLE);
  this.unregisterInputEvents();
};
Webr.component.ElementHighlighter.prototype.registerInputEvents = function () {
  $(this.element).one("keydown click", this.dismissHandler);
};
Webr.component.ElementHighlighter.prototype.unregisterInputEvents = function () {
  var eventTarget = $(this.element);
  eventTarget.unbind("keydown click", this.dismissHandler);
};
Webr.component.ElementHighlighter.HIGHLIGHT_STYLE = "combo-has-error";
