Webr.component.Layouter = function (config) {
  this.config = config;
};
Webr.component.Layouter.prototype.fix = function (width, height) {
};
Webr.component.Layouter.prototype.reset = function () {
};
Webr.component.Layouter.UP = {};
Webr.component.Layouter.DOWN = {};
Webr.component.Layouter.LEFT = {};
Webr.component.Layouter.RIGHT = {};
Webr.component.LayouterConfig = function () {
};
Webr.component.LayouterConfig.prototype.move = function (direction, maxHeight, preffered) {
};
Webr.component.LayouterConfig.prototype.reset = function () {
};
Webr.component.Direction = function () {
};
Webr.component.FullLayouter = function (config) {
  Webr.component.FullLayouter.superclass.constructor.call(this, config);
  this.verticalLayouter = new Webr.component.VerticalLayouter(config);
  this.horizontalLayouter = new Webr.component.HorizontalLayouter(config);
};
{
  var F = new Function();
  F.prototype = Webr.component.Layouter.prototype;
  Webr.component.FullLayouter.prototype = new F();
  Webr.component.FullLayouter.prototype.constructor = Webr.component.FullLayouter;
  Webr.component.FullLayouter.superclass = Webr.component.Layouter.prototype;
}

Webr.component.FullLayouter.prototype.fix = function (width, height) {
  this.verticalLayouter.fix(width, height);
  this.horizontalLayouter.fix(width, height);
};
Webr.component.FullLayouter.prototype.reset = function () {
  this.verticalLayouter.reset();
  this.horizontalLayouter.reset();
};
Webr.component.HorizontalLayouter = function (config) {
  this.current_state = null;
  Webr.component.HorizontalLayouter.superclass.constructor.call(this, config);
  this.current_state = Webr.component.HorizontalLayouter.state_INITIAL;
};
{
  var F = new Function();
  F.prototype = Webr.component.Layouter.prototype;
  Webr.component.HorizontalLayouter.prototype = new F();
  Webr.component.HorizontalLayouter.prototype.constructor = Webr.component.HorizontalLayouter;
  Webr.component.HorizontalLayouter.superclass = Webr.component.Layouter.prototype;
}

Webr.component.HorizontalLayouter.prototype.checkHorizontalOrientation = function (width) {
  var anchor = this.config.anchor;
  if ($(window).width() < (anchor.offset().left + width)) {
    this.toleft();
  } else {
    this.toright();
  }

};
Webr.component.HorizontalLayouter.prototype._reset = function () {
  this.config.reset();
};
Webr.component.HorizontalLayouter.prototype.toleft = function () {
  Webr.stateMachine.stateMachineRuntime.handleEvent(this, "toleft", arguments);
};
Webr.component.HorizontalLayouter.prototype.toright = function () {
  Webr.stateMachine.stateMachineRuntime.handleEvent(this, "toright", arguments);
};
Webr.component.HorizontalLayouter.prototype.reset = function () {
  Webr.stateMachine.stateMachineRuntime.handleEvent(this, "reset", arguments);
};
Webr.component.HorizontalLayouter.prototype.fix = function (width, height) {
  Webr.stateMachine.stateMachineRuntime.handleEvent(this, "fix", arguments);
};
Webr.component.HorizontalLayouter.state_INITIAL = {name: "INITIAL", fix: function (width, height) {
  if (true) {
    this.checkHorizontalOrientation(width);
    return ;
  }

  return false;
}, toleft: function () {
  if (true) {
    this.config.move(Webr.component.Layouter.LEFT, null);
    return Webr.component.HorizontalLayouter.state_OPEN_LEFT;
  }

  return false;
}, toright: function () {
  if (true) {
    this.config.move(Webr.component.Layouter.RIGHT, null);
    return Webr.component.HorizontalLayouter.state_OPEN_RIGHT;
  }

  return false;
}};
Webr.component.HorizontalLayouter.state_OPEN_LEFT = {name: "OPEN_LEFT", reset: function () {
  if (true) {
    this._reset();
    return Webr.component.HorizontalLayouter.state_INITIAL;
  }

  return false;
}};
Webr.component.HorizontalLayouter.state_OPEN_RIGHT = {name: "OPEN_RIGHT", reset: function () {
  if (true) {
    this._reset();
    return Webr.component.HorizontalLayouter.state_INITIAL;
  }

  return false;
}};
Webr.component.VerticalLayouter = function (config) {
  this.current_state = null;
  Webr.component.VerticalLayouter.superclass.constructor.call(this, config);
  this.current_state = Webr.component.VerticalLayouter.state_INITIAL;
};
{
  var F = new Function();
  F.prototype = Webr.component.Layouter.prototype;
  Webr.component.VerticalLayouter.prototype = new F();
  Webr.component.VerticalLayouter.prototype.constructor = Webr.component.VerticalLayouter;
  Webr.component.VerticalLayouter.superclass = Webr.component.Layouter.prototype;
}

Webr.component.VerticalLayouter.prototype._reset = function () {
  this.config.reset();
};
Webr.component.VerticalLayouter.prototype.checkOrientation = function (maxHeight) {
  var maxVisibleHeightDown = this.getMaxVisibleHeight(false);
  var toDown = maxVisibleHeightDown - maxHeight < 0 ?false :true;
  if (toDown) {
    this.todown(maxVisibleHeightDown, maxHeight);
  } else {
    var maxVisibleHeightUp = this.getMaxVisibleHeight(true);
    if (maxVisibleHeightUp < maxHeight) {
      if (maxVisibleHeightDown < maxVisibleHeightUp) {
        this.toup(maxVisibleHeightUp, maxHeight);
      } else {
        this.todown(maxVisibleHeightDown, maxHeight);
      }

    } else {
      this.toup(maxVisibleHeightUp, maxHeight);
    }

  }

};
Webr.component.VerticalLayouter.prototype.getMaxVisibleHeight = function (toUp) {
  var anchor = this.config.anchor;
  var top = anchor.offset().top;
  var padding = top - $(window).scrollTop();
  if (!toUp) {
    padding = $(window).height() - anchor.outerHeight(true) - padding;
  }

  var res = Math.max(0, padding);
  return res;
};
Webr.component.VerticalLayouter.prototype.reset = function () {
  Webr.stateMachine.stateMachineRuntime.handleEvent(this, "reset", arguments);
};
Webr.component.VerticalLayouter.prototype.fix = function (width, height) {
  Webr.stateMachine.stateMachineRuntime.handleEvent(this, "fix", arguments);
};
Webr.component.VerticalLayouter.prototype.toup = function (maxHeight, preffered) {
  Webr.stateMachine.stateMachineRuntime.handleEvent(this, "toup", arguments);
};
Webr.component.VerticalLayouter.prototype.todown = function (maxHeight, preffered) {
  Webr.stateMachine.stateMachineRuntime.handleEvent(this, "todown", arguments);
};
Webr.component.VerticalLayouter.state_INITIAL = {name: "INITIAL", fix: function (width, height) {
  if (true) {
    this.checkOrientation(height);
    return ;
  }

  return false;
}, todown: function (maxHeight, preffered) {
  if (true) {
    this.config.move(Webr.component.Layouter.DOWN, maxHeight, preffered);
    return Webr.component.VerticalLayouter.state_OPEN_DOWN;
  }

  return false;
}, toup: function (maxHeight, preffered) {
  if (true) {
    this.config.move(Webr.component.Layouter.UP, maxHeight, preffered);
    return Webr.component.VerticalLayouter.state_OPEN_UP;
  }

  return false;
}};
Webr.component.VerticalLayouter.state_OPEN_DOWN = {name: "OPEN_DOWN", reset: function () {
  if (true) {
    this._reset();
    return Webr.component.VerticalLayouter.state_INITIAL;
  }

  return false;
}};
Webr.component.VerticalLayouter.state_OPEN_UP = {name: "OPEN_UP", reset: function () {
  if (true) {
    this._reset();
    return Webr.component.VerticalLayouter.state_INITIAL;
  }

  return false;
}};
