Webr.component.MultiBoxComponent = function (element, renderer) {
  Webr.component.MultiBoxComponent.superclass.constructor.call(this, element, renderer);
  var it = this;
  var checkHandler = function (option) {
    it.toggleOption(option);
    it.setFocusNoEvents();
  };
  this.setCheckHandler(checkHandler);
  if (it.mainElement.attr("noclick")) {
    this.setClickHandler(checkHandler);
  } else {
    this.setClickHandler(jQuery.proxy(this.mOptionClicked, this));
  }

  this.initApplyButton();
  var div = $(document.createElement("div")).addClass("morePlaceholder");
  var moreText = it.mainElement.attr("showMore");
  this.showMoreOnEmpty = it.mainElement.attr("showMoreOnEmpty");
  var span = $(document.createElement("span")).html(moreText || "And more");
  div.append(span);
  this.morePlaceholder = div;
  if (moreText) {
    renderer.addExtraContent(this.morePlaceholder);
  }

};
{
  var F = new Function();
  F.prototype = Webr.component.ComboBoxComponent.prototype;
  Webr.component.MultiBoxComponent.prototype = new F();
  Webr.component.MultiBoxComponent.prototype.constructor = Webr.component.MultiBoxComponent;
  Webr.component.MultiBoxComponent.superclass = Webr.component.ComboBoxComponent.prototype;
}

Webr.component.MultiBoxComponent.prototype.initApplyButton = function () {
  var it = this;
  this.applyButton = $(document.createElement("div"));
  this.applyButton.html(l10n('${l10n("MultiBoxComponent.js.Apply")}'));
  this.applyButton.addClass("applyButton");
  this.applyButton.click(jQuery.proxy(this.applyButtonClicked, this));
  this.applyButton.hide();
  this.renderer.getInputElement().after(this.applyButton);
};
Webr.component.MultiBoxComponent.prototype.createHighlighter = function (message) {
  return new Webr.component.MultiBoxHighlighter(this, message);
};
Webr.component.MultiBoxComponent.prototype.setCheckHandler = function (f) {
  this.checkHandler = f;
};
Webr.component.MultiBoxComponent.prototype.setClickHandler = function (f) {
  this.clickHandler = f;
};
Webr.component.MultiBoxComponent.prototype.showOptions = function () {
  this.setFocusNoEvents();
  this.onShowOptions();
};
Webr.component.MultiBoxComponent.prototype.fireKeyDown = function (e) {
  if (e.isKey(Webr.util.Key.SPACE)) {
    var item = this.dataList.getCurrentItem();
    if (item) {
      item.toggleCheck();
      this.toggleOption(item.option);
      return false;
    }

  }

  return Webr.component.MultiBoxComponent.superclass.fireKeyDown.call(this, e);
};
Webr.component.MultiBoxComponent.prototype.hideOptions = function () {
  this.applyButton.hide();
  this.setCurrent(this.defaultCheckedIds, false);
  this.onHideOptions();
};
Webr.component.MultiBoxComponent.prototype.reset = function () {
  this.setCurrent(this.defaultCheckedIds, true);
  this.inputElement.removeAttribute("valueId");
  this.sync();
  this.blur();
  this.drop();
};
Webr.component.MultiBoxComponent.prototype.update = function (options, checkedIds, size, from, to, hidePaganation, pageSize, exactSize) {
  var it = this;
  this.defaultCheckedIds = (checkedIds && checkedIds.slice()) || [];
  if (!this.currentCheckedIds) {
    this.currentCheckedIds = this.defaultCheckedIds.slice();
  }

  checkedIds = this.currentCheckedIds;
    

  jQuery.each(options, function (idx, o) {
    if (checkedIds.indexOf(o.id) >= 0) {
      o.checked = true;
    }

  });
    

  if (!(this.dataList)) {
    var list;
    var config = {clickHandler: this.clickHandler, checkHandler: this.checkHandler, circle: this.mainElement.attr("nocircle") ?false :true};
    if (size !== undefined) {
      //TODO: Support remote load for multibox
      list = new Webr.component.RemoteDataList(this, config);
    } else {
      list = new Webr.component.MemoryDataList(config);
    }

    list.addNoMatchOption(new Webr.component.MultiBoxListItem(this.noMatch));
    this.dataList = list;
  }

  if (hidePaganation) {
    this.pager && this.pager.hide();
  } else if (size !== undefined) {
    this.updatePager(from, to, size, pageSize, exactSize);
    this.pager.show();
  }

    

  //Update list
  this.dataList.update(options, function (o) {
    return new Webr.component.MultiBoxListItem(o);
  });
  if (hidePaganation && !(exactSize)) {
    this.morePlaceholder.show();
  } else {
    if (this.showMoreOnEmpty && (!(this.searchContext) || this.searchContext === "")) {
      this.morePlaceholder.show();
    } else {
      this.morePlaceholder.hide();
    }

  }

  //Render list
  this.renderList();
  //Call event after loading
  this.loaded();
};
Webr.component.MultiBoxComponent.prototype.sync = function () {
  //do nothing
};
Webr.component.MultiBoxComponent.prototype.setCurrent = function (current, updateInput) {
  if (this.searchContext.length > 0) {
    this.setSearchContext("");
    this.inputElement.setValueNoEvents("");
  }

  //Clone array if it has different addresses with current
  this.currentCheckedIds = current != this.currentCheckedIds ?current.slice() :current;
  this.dataList.unselectCurrent(true);
  //TODO: make it optimal
  this.dataList.forEach(function (item) {
    item.setChecked(jQuery.inArray(item.option.id, current) !== -1);
  });
  if (updateInput) {
    //Clone array
    this.defaultCheckedIds = current.slice();
    this.updateInputValueId(this.getCheckedRepresentation());
  }

};
Webr.component.MultiBoxComponent.prototype.toggleOption = function (option) {
  option.checked ?this.check(option) :this.uncheck(option);
  this.applyButton.show();
};
Webr.component.MultiBoxComponent.prototype.check = function (option) {
  this.onselect(option);
  this.currentCheckedIds.push(option.id);
};
Webr.component.MultiBoxComponent.prototype.uncheck = function (option) {
  this.onunselect(option);
  this.currentCheckedIds.splice(jQuery.inArray(option.id, this.currentCheckedIds), 1);
};
Webr.component.MultiBoxComponent.prototype.getCheckedRepresentation = function () {
  return this.currentCheckedIds.toString();
};
Webr.component.MultiBoxComponent.prototype.submit = function (option) {
  //Check that narrowed is current
  if (this.searchContext !== this.inputElement.value) {
    this.valueChange();
  }

  var currents = this.currentCheckedIds;
  //TODO: Add submit of new option
  if (option) {
    currents = [option.id];
  }

  this.setCurrent(currents, true);
  this.onchange();
  this.fire(function (l) {
    l.submitted(option);
  });
};
Webr.component.MultiBoxComponent.prototype.updatePager = function (from, to, size, pageSize, exactSize) {
  if (!this.pager) {
    var it = this;
    this.pager = new Webr.component.Pager(function (skip) {
      it.moreClicked(skip);
    }, function (skip) {
      it.lessClicked(skip);
    });
  }

  this.pager.update(from, to, size, pageSize, exactSize);
};
Webr.component.MultiBoxComponent.prototype.onselect = function (option) {
  this.mainElement.trigger("select", {option: option.id});
};
Webr.component.MultiBoxComponent.prototype.onunselect = function (option) {
  this.mainElement.trigger("unselect", {option: option.id});
};
Webr.component.MultiBoxComponent.CB_COMPONENT_DATA = "_combo_component_data_";
Webr.component.MultiBoxComponent.register = function (path, comboboxSuffixName) {
  cr.forEach(path, comboboxSuffixName, function () {
    var e = $(this);
    var bindToId = e.attr("bid");
    var ff = function () {
      if (bindToId) {
        return new Webr.component.MultiBoxComponentBind(e.get(0), document.getElementById(bindToId));
      }

      return new Webr.component.MultiBoxComponent(e.get(0));
    };
    if (bindToId) {
      var bindTo = $(document.getElementById(bindToId));
      var _f = function (e) {
        //ignore click to links & images
        if (e.targetIs(["A", "IMG"]) && e.target != bindTo.get(0)) {
          bindTo.one("click", _f);
        } else {
          ff().toggle();
          return false;
        }

      };
      bindTo.one("click", _f);
    } else {
      var div = e.children("div");
      var input = div.children("input");
      var a = div.siblings("a");
      //e is input 
      input.one("focus", function () {
        ff().focus();
      });
      //downarrow near input
      a.one("click", function () {
        //if combobox inited - focus and show options
        ff().toggle();
      });
    }

  });
};
Webr.component.MultiBoxComponent.register2 = function (element, e) {
  //Used hack if click is called from jQuery in Chrome it can not contain any events
  var evt = e || window.event || {};
  var target = $(evt.srcElement ?evt.srcElement :evt.target);
  if (target && target.matches(["A", "IMG"]) && !(target.equals($(element).children()))) {
    return true;
  }

  var div = $(element).data(Webr.component.MultiBoxComponent.CB_COMPONENT_DATA) || $(element).next("div");
  var combo = $(div).data(Webr.component.ComponentRegistry.COMPONENT_INSTANCE);
  if (!combo) {
    $(element).data(Webr.component.MultiBoxComponent.CB_COMPONENT_DATA, div.get(0));
    combo = new Webr.component.MultiBoxComponentBind(div.get(0), $(element).children().get(0));
    div.bind("ShowOptions", function () {
      $(element).children().addClass("active");
    }).bind("HideOptions", function () {
      $(element).children().removeClass("active");
    });
    $(element).unbind("click");
  }

  combo.toggle();
  return false;
};
Webr.component.MultiBoxComponent.safeFocus = function (combo) {
  var c;
  if (combo.finalize) {
    c = combo.jQinputElement;
  } else {
    c = $(combo).find("input");
  }

  c.focus();
  c.select();
};
Webr.component.MultiBoxComponent.safeReset = function (combo) {
  var c;
  if (combo.reset) {
    c = combo.reset();
  }

};
Webr.component.MultiBoxListItem = function (option) {
  Webr.component.MultiBoxListItem.superclass.constructor.call(this, option);
};
{
  var F = new Function();
  F.prototype = Webr.component.DataListItem.prototype;
  Webr.component.MultiBoxListItem.prototype = new F();
  Webr.component.MultiBoxListItem.prototype.constructor = Webr.component.MultiBoxListItem;
  Webr.component.MultiBoxListItem.superclass = Webr.component.DataListItem.prototype;
}

Webr.component.MultiBoxListItem.prototype.createElement = function () {
  var li = $(document.createElement("li"));
  this.el = li;
  li.addClass(this.option.styleClass);
  if (this.option.id === Webr.component.ComboOption.NO_MATCH_ID || this.option.id === Webr.component.ComboOption.NEW_OPTION_ID) {
    this.hide();
  } else {
    var checkBox = $(document.createElement("span"));
    checkBox.html("&nbsp;").addClass("checkbox").addClass(this.option.checked ?"checked" :"unchecked");
    li.append(checkBox);
    this.checkBox = $(checkBox);
  }

  var label = $(document.createElement("span"));
  if (this.option.h) {
    label.html(this.option.text);
  } else {
    label.text(this.option.text);
  }

  this.textElement = $(label);
  li.append(label);
};
Webr.component.MultiBoxListItem.prototype.check = function () {
  this.checkBox.click();
};
Webr.component.MultiBoxListItem.prototype.getTextElement = function () {
  return this.textElement;
};
Webr.component.MultiBoxListItem.prototype.toggleCheck = function () {
  this.option.checked = !this.option.checked;
  this.checkBox.toggleClass("checked").toggleClass("unchecked");
};
Webr.component.MultiBoxListItem.prototype._check = function () {
  this.option.checked = true;
  this.checkBox.removeClass("unchecked").addClass("checked");
};
Webr.component.MultiBoxListItem.prototype._uncheck = function () {
  this.option.checked = false;
  this.checkBox.removeClass("checked").addClass("unchecked");
};
Webr.component.MultiBoxListItem.prototype.setChecked = function (checked) {
  if (this.option.id !== Webr.component.ComboOption.NO_MATCH_ID) {
    checked ?this._check() :this._uncheck();
  }

};
Webr.component.MultiBoxListItem.prototype.registerClickHandler = function (handler) {
  var it = this;
  this.el.click(function (event) {
    it.toggleCheck();
    handler.call(it, it.option);
    return false;
  });
};
Webr.component.MultiBoxListItem.prototype.registerCheckHandler = function (handler) {
  var it = this;
  this.checkBox.click(function (event) {
    it.toggleCheck();
    handler.call(it, it.option);
    return false;
  });
};
var regMBC = Webr.component.MultiBoxComponent.register;
var regMBC2 = Webr.component.MultiBoxComponent.register2;
