Webr.component.ToolTip = function (watchElement, elementToolTip, config) {
  this.delay = 5;
  this.delta = Webr.component.ToolTip.DELTA;
  this.appended = false;
  this.watchElementPos = null;
  this.current_state = null;
  this.watchElement = $(watchElement);
  this.container = $(elementToolTip);
  this.config = config;
  this.init();
  this.registerEvents();
  this.current_state = Webr.component.ToolTip.state_INACTIVE;
};
Webr.component.ToolTip.prototype.init = function () {
  var css = "tooltip";
  if (this.config.showOnTop) {
    this.delta = 0;
    this.arrow = new ToolTipArrow(this.container);
    css = "tooltip" + " " + "tooltip-inline";
  }

  this.container.addClass(css);
};
Webr.component.ToolTip.prototype.registerEvents = function () {
  var t = this;
  this.mouseOverHandler = function () {
    t.mover();
  };
  this.mouseOutHandler = function () {
    t.mout();
  };
  this.mouseMoveHandler = function (event) {
    t.mmove(event.pageX, event.pageY);
  };
  this.watchElement.mouseover(this.mouseOverHandler);
  this.watchElement.mouseout(this.mouseOutHandler);
  this.watchElement.mousemove(this.mouseMoveHandler);
};
Webr.component.ToolTip.prototype.unregisterEvents = function () {
  this.watchElement.unbind("mouseover", this.mouseOverHandler);
  this.watchElement.unbind("mouseout", this.mouseOutHandler);
  this.watchElement.unbind("mousemove", this.mouseMoveHandler);
};
Webr.component.ToolTip.prototype.startTimer = function () {
  var it = this;
  this.timer = window.setTimeout(function () {
    it.timeOut();
  }, it.delay);
};
Webr.component.ToolTip.prototype.cancelTimer = function () {
  window.clearTimeout(this.timer);
};
Webr.component.ToolTip.prototype.startTicker = function () {
  if (!this.ticker) {
    var it = this;
    this.ticker = window.setInterval(function () {
      it.timeTick();
    }, this.delay);
  }

};
Webr.component.ToolTip.prototype.stopTicker = function () {
  if (this.ticker) {
    window.clearInterval(this.ticker);
    this.ticker = null;
  }

};
Webr.component.ToolTip.prototype.saveCurrentPosition = function (x, y) {
  if (!(this.config.showOnTop)) {
    this.x = x;
    this.y = y;
  }

};
Webr.component.ToolTip.prototype.setTopPosition = function () {
  if (this.config.showOnTop) {
    var pos = this.watchElement.offset();
    if (this.watchElementPos == undefined || Webr.component.ToolTip.posistonNotEqual(this.watchElementPos, pos)) {
      this.watchElementPos = pos;
      //TODO: move to variables/ calculate on changeText() only
      var tooltipHeight = this.container.outerHeight();
      var tooltipWidth = this.container.outerWidth();
      var targetWidth = this.watchElement.outerWidth();
      this.y = pos.top - tooltipHeight - 5;
      this.x = pos.left - (tooltipWidth - targetWidth) / 2;
    }

    this.setArrowPosition();
  }

};
Webr.component.ToolTip.prototype.move = function () {
  this.setTopPosition();
  this.container.css({"top": this.y + this.delta, "left": this.x});
};
Webr.component.ToolTip.prototype.show = function () {
  if (!this.appended) {
    $(document.body).append(this.container);
    this.appended = true;
  }

  this.move();
  this.container.show();
};
Webr.component.ToolTip.prototype.changeText = function (text, shown) {
  var textContainer = this.container.children("." + "tooltip-text");
  if (textContainer.get(0)) {
    textContainer.text(text);
  } else {
    this.container.append($(document.createElement("span")).addClass("tooltip-text").text(text));
  }

  this.watchElementPos = null;
  if (shown) {
    this.move();
  }

};
Webr.component.ToolTip.prototype.setArrowPosition = function () {
  if (this.arrow) {
    this.arrow.setLeftPosition();
  }

};
Webr.component.ToolTip.prototype.hide = function () {
  this.container.fadeOut(100);
};
Webr.component.ToolTip.prototype.mover = function () {
  Webr.stateMachine.stateMachineRuntime.handleEvent(this, "mover", arguments);
};
Webr.component.ToolTip.prototype.mout = function () {
  Webr.stateMachine.stateMachineRuntime.handleEvent(this, "mout", arguments);
};
Webr.component.ToolTip.prototype.mmove = function (x, y) {
  Webr.stateMachine.stateMachineRuntime.handleEvent(this, "mmove", arguments);
};
Webr.component.ToolTip.prototype.timeTick = function () {
  Webr.stateMachine.stateMachineRuntime.handleEvent(this, "timeTick", arguments);
};
Webr.component.ToolTip.prototype.timeOut = function () {
  Webr.stateMachine.stateMachineRuntime.handleEvent(this, "timeOut", arguments);
};
Webr.component.ToolTip.prototype.changetext = function (newText) {
  Webr.stateMachine.stateMachineRuntime.handleEvent(this, "changetext", arguments);
};
Webr.component.ToolTip.DELTA = 18;
Webr.component.ToolTip.state_INACTIVE = {name: "INACTIVE", mmove: function (x, y) {
  if (true) {
    this.saveCurrentPosition(x, y);
        {
      Webr.stateMachine.stateMachineRuntime.handleOnEnter(this, Webr.component.ToolTip.state_PAUSED);
    }

    return Webr.component.ToolTip.state_PAUSED;
  }

  return false;
}, changetext: function (newText) {
  if (true) {
    this.changeText(newText);
    return ;
  }

  return false;
}};
Webr.component.ToolTip.state_PAUSED = {name: "PAUSED", onenter: function () {
  this.startTimer();
}, onexit: function () {
  this.cancelTimer();
}, mout: function () {
  if (true) {
        {
      Webr.stateMachine.stateMachineRuntime.handleOnExit(this, Webr.component.ToolTip.state_PAUSED);
    }

    return Webr.component.ToolTip.state_INACTIVE;
  }

  return false;
}, timeOut: function () {
  if (true) {
    this.show();
        {
      Webr.stateMachine.stateMachineRuntime.handleOnExit(this, Webr.component.ToolTip.state_PAUSED);
    }

        {
      Webr.stateMachine.stateMachineRuntime.handleOnEnter(this, Webr.component.ToolTip.state_SHOWN);
    }

    return Webr.component.ToolTip.state_SHOWN;
  }

  return false;
}, changetext: function (newText) {
  if (true) {
    this.changeText(newText);
    return ;
  }

  return false;
}};
Webr.component.ToolTip.state_SHOWN = {name: "SHOWN", onenter: function () {
  this.startTicker();
}, onexit: function () {
  this.stopTicker();
}, timeTick: function () {
  if (this.config.followCursor) {
    this.move();
    return ;
  }

  return false;
}, mout: function () {
  if (true) {
    this.hide();
        {
      Webr.stateMachine.stateMachineRuntime.handleOnExit(this, Webr.component.ToolTip.state_SHOWN);
    }

    return Webr.component.ToolTip.state_INACTIVE;
  }

  return false;
}, mmove: function (x, y) {
  if (this.config.followCursor) {
    this.saveCurrentPosition(x, y);
    return ;
  }

  return false;
}, changetext: function (newText) {
  if (true) {
    this.changeText(newText, true);
    return ;
  }

  return false;
}};
Webr.component.ToolTip.register = function (path, compName, followCursor) {
  cr.forEach(path, compName, function () {
    var overlap = false;
    var el = $(this);
    var attachTo = document.getElementById(el.attr("bid"));
    $(attachTo).one("mouseover", function () {
      var toolTip = new Webr.component.ToolTip($(attachTo), el.get(0), {followCursor: followCursor, showOnTop: false}).mover();
    });
  });
};
Webr.component.ToolTip.destroy = function (tooltip) {
  if (tooltip && tooltip.container) {
    tooltip.unregisterEvents();
    $(tooltip.container).remove();
    delete tooltip;
  }

};
Webr.component.ToolTip.posistonNotEqual = function (pos1, pos2) {
  return pos1.left != pos2.left || pos1.top != pos2.top ?true :false;
};
Webr.component.ToolTipConfig = function () {
  this.showOnTop = false;
};
var regtt = Webr.component.ToolTip.register;




var ToolTipArrow = {};
ToolTipArrow = function (container) {
  this.container = container;
  this.create();
};
ToolTipArrow.prototype.create = function () {
  if (this.container) {
    this.arrow = $(document.createElement("span")).addClass("tooltip-arrow-south");
    this.container.append(this.arrow);
    this.setLeftPosition();
  }

};
ToolTipArrow.prototype.setLeftPosition = function () {
  var width = this.container.outerWidth();
  this.arrowLeft = width / 2 - ToolTipArrow.offset;
  this.arrow.css("left", this.arrowLeft);
};
ToolTipArrow.offset = 4.5;
