jQuery.prototype.scrollTo = function (container, indents) {
  indents = indents || [0, 0];
  var hScroll = false;
  var it = this.get(0);
  container = container === window ?null :container;
  var wrapper = $(container ?container :window);
  var bounds = [wrapper.scrollLeft(), wrapper.scrollTop(), wrapper.width(), wrapper.height()];
  var moveX = 0;
  var moveY = 0;
    

  //horizontal
  if (hScroll) {
    var elementWidth = container ?this.width() :this.outerWidth(true);
    var offsetLeft = container ?it.offsetLeft :this.offset().left;
    var diffX = offsetLeft + elementWidth - bounds[0] - bounds[2];
    if (diffX > 0) {
      moveX = (bounds[2] < elementWidth ?offsetLeft - bounds[0] :diffX) + indents[0];
    } else {
      var windowLeft = bounds[0] + indents[0];
      moveX = windowLeft > offsetLeft ?offsetLeft - windowLeft :moveX;
    }

  }

    

  //vertical
  var elementHeight = container ?this.height() :this.outerHeight(true);
  var offsetTop = container ?it.offsetTop :this.offset().top;
  var diffY = offsetTop + elementHeight - bounds[1] - bounds[3];
  if (diffY > 0) {
    moveY = (bounds[3] < elementHeight ?offsetTop - bounds[1] :diffY) + indents[1];
  } else {
    var windowTop = bounds[1] + indents[1];
    moveY = windowTop > offsetTop ?offsetTop - windowTop :moveY;
  }

  wrapper.scrollLeft(bounds[0] + moveX);
  wrapper.scrollTop(bounds[1] + moveY);
  return this;
};
jQuery.prototype.scrollToFast = function (container, indents) {
  indents = indents || [0, 0];
  var hScroll = false;
  var it = this.get(0);
  container = container === window ?null :container;
    

  var bounds;
  //Get bounds fast (do not use jQuery)
  if (Webr.util.Util.isIE) {
    //Has questions? Check this out: http://www.softcomplex.com/docs/get_window_size_and_scrollbar_position.html
    bounds = [Math.max(document.body.scrollLeft, document.documentElement.scrollLeft), Math.max(document.body.scrollTop, document.documentElement.scrollTop), Math.min(document.body.clientWidth, document.documentElement.clientWidth), Math.min(document.body.clientHeight, document.documentElement.clientHeight)];
  } else {
    bounds = [window.pageXOffset, window.pageYOffset, window.innerWidth, window.innerHeight];
  }

    

  var moveX = 0;
  var moveY = 0;
  //horizontal scroll
  if (hScroll) {
    var elementWidth = Math.max(it.scrollWidth, it.clientWidth);
    var offsetLeft = Webr.util.Util.isIE ?it.offsetLeft + it.parentNode.offsetLeft :it.offsetLeft;
    var diffX = offsetLeft + elementWidth - bounds[0] - bounds[2];
    if (diffX > 0) {
      moveX = (bounds[2] < elementWidth ?offsetLeft - bounds[0] :diffX) + indents[0];
    } else {
      var windowLeft = bounds[0] + indents[0];
      moveX = windowLeft > offsetLeft ?offsetLeft - windowLeft :moveX;
    }

  }

  //vertical scroll
  var elementHeight = Math.max(it.scrollHeight, it.clientHeight);
  var offsetTop = Webr.util.Util.isIE ?it.offsetTop + it.parentNode.offsetTop :it.offsetTop;
  var diffY = offsetTop + elementHeight - bounds[1] - bounds[3];
  if (diffY > 0) {
    moveY = (bounds[3] < elementHeight ?offsetTop - bounds[1] :diffY) + indents[1];
  } else {
    var windowTop = bounds[1] + indents[1];
    moveY = windowTop > offsetTop ?offsetTop - windowTop :moveY;
  }

    

  if (container) {
    container.scrollLeft = bounds[0] + moveX;
    container.scrollTop = bounds[1] + moveY;
  } else {
    window.scrollTo(bounds[0] + moveX, bounds[1] + moveY);
  }

  return this;
};
jQuery.prototype.addRefreshListener = function (listener) {
  //TODO: Make unbind and bind possible
  var cPath = this.get(0).id;
  if (cPath) {
    //get component path without name
    cPath = cPath.substring(3, cPath.lastIndexOf("."));
    var trueListener = {beforeRefresh: function (path) {
      if (cPath.indexOf(path) === 0) {
        listener();
        Webr.event.RefreshCommandProcessor.removeListener(trueListener);
      }

    }};
    Webr.event.RefreshCommandProcessor.addListener(trueListener);
  }

};
jQuery.prototype.title = function (title) {
  var t = this.get(0);
  if (t && t.title) {
    t.title = title;
  }

  return this;
};
jQuery.prototype.maxVisibleHeight = function () {
  var it = this.get(0);
  var top = $(it).offset().top;
  var edge = $(window).height() + $(window).scrollTop();
  var res = Math.min(this.height(), Math.max(0, edge - top));
  return res;
};
jQuery.prototype.ancestorOf = function (expr, reflective) {
  var a = $(expr);
  if (this.length != 1 || a.length != 1) {
    throw "More then one element or empty element.";
  }

  var child = a.get(0);
  var parent = this.get(0);
  if (reflective && child == parent) {
    return true;
  }

  if (parent["contains"] && !Webr.util.Util.isWebkit) {
    return parent["contains"](child);
  } else {
    var _parent = child.parentNode;
    while (_parent) {
      if (_parent == parent) {
        return true;
      }

      if (!_parent.tagName || parent.tagName.toLowerCase() == "html") {
        return false;
      }

      _parent = _parent.parentNode;
    }

    return false;
  }

};
jQuery.prototype.relativeOffset = function () {
  var top = 0;
  var left = 0;
  var jqOffset = this.offset();
  var elem = this.parent();
  while (elem[0] && elem[0] !== document.body && elem[0] !== this[0].ownerDocument.documentElement) {
    if (elem.css("position") == "relative") {
      top = elem[0].offsetTop;
      left = elem[0].offsetLeft;
            break;

    }

    elem = elem.parent();
  }

  jqOffset.top = top > 0 ?top :jqOffset.top;
  jqOffset.left = left > 0 ?left :jqOffset.left;
  return jqOffset;
};
jQuery.prototype.keyrepeatable = function (handler) {
  if (Webr.util.Util.isIE || Webr.util.Util.isWebkit || Webr.util.Util.isOpera) {
    this.keydown(handler);
  } else {
    this.keypress(handler);
  }

};
jQuery.prototype.setVisible = function (visible) {
  if (visible) {
    this.show();
  } else {
    this.hide();
  }

};
jQuery.prototype.matches = function (tags) {
  for (var i = 0; i < tags.length; i += 1) {
    if (this.is(tags[i].toLowerCase())) {
      return true;
    }

  }

  return false;
};
jQuery.prototype.equals = function (element) {
  var el = element.length > 0 ?element.get(0) :element;
  return this.get(0) === el;
};
jQuery.PositionConfig = function () {
};
