Webr.component.panel.TabPanel = function (panel) {
  Webr.component.panel.TabPanel.superclass.constructor.call(this, panel);
};
{
  var F = new Function();
  F.prototype = Webr.component.panel.AbstractPanel.prototype;
  Webr.component.panel.TabPanel.prototype = new F();
  Webr.component.panel.TabPanel.prototype.constructor = Webr.component.panel.TabPanel;
  Webr.component.panel.TabPanel.superclass = Webr.component.panel.AbstractPanel.prototype;
}

Webr.component.panel.TabPanel.prototype.init = function () {
  this.tabs = this.panel.find("." + "jt-tabpanel-item");
  this.tabPanels = this.panel.find("." + "jt-tabpanel-content" + " > div");
  this.watchState = this.panel.attr("watchstate");
  //active tab
  this.activeTabIndex = -1;
  if (this.watchState) {
    //active from window.location
    this.activeTabIndex = this._findTabIndexById(Webr.util.PageStateStore.getInstance().get(this.watchState));
  }

  var defaultTab = this.panel.attr("activeTab");
  if (defaultTab) {
    defaultTab = this._findTabIndexById(defaultTab);
  } else {
    defaultTab = 0;
  }

  if (this.activeTabIndex < 0) {
    this.activeTabIndex = defaultTab;
  }

  if (!this.activeTabIndex || this.activeTabIndex < 0) {
    this.activeTabIndex = 0;
  }

  this.activeTitle = this.tabs.eq(this.activeTabIndex);
  // active panel
  this.activePanel = this.tabPanels.eq(this.activeTabIndex);
  //register click
  var it = this;
  this.tabs.click(function () {
    it.activateTab(it.tabs.index(this));
    return false;
  });
  //active attr
  if (defaultTab != this.activeTabIndex) {
    this.activateTab(this.activeTabIndex);
  } else {
    this.activateCurrent();
  }

};
Webr.component.panel.TabPanel.prototype._findTabIndexById = function (id) {
  var index = -1;
  this.tabs.each(function (i) {
    if ($(this).attr("tabid") === id) {
      index = i;
      return ;
    }

  });
  return index;
};
Webr.component.panel.TabPanel.prototype.activateTab = function (index, doNotUpdateHash) {
  if (index > this.tabs.length) {
    throw "Index is out of bounds";
  }

  if (this.activeTabIndex != index) {
    this.activeTitle.removeClass("jt-panel-active");
    this.activePanel.removeClass("jt-panel-active").addClass("jt-panel-inactive");
    this.tabdeactivate(this.activeTabIndex);
    this.activeTabIndex = index;
  }

  this.activeTitle = this.tabs.eq(index).addClass("jt-panel-active");
  this.activePanel = this.tabPanels.eq(index).removeClass("jt-panel-inactive").addClass("jt-panel-active");
  this.tabactivate(index);
  //update hash
  //we don't need update hash after change in history
  if (!doNotUpdateHash) {
    this.updateHash(this.activeTitle.attr("tabid"));
  }

};
Webr.component.panel.TabPanel.prototype.activateCurrent = function () {
  this.activeTitle.addClass("jt-panel-active");
  this.activePanel.removeClass("jt-panel-inactive").addClass("jt-panel-active");
};
Webr.component.panel.TabPanel.prototype.historyChanged = function (token) {
  var tabIndex;
  if (token && token.current) {
    tabIndex = this._findTabIndexById(token.current);
  }

  if (isNaN(tabIndex)) {
    tabIndex = parseInt(this.panel.attr("activeTab"));
    tabIndex = isNaN(tabIndex) ?0 :tabIndex;
  }

  if (tabIndex !== this.activeTabIndex && tabIndex < this.tabs.length && tabIndex >= 0) {
    this.activateTab(tabIndex, true);
  }

};
Webr.component.panel.TabPanel.prototype.updateHash = function (tabName) {
  if (this.watchState) {
    Webr.util.PageStateStore.getInstance().put(this.watchState, tabName);
  }

};
Webr.component.panel.TabPanel.prototype.tabactivate = function (index) {
  this.panel.trigger("tabactivate", {index: index, tabId: this.activeTitle.attr("tabid")});
};
Webr.component.panel.TabPanel.prototype.tabdeactivate = function (index) {
  this.panel.trigger("tabdeactivate", {index: index, tabId: this.activeTitle.attr("tabid")});
};
Webr.component.panel.TabPanel.registerTabPanel = function (path, name) {
  cr.forEach(path, name, function () {
    new Webr.component.panel.TabPanel($(this));
  });
};
var regtab = Webr.component.panel.TabPanel.registerTabPanel;
