Webr.util.PageStateStore = function () {
  Webr.util.PageStateStore.superclass.constructor.call(this);
  this.params = new Webr.util.Map();
  var it = this;
  this.parser = new Webr.util.HashParametersParser(window.location.hash, this);
  this.update();
};
{
  var F = new Function();
  F.prototype = Webr.util.HashParameterListener.prototype;
  Webr.util.PageStateStore.prototype = new F();
  Webr.util.PageStateStore.prototype.constructor = Webr.util.PageStateStore;
  Webr.util.PageStateStore.superclass = Webr.util.HashParameterListener.prototype;
}

Webr.util.PageStateStore.prototype.get = function (key) {
  return this.params.get(key.toLowerCase());
};
Webr.util.PageStateStore.prototype.put = function (key, value) {
  //params are updated by history dispatcher
  this.formLocation(null, key.toLowerCase(), value);
};
Webr.util.PageStateStore.prototype.removeKey = function (key) {
  //params are updated by history dispatcher
  this.formLocation(key.toLowerCase(), null, null);
};
Webr.util.PageStateStore.prototype.update = function () {
  delete this.params;
  this.params = new Webr.util.Map();
  this.parser.setInputString(window.location.hash);
  this.parser.parse();
};
Webr.util.PageStateStore.prototype.getParams = function () {
  return this.params;
};
Webr.util.PageStateStore.prototype.parameter = function (key, value) {
  this.params.put(decodeURIComponent(key).toLowerCase(), decodeURIComponent(value));
};
Webr.util.PageStateStore.prototype.formLocation = function (removeKey, addKey, addValue) {
  var hashString = [];
  this.params.forEach(function (key, value) {
    if (key != removeKey) {
      hashString.push(encodeURIComponent(key));
      hashString.push("=");
      if (key == addKey) {
        value = addValue;
        addKey = null;
      }

      if (value != null) {
        hashString.push(encodeURIComponent(value));
      }

      hashString.push("&");
    }

  });
  if (addKey) {
    hashString.push(encodeURIComponent(addKey));
    hashString.push("=");
    if (addValue != null) {
      hashString.push(encodeURIComponent(addValue));
    }

  } else {
    //Remove trailing "&"
    hashString.pop();
  }

  var hash = hashString.length > 0 ?hashString.join("") :" ";
  if (Webr.util.Util.isSafari) {
    window.location = window.location.href.split("#")[0] + "#" + hash;
  } else {
    window.location.hash = hash;
  }

};
Webr.util.PageStateStore.getInstance = function () {
  if (!Webr.util.PageStateStore.map) {
    Webr.util.PageStateStore.map = new Webr.util.PageStateStore();
  }

  return Webr.util.PageStateStore.map;
};
