/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.javascript.runtime.jsDependencies;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jetbrains.exodus.core.dataStructures.hash.HashSet;
import jetbrains.exodus.core.dataStructures.hash.LinkedHashSet;
import jetbrains.mps.baseLanguage.closures.runtime.YieldingIterator;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.ITranslator2;
import jetbrains.mps.internal.collections.runtime.IVisitor;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.internal.collections.runtime.MapSequence;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.webr.javascript.runtime.jsDependencies.JsDependency;
import jetbrains.mps.webr.javascript.runtime.jsDependencies.JsDependencyAggregator;
import jetbrains.mps.webr.javascript.runtime.jsDependencies.UrlGetter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JsDependencyManager {
    protected static Log log = LogFactory.getLog(JsDependencyManager.class);
    private Map<String, JsDependency> dependencies;

    public void setAggregators(List<JsDependencyAggregator> aggregators) {
        if (this.dependencies == null) {
            this.dependencies = MapSequence.fromMap(new HashMap());
        }
        ListSequence.fromList(aggregators).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<JsDependencyAggregator>(){

            public void visit(JsDependencyAggregator agg) {
                ListSequence.fromList(agg.getDependencies()).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<JsDependency>(){

                    public void visit(JsDependency dep) {
                        MapSequence.fromMap((Map)JsDependencyManager.this.dependencies).put((Object)dep.getName(), (Object)dep);
                    }
                });
            }
        });
    }

    public void setDependencies(List<JsDependency> dependencies) {
        if (this.dependencies == null) {
            this.dependencies = MapSequence.fromMap(new HashMap());
        }
        ListSequence.fromList(dependencies).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<JsDependency>(){

            public void visit(JsDependency it) {
                MapSequence.fromMap((Map)JsDependencyManager.this.dependencies).put((Object)it.getName(), (Object)it);
            }
        });
    }

    public Iterable<UrlGetter> toUrlGetters(Iterable<String> jsRoots) {
        return Sequence.fromIterable(jsRoots).translate((_FunctionTypes._return_P1_E0)new ITranslator2<String, UrlGetter>(){

            public Iterable<UrlGetter> translate(final String it) {
                return new Iterable<UrlGetter>(){

                    @Override
                    public Iterator<UrlGetter> iterator() {
                        return new YieldingIterator<UrlGetter>(){
                            private int __CP__ = 0;
                            private JsDependency _3_dependency;

                            protected boolean moveToNext() {
                                block7: while (true) {
                                    switch (this.__CP__) {
                                        case -1: {
                                            assert (false) : "Internal error";
                                            return false;
                                        }
                                        case 4: {
                                            if (this._3_dependency != null) {
                                                this.__CP__ = 5;
                                                continue block7;
                                            }
                                            this.__CP__ = 1;
                                            continue block7;
                                        }
                                        case 6: {
                                            this.__CP__ = 1;
                                            this.yield(this._3_dependency.getUrlGetter());
                                            return true;
                                        }
                                        case 0: {
                                            this._3_dependency = JsDependencyManager.this.getDependency(it);
                                            this.__CP__ = 4;
                                            continue block7;
                                        }
                                        case 5: {
                                            this.__CP__ = 6;
                                            continue block7;
                                        }
                                    }
                                    break;
                                }
                                return false;
                            }
                        };
                    }
                };
            }
        });
    }

    public Iterable<String> toUrls(Iterable<String> jsRoots) {
        return Sequence.fromIterable(jsRoots).translate((_FunctionTypes._return_P1_E0)new ITranslator2<String, String>(){

            public Iterable<String> translate(final String it) {
                return new Iterable<String>(){

                    @Override
                    public Iterator<String> iterator() {
                        return new YieldingIterator<String>(){
                            private int __CP__ = 0;
                            private JsDependency _3_dependency;

                            protected boolean moveToNext() {
                                block7: while (true) {
                                    switch (this.__CP__) {
                                        case -1: {
                                            assert (false) : "Internal error";
                                            return false;
                                        }
                                        case 4: {
                                            if (this._3_dependency != null) {
                                                this.__CP__ = 5;
                                                continue block7;
                                            }
                                            this.__CP__ = 1;
                                            continue block7;
                                        }
                                        case 6: {
                                            this.__CP__ = 1;
                                            this.yield(this._3_dependency.getUrlGetter().getUrl());
                                            return true;
                                        }
                                        case 0: {
                                            this._3_dependency = JsDependencyManager.this.getDependency(it);
                                            this.__CP__ = 4;
                                            continue block7;
                                        }
                                        case 5: {
                                            this.__CP__ = 6;
                                            continue block7;
                                        }
                                    }
                                    break;
                                }
                                return false;
                            }
                        };
                    }
                };
            }
        });
    }

    public boolean containsDependency(String jsRoot) {
        return MapSequence.fromMap(this.dependencies).get((Object)jsRoot) != null;
    }

    public Set<String> sortDependencies(Iterable<String> dependencyNames, Set<String> exceptJsRoots) {
        HashSet closedJsRoots = new HashSet();
        this.closeDependecies((Set<String>)closedJsRoots, dependencyNames, exceptJsRoots);
        LinkedHashSet sortedJsRoots = new LinkedHashSet();
        this.sortJsRoots((Set<String>)sortedJsRoots, (Iterable<String>)closedJsRoots, (Set<String>)new HashSet(), exceptJsRoots);
        return sortedJsRoots;
    }

    private void closeDependecies(Set<String> closedJsRoots, Iterable<String> jsRoots, Set<String> exceptJsRoots) {
        for (String jsRoot : Sequence.fromIterable(jsRoots)) {
            JsDependency dependency;
            if (exceptJsRoots != null && exceptJsRoots.contains(jsRoot) || !closedJsRoots.add(jsRoot) || (dependency = this.getDependency(jsRoot)) == null) continue;
            this.closeDependecies(closedJsRoots, dependency.getCompileTimeDeps(), exceptJsRoots);
            this.closeDependecies(closedJsRoots, dependency.getRunTimeDeps(), exceptJsRoots);
        }
    }

    private void sortJsRoots(Set<String> sortedJsRoots, Iterable<String> jsRoots, Set<String> visitedRoots, Set<String> exceptJsRoots) {
        for (String jsRoot : Sequence.fromIterable(jsRoots)) {
            if (exceptJsRoots != null && exceptJsRoots.contains(jsRoot) || sortedJsRoots.contains(jsRoot)) continue;
            if (visitedRoots.contains(jsRoot)) {
                if (!log.isErrorEnabled()) continue;
                log.error((Object)("JS compile-time cycle detected " + visitedRoots + ", " + jsRoot));
                continue;
            }
            JsDependency dependency = this.getDependency(jsRoot);
            if (dependency == null) continue;
            visitedRoots.add(jsRoot);
            this.sortJsRoots(sortedJsRoots, dependency.getCompileTimeDeps(), visitedRoots, exceptJsRoots);
            visitedRoots.remove(jsRoot);
            sortedJsRoots.add(jsRoot);
        }
    }

    private JsDependency getDependency(String jsRoot) {
        JsDependency dependency = (JsDependency)MapSequence.fromMap(this.dependencies).get((Object)jsRoot);
        if (dependency == null && log.isErrorEnabled()) {
            log.error((Object)("Dependency config for " + jsRoot + " was not found. Its model is not generated or reference to its model is not added to init spring configuration"));
        }
        return dependency;
    }
}

