/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.rpc.rest.provider.exception;

import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import jetbrains.mps.internal.collections.runtime.IMapping;
import jetbrains.mps.internal.collections.runtime.MapSequence;
import jetbrains.mps.webr.rpc.rest.provider.exception.ErrorBean;
import jetbrains.mps.webr.rpc.rest.runtime.Provider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import webr.framework.controller.BaseApplication;

public abstract class BaseExceptionMapper<T extends Throwable>
implements ExceptionMapper<T>,
Provider {
    protected static Log log = LogFactory.getLog(BaseExceptionMapper.class);
    private final Class<T> mappedExceptionClass;

    public BaseExceptionMapper(Class<T> mappedExceptionClass) {
        this.mappedExceptionClass = mappedExceptionClass;
    }

    public Response toResponse(T exception) {
        String tag;
        Response.StatusType status = this.getStatus(exception);
        this.logError(exception, status);
        Response.ResponseBuilder builder = Response.status((Response.StatusType)status);
        for (IMapping key : MapSequence.fromMap(this.getHeaders(exception))) {
            builder.header((String)key.key(), key.value());
        }
        Object entity = this.getEntity(exception);
        if (entity != null) {
            builder.entity(entity);
        }
        if ((tag = this.getTag()) != null && tag.length() > 0) {
            builder.tag(tag);
        }
        return builder.build();
    }

    public Object getEntity(T exception) {
        return new ErrorBean((Throwable)exception, this.getStatus(exception).getStatusCode());
    }

    public String getTag() {
        return null;
    }

    public Class<T> getMappedExceptionClass() {
        return this.mappedExceptionClass;
    }

    public void logError(T exception, Response.StatusType status) {
        if (this.shouldPrintStacktrace(status) && log.isWarnEnabled()) {
            log.warn((Object)("REST exception for URL: " + BaseApplication.getRequest().getRequestURI()), exception);
        }
    }

    public boolean shouldPrintStacktrace(Response.StatusType status) {
        switch (status.getStatusCode()) {
            case 401: {
                return false;
            }
            case 403: {
                return false;
            }
            case 404: {
                return false;
            }
            case 406: {
                return false;
            }
            case 409: {
                return false;
            }
        }
        return true;
    }

    public abstract Response.StatusType getStatus(T var1);

    public Map<String, Object> getHeaders(T exception) {
        return MapSequence.fromMap(new HashMap());
    }
}

