/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.rpc.rest.provider.exception;

import java.io.IOException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import javax.xml.bind.UnmarshalException;
import jetbrains.mps.webr.rpc.rest.provider.exception.BaseExceptionMapper;
import jetbrains.mps.webr.rpc.rest.provider.exception.ErrorBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Provider
public class WebApplicationExceptionMapper
extends BaseExceptionMapper<WebApplicationException> {
    protected static Log log = LogFactory.getLog(WebApplicationExceptionMapper.class);

    public WebApplicationExceptionMapper() {
        super(WebApplicationException.class);
    }

    @Override
    public Response toResponse(WebApplicationException e) {
        Response response = e.getResponse();
        if (response == null || response.getEntity() == null) {
            response = super.toResponse(e);
        } else if (this.shouldPrintStacktrace(this.getStatus(e)) && log.isErrorEnabled()) {
            log.error((Object)"Exception while processing rest request", (Throwable)e);
        }
        return response;
    }

    @Override
    public Response.StatusType getStatus(WebApplicationException e) {
        return e.getResponse() != null ? Response.Status.fromStatusCode((int)e.getResponse().getStatus()) : Response.Status.BAD_REQUEST;
    }

    @Override
    public Object getEntity(WebApplicationException exception) {
        Response.StatusType status;
        UnmarshalException unmarshalException;
        Throwable linkedException;
        Object message = exception.getCause() instanceof UnmarshalException ? ((linkedException = (unmarshalException = (UnmarshalException)exception.getCause()).getLinkedException()) != null ? (linkedException instanceof IOException ? "invalid input data format" : linkedException.getMessage()) : unmarshalException.getMessage()) : ((status = this.getStatus(exception)) != null ? new ErrorBean(status.getReasonPhrase(), status.getStatusCode()) : super.getEntity(exception));
        return message;
    }
}

