/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.rpc.rest.provider.readerWriter;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.MapSequence;
import jetbrains.mps.webr.rpc.rest.runtime.Provider;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.CharUtils;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.glassfish.jersey.message.internal.AbstractMessageReaderWriterProvider;

@Produces(value={"text/plain", "*/*"})
@Consumes(value={"text/plain", "*/*"})
@javax.ws.rs.ext.Provider
public class PrimititveMessageReaderWriterProvider<T>
extends AbstractMessageReaderWriterProvider<T>
implements Provider {
    private static final Map<Class, _FunctionTypes._return_P1_E0<? extends Object, ? super String>> READERS = MapSequence.fromMap(new LinkedHashMap(16, 0.75f, false));

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        type = ClassUtils.primitiveToWrapper(type);
        return MapSequence.fromMap(READERS).containsKey((Object)type);
    }

    public T readFrom(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        String stringValue = PrimititveMessageReaderWriterProvider.readFromAsString((InputStream)entityStream, (MediaType)mediaType);
        if (type.isPrimitive()) {
            type = ClassUtils.primitiveToWrapper(type);
        } else if (stringValue == null || stringValue.length() == 0) {
            return null;
        }
        return (T)((_FunctionTypes._return_P1_E0)MapSequence.fromMap(READERS).get((Object)type)).invoke((Object)stringValue);
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return MapSequence.fromMap(READERS).containsKey(type);
    }

    public void writeTo(T t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        String stringValue = String.valueOf(t);
        PrimititveMessageReaderWriterProvider.writeToAsString((String)stringValue, (OutputStream)entityStream, (MediaType)mediaType);
    }

    static {
        MapSequence.fromMap(READERS).put(Byte.class, (Object)new _FunctionTypes._return_P1_E0<Byte, String>(){

            public Byte invoke(String v) {
                return (byte)NumberUtils.toInt((String)v);
            }
        });
        MapSequence.fromMap(READERS).put(Short.class, (Object)new _FunctionTypes._return_P1_E0<Short, String>(){

            public Short invoke(String v) {
                return (short)NumberUtils.toInt((String)v);
            }
        });
        MapSequence.fromMap(READERS).put(Integer.class, (Object)new _FunctionTypes._return_P1_E0<Integer, String>(){

            public Integer invoke(String v) {
                return NumberUtils.toInt((String)v);
            }
        });
        MapSequence.fromMap(READERS).put(Long.class, (Object)new _FunctionTypes._return_P1_E0<Long, String>(){

            public Long invoke(String v) {
                return NumberUtils.toLong((String)v);
            }
        });
        MapSequence.fromMap(READERS).put(Character.class, (Object)new _FunctionTypes._return_P1_E0<Character, String>(){

            public Character invoke(String v) {
                return Character.valueOf(CharUtils.toChar((String)v));
            }
        });
        MapSequence.fromMap(READERS).put(Float.class, (Object)new _FunctionTypes._return_P1_E0<Float, String>(){

            public Float invoke(String v) {
                return Float.valueOf(NumberUtils.toFloat((String)v));
            }
        });
        MapSequence.fromMap(READERS).put(Double.class, (Object)new _FunctionTypes._return_P1_E0<Double, String>(){

            public Double invoke(String v) {
                return NumberUtils.toDouble((String)v);
            }
        });
        MapSequence.fromMap(READERS).put(Boolean.class, (Object)new _FunctionTypes._return_P1_E0<Boolean, String>(){

            public Boolean invoke(String v) {
                return BooleanUtils.toBoolean((String)v);
            }
        });
    }
}

