/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.runtime.builderContext;

import java.util.Stack;

public final class BuilderThreadContext {
    private static final ThreadLocal<Stack<BuilderThreadContext>> BUILDER_THREAD_CONTEXT = new ThreadLocal();
    private final boolean myHasLocalLinks;

    private BuilderThreadContext(boolean hasLocalLinks) {
        this.myHasLocalLinks = hasLocalLinks;
        Stack<BuilderThreadContext> context = BUILDER_THREAD_CONTEXT.get();
        if (context == null) {
            context = new Stack();
            BUILDER_THREAD_CONTEXT.set(context);
        }
        context.push(this);
    }

    public static void initNonLocalBuilderThreadContext() {
        new BuilderThreadContext(false);
    }

    public static void close() {
        Stack<BuilderThreadContext> context = BUILDER_THREAD_CONTEXT.get();
        if (context != null) {
            if (context.isEmpty()) {
                BUILDER_THREAD_CONTEXT.remove();
            } else {
                context.pop();
                if (context.isEmpty()) {
                    BUILDER_THREAD_CONTEXT.remove();
                }
            }
        }
    }

    public static BuilderThreadContext getBuilderThreadContext() {
        Stack<BuilderThreadContext> context = BUILDER_THREAD_CONTEXT.get();
        return context == null ? null : context.peek();
    }

    public boolean hasLocalLinks() {
        return this.myHasLocalLinks;
    }
}

