/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.runtime.component;

import jetbrains.mps.webr.runtime.component.BaseHtmlTemplate;
import jetbrains.mps.webr.runtime.templateComponent.TemplateComponent;
import webr.framework.runtime.response.CommandResponseAction;
import webr.framework.runtime.response.CommandScriptor;
import webr.framework.runtime.response.JsCommandResponse;
import webr.framework.textBuilder.TBuilderContext;

public class HtmlTemplate
extends BaseHtmlTemplate {
    public static JsCommandResponse refresh(final TemplateComponent component) {
        if (component == null) {
            return null;
        }
        Boolean isNotLoaded = component.isTemplateNotLoaded();
        if (isNotLoaded != null && isNotLoaded.booleanValue()) {
            return null;
        }
        return CommandResponseAction.create(new CommandScriptor(){

            @Override
            public void generateScript(TBuilderContext builderContext) {
                builderContext.appendIndent();
                builderContext.append("<command type=\"refresh\" target=\"");
                builderContext.append(component.getTemplatePath());
                builderContext.append("\" targetId=\"");
                builderContext.append(component.getRefreshElementId());
                builderContext.append("\"><![CDATA[");
                builderContext.appendNewLine();
                builderContext.appendIndent();
                builderContext.appendIndent();
                builderContext.append(component.getRefreshContent());
                builderContext.appendNewLine();
                builderContext.appendNewLine();
                builderContext.appendNewLine();
                builderContext.append("]]></command>");
                builderContext.appendNewLine();
            }
        }, false, "refresh" + component.getRefreshElementId());
    }

    public static JsCommandResponse load(final TemplateComponent component) {
        if (component == null) {
            return null;
        }
        Boolean isNotLoaded = component.isTemplateNotLoaded();
        if (isNotLoaded != null && isNotLoaded.booleanValue()) {
            component.setTemplateNotLoaded(false);
            return CommandResponseAction.create(new CommandScriptor(){

                @Override
                public void generateScript(TBuilderContext builderContext) {
                    builderContext.appendIndent();
                    builderContext.append("<command type=\"refresh\" target=\"");
                    builderContext.append(component.getTemplatePath());
                    builderContext.append("\" targetId=\"");
                    builderContext.append(component.getRefreshElementId());
                    builderContext.append("\"><![CDATA[");
                    builderContext.appendNewLine();
                    builderContext.appendIndent();
                    builderContext.appendIndent();
                    builderContext.append(component.getRefreshContent());
                    builderContext.appendNewLine();
                    builderContext.appendNewLine();
                    builderContext.appendNewLine();
                    builderContext.append("]]></command>");
                    builderContext.appendNewLine();
                }
            }, false, "refresh" + component.getRefreshElementId());
        }
        return null;
    }

    public static JsCommandResponse unload(final TemplateComponent component) {
        if (component == null) {
            return null;
        }
        Boolean isNotLoaded = component.isTemplateNotLoaded();
        if (isNotLoaded != null && isNotLoaded.booleanValue()) {
            return null;
        }
        component.setTemplateNotLoaded(true);
        return CommandResponseAction.create(new CommandScriptor(){

            @Override
            public void generateScript(TBuilderContext builderContext) {
                builderContext.appendIndent();
                builderContext.append("<command type=\"refresh\" target=\"");
                builderContext.append(component.getTemplatePath());
                builderContext.append("\" targetId=\"");
                builderContext.append(component.getRefreshElementId());
                builderContext.append("\"><![CDATA[");
                builderContext.appendNewLine();
                builderContext.appendIndent();
                builderContext.appendIndent();
                builderContext.append(component.getRefreshContent());
                builderContext.appendNewLine();
                builderContext.appendNewLine();
                builderContext.appendNewLine();
                builderContext.append("]]></command>");
                builderContext.appendNewLine();
            }
        }, false, "refresh" + component.getRefreshElementId());
    }
}

