/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.runtime.converter;

import jetbrains.mps.webr.runtime.converter.FixedClassConverter;
import jetbrains.mps.webr.runtime.converter.LocalizedWrongFormatException;
import jetbrains.mps.webr.runtime.converter.NullConvertException;

public class DoubleConverter
extends FixedClassConverter {
    public DoubleConverter() {
        super(Double.TYPE);
    }

    @Override
    public String toString(Object value) {
        return this.doToString((Double)value);
    }

    private String doToString(double value) {
        return String.valueOf(value);
    }

    @Override
    public Object fromString(String typeName, String valueAsString) {
        if (valueAsString == null) {
            throw new NullConvertException(typeName);
        }
        try {
            return Double.parseDouble(valueAsString);
        }
        catch (NumberFormatException e) {
            throw new LocalizedWrongFormatException(typeName, "jetbrains.webr_dnq.double_converter_format_exception", valueAsString);
        }
    }
}

