/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.runtime.converter;

import jetbrains.mps.webr.runtime.converter.TypeConverter;
import jetbrains.mps.webr.runtime.converter.WrongFormatException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EnumerationConverter
implements TypeConverter {
    protected static Log log = LogFactory.getLog(EnumerationConverter.class);

    @Override
    public boolean accepts(String typeName) {
        try {
            return Class.forName(typeName, true, Thread.currentThread().getContextClassLoader()).isEnum();
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public String toString(Object value) {
        return "" + value;
    }

    @Override
    public Object fromString(String typeName, String valueAsString) {
        if ("".equals(valueAsString)) {
            valueAsString = null;
        }
        if (valueAsString == null) {
            return null;
        }
        try {
            return Enum.valueOf(Class.forName(typeName, true, Thread.currentThread().getContextClassLoader()), valueAsString);
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Enum covert error", (Throwable)e);
            }
            throw new WrongFormatException(typeName, typeName, valueAsString);
        }
    }
}

