/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.runtime.converter;

import jetbrains.mps.webr.runtime.converter.FixedClassConverter;
import jetbrains.mps.webr.runtime.converter.LocalizedWrongFormatException;
import jetbrains.mps.webr.runtime.converter.NullConvertException;

public class FloatConverter
extends FixedClassConverter {
    public FloatConverter() {
        super(Float.TYPE);
    }

    @Override
    public String toString(Object value) {
        return this.doToString(((Float)value).floatValue());
    }

    private String doToString(float value) {
        return String.valueOf(value);
    }

    @Override
    public Object fromString(String typeName, String valueAsString) {
        if (valueAsString == null) {
            throw new NullConvertException(typeName);
        }
        try {
            return Float.valueOf(Float.parseFloat(valueAsString));
        }
        catch (NumberFormatException e) {
            throw new LocalizedWrongFormatException(typeName, "jetbrains.webr_dnq.double_converter_format_exception", valueAsString);
        }
    }
}

